/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.saguaro;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class SaguaroGenerator
implements IWorldGenerator {
    public final IBlockState saguaro;
    public final boolean findGround;
    public final boolean isBaby;
    private Random rand;
    private World world;
    private BlockPos basePos = BlockPos.field_177992_a;

    public SaguaroGenerator(IBlockState saguaro, boolean findGround, boolean isBaby) {
        this.saguaro = saguaro;
        this.findGround = findGround;
        this.isBaby = isBaby;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    public void generateSaguaro(Random random, World worldIn, BlockPos position) {
        this.world = worldIn;
        if (this.findGround) {
            this.basePos = this.findGround(worldIn, position);
            if (position.func_177956_o() < 0) {
                return;
            }
            if (!this.blocksMatch(worldIn, position)) {
                return;
            }
        } else {
            this.basePos = position;
        }
        this.rand = new Random(random.nextLong());
        if (this.validSaguaroLocation()) {
            this.generateSaguaro();
        }
        this.world = null;
    }

    void generateSaguaro() {
        if (this.rand.nextInt(20) == 0) {
            this.generateCactusTree();
        } else {
            this.generateSmallCactus();
        }
    }

    void generateCactusTree() {
        int height;
        for (height = 0; height < 6; ++height) {
            this.setBlock(this.basePos.func_177981_b(height));
        }
        this.setBlock(this.basePos.func_177981_b(2).func_177974_f());
        this.setBlock(this.basePos.func_177981_b(2).func_177976_e());
        this.setBlock(this.basePos.func_177981_b(2).func_177968_d());
        this.setBlock(this.basePos.func_177981_b(2).func_177978_c());
        for (height = 0; height < 2; ++height) {
            BlockPos pos = this.basePos.func_177981_b(height + 2);
            this.setBlock(pos.func_177965_g(2));
            this.setBlock(pos.func_177985_f(2));
            this.setBlock(pos.func_177970_e(2));
            this.setBlock(pos.func_177964_d(2));
            pos = this.basePos.func_177981_b(height + 3);
            this.setBlock(pos.func_177965_g(3));
            this.setBlock(pos.func_177985_f(3));
            this.setBlock(pos.func_177970_e(3));
            this.setBlock(pos.func_177964_d(3));
            pos = this.basePos.func_177981_b(height + 5);
            this.setBlock(pos.func_177974_f());
            this.setBlock(pos.func_177976_e());
            this.setBlock(pos.func_177968_d());
            this.setBlock(pos.func_177978_c());
        }
    }

    void generateSmallCactus() {
        int branch;
        int size;
        int height = this.rand.nextInt(4) + 3;
        for (int i = 0; i < height; ++i) {
            this.setBlock(this.basePos.func_177981_b(i));
        }
        int branchY = height >= 5 ? 2 : 1;
        BlockPos pos = this.basePos.func_177981_b(branchY);
        if (this.rand.nextBoolean()) {
            size = this.rand.nextInt(height - branchY) + branchY - this.rand.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.setBlock(pos.func_177981_b(branch).func_177974_f());
            }
        }
        if (this.rand.nextBoolean()) {
            size = this.rand.nextInt(height - branchY) + branchY - this.rand.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.setBlock(pos.func_177981_b(branch).func_177976_e());
            }
        }
        if (this.rand.nextBoolean()) {
            size = this.rand.nextInt(height - branchY) + branchY - this.rand.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.setBlock(pos.func_177981_b(branch).func_177968_d());
            }
        }
        if (this.rand.nextBoolean()) {
            size = this.rand.nextInt(height - branchY) + branchY - this.rand.nextInt(3);
            for (branch = 0; branch < size; ++branch) {
                this.setBlock(pos.func_177981_b(branch).func_177978_c());
            }
        }
    }

    void setBlock(BlockPos pos) {
        if (!this.world.func_180495_p(pos).func_185914_p()) {
            this.world.func_180501_a(pos, this.saguaro, 2);
        }
    }

    BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = 0;
        int height = pos.func_177956_o();
        if (world.func_175624_G() == WorldType.field_77138_c && this.isBaby) {
            do {
                BlockPos position;
                Block block;
                if (!((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) instanceof BlockSand) || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
                returnHeight = height + 1;
                break;
            } while (--height > Config.flatSeaLevel);
        } else {
            do {
                BlockPos position;
                Block block;
                if (!((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) instanceof BlockSand) || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
                returnHeight = height + 1;
                break;
            } while (--height > Config.seaLevel);
        }
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    private boolean blocksMatch(World world, BlockPos pos) {
        Block underBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return underBlock instanceof BlockSand;
    }

    private boolean validSaguaroLocation() {
        BlockPos down = this.basePos.func_177977_b();
        IBlockState currentState = this.world.func_180495_p(this.basePos);
        Block currentBlock = currentState.func_177230_c();
        IBlockState stateBelow = this.world.func_180495_p(down);
        Block blockBelow = stateBelow.func_177230_c();
        if (!this.world.func_175623_d(this.basePos)) {
            if (currentBlock == NaturaOverworld.saguaroBaby) {
                return blockBelow.canSustainPlant(stateBelow, (IBlockAccess)this.world, down, EnumFacing.UP, (IPlantable)NaturaOverworld.saguaro);
            }
            return false;
        }
        return blockBelow.canSustainPlant(stateBelow, (IBlockAccess)this.world, down, EnumFacing.UP, (IPlantable)NaturaOverworld.saguaro);
    }
}

