/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.retrogen;

import com.google.common.collect.LinkedListMultimap;
import com.progwml6.natura.Natura;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.world.worldgen.CloudGenerator;
import com.progwml6.natura.world.worldgen.CropGenerator;
import com.progwml6.natura.world.worldgen.GlowshroomGenerator;
import com.progwml6.natura.world.worldgen.NetherBerryBushesGenerator;
import com.progwml6.natura.world.worldgen.NetherMinableGenerator;
import com.progwml6.natura.world.worldgen.NetherTreesGenerator;
import com.progwml6.natura.world.worldgen.OverworldBerryBushesGenerator;
import com.progwml6.natura.world.worldgen.OverworldTreesGenerator;
import com.progwml6.natura.world.worldgen.VineGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TickHandlerWorldRetrogen {
    public static final TickHandlerWorldRetrogen INSTANCE = new TickHandlerWorldRetrogen();
    private final LinkedListMultimap<Integer, ChunkCoords> chunkRegenList = LinkedListMultimap.create();
    private OverworldTreesGenerator overworldTreesGenerator;
    private OverworldBerryBushesGenerator overworldBerryBushesGenerator;
    private CloudGenerator cloudGenerator;
    private CropGenerator cropGenerator;
    private NetherTreesGenerator netherTreesGenerator;
    private NetherBerryBushesGenerator netherBerryBushesGenerator;
    private GlowshroomGenerator glowshroomGenerator;
    private VineGenerator vineGenerator;
    private NetherMinableGenerator netherMineableGenerator;

    public TickHandlerWorldRetrogen() {
        if (Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
            this.overworldTreesGenerator = new OverworldTreesGenerator();
            this.overworldBerryBushesGenerator = new OverworldBerryBushesGenerator();
            this.cloudGenerator = new CloudGenerator();
            this.cropGenerator = new CropGenerator();
        }
        if (Natura.pulseManager.isPulseLoaded("NaturaNether")) {
            this.netherTreesGenerator = new NetherTreesGenerator();
            this.netherBerryBushesGenerator = new NetherBerryBushesGenerator();
            this.glowshroomGenerator = new GlowshroomGenerator();
            this.vineGenerator = new VineGenerator();
            this.netherMineableGenerator = new NetherMinableGenerator();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Config.doRetrogen) {
            World world = event.world;
            int dimensionID = world.field_73011_w.getDimension();
            List chunkList = this.chunkRegenList.get((Object)dimensionID);
            if (!chunkList.isEmpty()) {
                ChunkCoords coords = (ChunkCoords)chunkList.get(0);
                chunkList.remove(0);
                long worldSeed = world.func_72905_C();
                Random random = new Random(worldSeed);
                long xSeed = random.nextLong() >> 3;
                long zSeed = random.nextLong() >> 3;
                random.setSeed(xSeed * (long)coords.xCoord + zSeed * (long)coords.zCoord ^ worldSeed);
                if (Natura.pulseManager.isPulseLoaded("NaturaOverworld")) {
                    this.overworldTreesGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                    this.overworldBerryBushesGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                    if (Config.enableCloudBlocks) {
                        this.cloudGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                    }
                    this.cropGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                }
                if (Natura.pulseManager.isPulseLoaded("NaturaNether")) {
                    this.netherTreesGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                    this.netherBerryBushesGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                    this.glowshroomGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                    this.vineGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                    this.netherMineableGenerator.retroGen(random, coords.xCoord, coords.zCoord, world);
                }
            }
        }
    }

    @SubscribeEvent
    public void chunkSaveEventHandler(ChunkDataEvent.Save event) {
        NBTTagCompound tag = new NBTTagCompound();
        if (Config.doRetrogen) {
            tag.func_74757_a("retrogen", true);
        }
        event.getData().func_74782_a("NaturaWorld", (NBTBase)tag);
    }

    @SubscribeEvent
    public void chunkLoadEventHandler(ChunkDataEvent.Load event) {
        NBTTagCompound tag;
        if (Config.doRetrogen && !(tag = (NBTTagCompound)event.getData().func_74781_a("NaturaWorld")).func_74764_b("retrogen")) {
            ChunkCoords coords = new ChunkCoords(event.getChunk());
            this.chunkRegenList.put((Object)coords.dimension, (Object)coords);
        }
    }

    private static class ChunkCoords {
        public final int dimension;
        public final int xCoord;
        public final int zCoord;

        public ChunkCoords(Chunk chunk) {
            this.dimension = chunk.func_177412_p().field_73011_w.getDimension();
            this.xCoord = chunk.field_76635_g;
            this.zCoord = chunk.field_76647_h;
        }
    }
}

