/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.clouds;

import com.progwml6.natura.common.config.Config;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class CloudsGenerator
implements IWorldGenerator {
    public final int cloudSize;
    public final IBlockState cloud;
    public final boolean flatCloud;

    public CloudsGenerator(int cloudSize, IBlockState cloud, boolean flatCloud) {
        this.cloudSize = cloudSize;
        this.cloud = cloud;
        this.flatCloud = flatCloud;
    }

    public CloudsGenerator(int cloudSize, IBlockState cloud) {
        this(cloudSize, cloud, false);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    public void generateCloud(Random random, World world, BlockPos pos) {
        if (Config.generateLegacyClouds) {
            this.generateLegacyCloud(random, world, pos);
            return;
        }
        int xRand = random.nextInt(3) - 1;
        int zRand = random.nextInt(3) - 1;
        for (int block = 0; block < this.cloudSize; ++block) {
            int xIter = pos.func_177958_n() + (random.nextInt(3) - 1) + xRand;
            int yIter = pos.func_177956_o();
            int zIter = pos.func_177952_p() + (random.nextInt(3) - 1) + zRand;
            if (random.nextBoolean() && !this.flatCloud || this.flatCloud && random.nextInt(10) == 0) {
                yIter = pos.func_177956_o() + random.nextInt(3) - 1;
            }
            for (int x = xIter; x < xIter + random.nextInt(4) + 3 * (this.flatCloud ? 3 : 1); ++x) {
                int mathX = xIter - x;
                for (int y = yIter; y < yIter + random.nextInt(1) + 2; ++y) {
                    int mathY = yIter - y;
                    for (int z = zIter; z < zIter + random.nextInt(4) + 3 * (this.flatCloud ? 3 : 1); ++z) {
                        BlockPos blockpos;
                        IBlockState state;
                        int mathZ = zIter - z;
                        if (Math.abs(mathX) + Math.abs(mathY) + Math.abs(mathZ) >= 4 * (this.flatCloud ? 3 : 1) + random.nextInt(2) || (state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c() != Blocks.field_150350_a) continue;
                        world.func_180501_a(blockpos, this.cloud, 2);
                    }
                }
            }
        }
    }

    public void generateLegacyCloud(Random random, World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int l = random.nextInt(3) - 1;
        int i1 = random.nextInt(3) - 1;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int j1 = 0; j1 < this.cloudSize; ++j1) {
            x += random.nextInt(3) - 1 + l;
            z += random.nextInt(3) - 1 + i1;
            if (random.nextBoolean() && !this.flatCloud || this.flatCloud && random.nextInt(10) == 0) {
                y += random.nextInt(3) - 1;
            }
            for (int xIter = x; xIter < x + random.nextInt(4) + 3 * (this.flatCloud ? 3 : 1); ++xIter) {
                for (int yIter = y; yIter < y + random.nextInt(1) + 2; ++yIter) {
                    for (int zIter = z; zIter < z + random.nextInt(4) + 3 * (this.flatCloud ? 3 : 1); ++zIter) {
                        blockPos.func_181079_c(xIter, yIter, zIter);
                        if (!world.func_175623_d((BlockPos)blockPos) || Math.abs(xIter - x) + Math.abs(yIter - y) + Math.abs(zIter - z) >= 4 * (this.flatCloud ? 3 : 1) + random.nextInt(2)) continue;
                        world.func_180501_a((BlockPos)blockPos, this.cloud, 2);
                    }
                }
            }
        }
    }
}

