/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.berry.overworld;

import com.progwml6.natura.common.block.BlockEnumBerryBush;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.berry.BaseBerryBushGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class OverworldBerryBushGenerator
extends BaseBerryBushGenerator {
    public final int spawnHeight;
    public final IBlockState berryBush;

    public OverworldBerryBushGenerator(int spawnHeight, IBlockState berryBush) {
        this.spawnHeight = spawnHeight;
        this.berryBush = berryBush;
    }

    @Override
    public void generateBush(Random random, World world, BlockPos pos) {
        if ((pos = this.findGround(world, pos)).func_177956_o() < 0) {
            return;
        }
        int yPos = pos.func_177956_o();
        if (yPos >= 1) {
            int size = random.nextInt(10);
            if (size == 9) {
                this.generateLargeNode(random, world, pos);
            } else if (size >= 7) {
                this.generateShrub(random, world, pos);
            } else if (size >= 3) {
                this.generateSmallNode(random, world, pos);
            } else {
                this.generateTinyNode(random, world, pos);
            }
        }
    }

    protected void generateLargeNode(Random random, World world, BlockPos pos) {
        BlockPos blockpos;
        int iterY;
        int iterZ;
        int iterX;
        for (iterX = pos.func_177958_n() - 2; iterX <= pos.func_177958_n() + 2; ++iterX) {
            for (iterZ = pos.func_177952_p() - 1; iterZ <= pos.func_177952_p() + 1; ++iterZ) {
                for (iterY = pos.func_177956_o() - 1; iterY <= pos.func_177956_o(); ++iterY) {
                    blockpos = new BlockPos(iterX, iterY, iterZ);
                    this.setBlockAndMetadata(world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                }
            }
        }
        for (iterX = pos.func_177958_n() - 1; iterX <= pos.func_177958_n() + 1; ++iterX) {
            for (iterZ = pos.func_177952_p() - 2; iterZ <= pos.func_177952_p() - 2; ++iterZ) {
                for (iterY = pos.func_177956_o() - 1; iterY <= pos.func_177956_o(); ++iterY) {
                    blockpos = new BlockPos(iterX, iterY, iterZ);
                    this.setBlockAndMetadata(world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                }
            }
        }
        for (iterX = pos.func_177958_n() - 1; iterX <= pos.func_177958_n() + 1; ++iterX) {
            for (iterZ = pos.func_177952_p() + 2; iterZ <= pos.func_177952_p() + 2; ++iterZ) {
                for (iterY = pos.func_177956_o() - 1; iterY <= pos.func_177956_o(); ++iterY) {
                    blockpos = new BlockPos(iterX, iterY, iterZ);
                    this.setBlockAndMetadata(world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                }
            }
        }
        for (iterX = pos.func_177958_n() - 1; iterX <= pos.func_177958_n() + 1; ++iterX) {
            for (iterZ = pos.func_177952_p() - 1; iterZ <= pos.func_177952_p() + 1; ++iterZ) {
                int yPos = pos.func_177956_o() + 1;
                blockpos = new BlockPos(iterX, yPos, iterZ);
                this.setBlockAndMetadata(world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                yPos = pos.func_177956_o() - 2;
                blockpos = new BlockPos(iterX, yPos, iterZ);
                this.setBlockAndMetadata(world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
            }
        }
    }

    protected void generateShrub(Random random, World world, BlockPos pos) {
        IBlockState state;
        Block block;
        while (((block = (state = world.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos)) && (pos = pos.func_177977_b()).func_177956_o() > 0) {
        }
        state = world.func_180495_p(pos);
        block = state.func_177230_c();
        boolean isSoil = block.canSustainPlant(state, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldBerryBushBlackberry);
        if (isSoil) {
            pos.func_177984_a();
            for (int y = pos.func_177956_o(); y <= pos.func_177956_o() + 2; ++y) {
                int subtract = y - pos.func_177956_o();
                int subtract2 = 2 - subtract;
                for (int x = pos.func_177958_n() - subtract2; x <= pos.func_177958_n() + subtract2; ++x) {
                    int mathX = x - pos.func_177958_n();
                    for (int z = pos.func_177952_p() - subtract2; z <= pos.func_177952_p() + subtract2; ++z) {
                        int mathZ = z - pos.func_177952_p();
                        BlockPos blockpos = new BlockPos(x, y, z);
                        IBlockState blockState = world.func_180495_p(blockpos);
                        Block blockFromState = state.func_177230_c();
                        if (Math.abs(mathX) == subtract2 && Math.abs(mathZ) == subtract2 && (random.nextInt(2) == 0 || !blockFromState.canBeReplacedByLeaves(blockState, (IBlockAccess)world, blockpos))) continue;
                        this.setBlockAndMetadata(world, blockpos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
                    }
                }
            }
        }
    }

    protected void generateSmallNode(Random random, World world, BlockPos pos) {
        this.setBlockAndMetadata(world, pos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomFullAge(random))));
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(world, pos.func_177974_f(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(world, pos.func_177976_e(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(world, pos.func_177968_d(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
        if (random.nextBoolean()) {
            this.setBlockAndMetadata(world, pos.func_177978_c(), this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
        }
    }

    protected void generateTinyNode(Random random, World world, BlockPos pos) {
        this.setBlockAndMetadata(world, pos, this.berryBush.func_177226_a((IProperty)BlockEnumBerryBush.AGE, (Comparable)Integer.valueOf(this.randomAge(random))));
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState stateNew) {
        if (!world.func_180495_p(pos).func_185914_p()) {
            world.func_180501_a(pos, stateNew, 2);
        }
    }

    BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = -1;
        BlockPos posDown = pos.func_177977_b();
        IBlockState stateDown = world.func_180495_p(posDown);
        Block blockDown = stateDown.func_177230_c();
        boolean isSoilDown = blockDown.canSustainPlant(stateDown, (IBlockAccess)world, posDown, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldBerryBushBlackberry);
        if (!world.func_180495_p(pos).func_185914_p() && isSoilDown) {
            return pos;
        }
        int height = this.spawnHeight;
        do {
            BlockPos position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p());
            if (height < Config.seaLevel) break;
            IBlockState state = world.func_180495_p(position);
            Block block = state.func_177230_c();
            boolean isSoil = block.canSustainPlant(state, (IBlockAccess)world, position, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldBerryBushBlackberry);
            if (!isSoil) continue;
            if (world.func_180495_p(position.func_177984_a()).func_185914_p()) break;
            returnHeight = height + 1;
            break;
        } while (--height > 0);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    int randomFullAge(Random random) {
        int fruiting = random.nextInt(5) == 0 ? 1 : 0;
        return 2 + fruiting;
    }

    int randomAge(Random random) {
        return random.nextInt(3);
    }
}

