/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.crops.BlockNaturaBarley;
import com.progwml6.natura.overworld.block.crops.BlockNaturaCotton;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class CropGenerator
implements IWorldGenerator {
    public static final CropGenerator INSTANCE = new CropGenerator();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateOverworld(random, chunkX, chunkZ, world);
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateOverworld(random, chunkX, chunkZ, world);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    public void generateOverworld(Random random, int chunkX, int chunkZ, World world) {
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        BlockPos chunkPos = new BlockPos(xPos, 0, zPos);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if (this.shouldGenerateInDimension(world.field_73011_w.getDimension())) {
            int posY;
            int posZ;
            BlockPos newPos;
            int posX;
            if (Config.generateBarley && random.nextInt(5) == 0 && this.goodClimate(biome, 0.11f, 1.0f, 0.11f, 2.0f)) {
                posX = xPos + random.nextInt(16);
                int posY2 = random.nextInt(128) + Config.seaLevel;
                int posZ2 = zPos + random.nextInt(16);
                newPos = new BlockPos(posX, posY2, posZ2);
                this.generateBarley(world, random, newPos);
                this.generateBarley(world, random, newPos);
            }
            if (Config.generateCotton && random.nextInt(12) == 0 && this.goodClimate(biome, 0.11f, 1.0f, 0.11f, 2.0f)) {
                posX = xPos + random.nextInt(16);
                posZ = zPos + random.nextInt(16);
                posY = random.nextInt(128) + Config.seaLevel;
                newPos = new BlockPos(posX, posY, posZ);
                this.generateCotton(world, random, newPos);
                this.generateCotton(world, random, newPos);
            }
            if (Config.generateBluebells && random.nextInt(12) == 0) {
                posX = xPos + random.nextInt(16);
                posZ = zPos + random.nextInt(16);
                posY = random.nextInt(128) + Config.seaLevel;
                newPos = new BlockPos(posX, posY, posZ);
                this.generateBluebells(world, random, newPos);
            }
        }
    }

    public void generateBarley(World world, Random random, BlockPos position) {
        IBlockState state = NaturaOverworld.barleyCrop.func_176223_P().func_177226_a((IProperty)BlockNaturaBarley.AGE, (Comparable)Integer.valueOf(3));
        for (int tries = 0; tries < 64; ++tries) {
            BlockPos blockpos = position.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(blockpos) || !NaturaOverworld.barleyCrop.func_180671_f(world, blockpos, state)) continue;
            world.func_180501_a(blockpos, state, 2);
        }
    }

    public void generateCotton(World world, Random random, BlockPos position) {
        IBlockState state = NaturaOverworld.cottonCrop.func_176223_P().func_177226_a((IProperty)BlockNaturaCotton.AGE, (Comparable)Integer.valueOf(4));
        for (int tries = 0; tries < 64; ++tries) {
            BlockPos blockpos = position.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(4) - random.nextInt(4), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(blockpos) || !NaturaOverworld.cottonCrop.func_180671_f(world, blockpos, state)) continue;
            world.func_180501_a(blockpos, state, 2);
        }
    }

    public void generateBluebells(World world, Random random, BlockPos position) {
        IBlockState state = NaturaOverworld.bluebellsFlower.func_176223_P();
        for (int tries = 0; tries < 40; ++tries) {
            BlockPos blockpos = position.func_177982_a(random.nextInt(8) - random.nextInt(8), random.nextInt(8) - random.nextInt(8), random.nextInt(8) - random.nextInt(8));
            if (!world.func_175623_d(blockpos) || !NaturaOverworld.bluebellsFlower.func_180671_f(world, blockpos, state)) continue;
            world.func_180501_a(blockpos, state, 2);
        }
    }

    public boolean goodClimate(Biome biome, float minTemp, float maxTemp, float minRain, float maxRain) {
        float temp = biome.func_185353_n();
        float rain = biome.func_76727_i();
        return minTemp <= temp && temp <= maxTemp && minRain <= rain && rain <= maxRain;
    }

    public boolean shouldGenerateInDimension(int dimension) {
        for (int dimensionId : Config.overworldWorldGenWhitelist) {
            if (dimension != dimensionId) continue;
            return true;
        }
        return false;
    }
}

