/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.overworld.block.saplings;

import com.google.common.collect.Lists;
import com.progwml6.natura.Natura;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.leaves.BlockRedwoodLeaves;
import com.progwml6.natura.overworld.block.logs.BlockRedwoodLog;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.overworld.RedwoodTreeGenerator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import slimeknights.mantle.block.EnumBlock;

public class BlockRedwoodSapling
extends BlockSapling {
    public static final PropertyEnum<SaplingType> FOLIAGE = PropertyEnum.func_177709_a((String)"foliage", SaplingType.class);
    private final List<BlockPos> redwoodSaplingPositions = Lists.newArrayList();

    public BlockRedwoodSapling() {
        this.func_149647_a(Natura.TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
    }

    public boolean func_176200_f(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState iblockstate = world.func_180495_p(pos);
        int meta = iblockstate.func_177230_c().func_176201_c(iblockstate);
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    @Nonnull
    public EnumPlantType getPlantType(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public void func_176476_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BaseTreeGenerator gen = new BaseTreeGenerator();
        if (state.func_177229_b(FOLIAGE) == SaplingType.REDWOOD) {
            int numSaplings = this.checkRedwoodSaplings(worldIn, pos);
            IBlockState bark = NaturaOverworld.redwoodLog.func_176223_P().func_177226_a(BlockRedwoodLog.TYPE, (Comparable)((Object)BlockRedwoodLog.RedwoodType.BARK));
            IBlockState heart = NaturaOverworld.redwoodLog.func_176223_P().func_177226_a(BlockRedwoodLog.TYPE, (Comparable)((Object)BlockRedwoodLog.RedwoodType.HEART));
            IBlockState root = NaturaOverworld.redwoodLog.func_176223_P().func_177226_a(BlockRedwoodLog.TYPE, (Comparable)((Object)BlockRedwoodLog.RedwoodType.ROOT));
            IBlockState leaves = NaturaOverworld.redwoodLeaves.func_176223_P().func_177226_a(BlockRedwoodLeaves.TYPE, (Comparable)((Object)BlockRedwoodLeaves.RedwoodType.NORMAL));
            if (numSaplings >= 40) {
                gen = new RedwoodTreeGenerator(bark, heart, root, leaves);
            }
        } else {
            Natura.log.warn("BlockRedwoodSapling Warning: Invalid sapling meta/foliage, " + state.func_177229_b(FOLIAGE) + ". Please report!");
        }
        this.replaceBlocksWithAir(worldIn, pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            this.replaceAirWithBlocks(worldIn, state);
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (SaplingType type : SaplingType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= SaplingType.values().length) {
            meta = 0;
        }
        SaplingType sapling = SaplingType.values()[meta];
        return this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)sapling));
    }

    public int func_176201_c(IBlockState state) {
        return ((SaplingType)((Object)state.func_177229_b(FOLIAGE))).ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FOLIAGE, field_176479_b, field_176480_a});
    }

    public int checkRedwoodSaplings(World worldIn, BlockPos pos) {
        int numSaplings = 0;
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (!this.isRedwoodComplete(worldIn, pos.func_177982_a(x, 0, z), SaplingType.REDWOOD)) continue;
                ++numSaplings;
            }
        }
        return numSaplings;
    }

    public boolean isRedwoodComplete(World worldIn, BlockPos pos, SaplingType type) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        return iblockstate.func_177230_c() == this && iblockstate.func_177229_b(FOLIAGE) == type;
    }

    public void replaceBlocksWithAir(World worldIn, BlockPos pos) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (!this.isRedwoodComplete(worldIn, pos.func_177982_a(x, 0, z), SaplingType.REDWOOD)) continue;
                this.redwoodSaplingPositions.add(pos.func_177982_a(x, 0, z));
                worldIn.func_175698_g(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void replaceAirWithBlocks(World worldIn, IBlockState state) {
        for (BlockPos pos : this.redwoodSaplingPositions) {
            if (!worldIn.func_175623_d(pos)) continue;
            worldIn.func_180501_a(pos, state, 4);
        }
        this.redwoodSaplingPositions.clear();
    }

    public static enum SaplingType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        REDWOOD;

        public final int meta = this.ordinal();

        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

