/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.overworld.block.saplings;

import com.progwml6.natura.Natura;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.leaves.BlockAppleLeaves;
import com.progwml6.natura.overworld.block.logs.BlockAppleLog;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.overworld.AppleTreeGenerator;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.event.terraingen.TerrainGen;
import slimeknights.mantle.block.EnumBlock;

public class BlockAppleSapling
extends BlockSapling {
    public static final PropertyEnum<SaplingType> FOLIAGE = PropertyEnum.func_177709_a((String)"foliage", SaplingType.class);

    public BlockAppleSapling() {
        this.func_149647_a(Natura.TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
    }

    @Nonnull
    public EnumPlantType getPlantType(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public boolean func_176200_f(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState iblockstate = world.func_180495_p(pos);
        int meta = iblockstate.func_177230_c().func_176201_c(iblockstate);
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public void func_176476_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BaseTreeGenerator gen = new BaseTreeGenerator();
        if (state.func_177229_b(FOLIAGE) == SaplingType.APPLE) {
            IBlockState log = NaturaOverworld.appleLog.func_176223_P().func_177226_a(BlockAppleLog.TYPE, (Comparable)((Object)BlockAppleLog.LogType.APPLE));
            IBlockState leavesNormal = NaturaOverworld.appleLeaves.func_176223_P().func_177226_a(BlockAppleLeaves.TYPE, (Comparable)((Object)BlockAppleLeaves.LeavesType.NORMAL));
            IBlockState leavesFlowering = NaturaOverworld.appleLeaves.func_176223_P().func_177226_a(BlockAppleLeaves.TYPE, (Comparable)((Object)BlockAppleLeaves.LeavesType.FLOWERING));
            IBlockState leavesFruiting = NaturaOverworld.appleLeaves.func_176223_P().func_177226_a(BlockAppleLeaves.TYPE, (Comparable)((Object)BlockAppleLeaves.LeavesType.FRUIT));
            IBlockState leavesFruitingGolden = NaturaOverworld.appleLeaves.func_176223_P().func_177226_a(BlockAppleLeaves.TYPE, (Comparable)((Object)BlockAppleLeaves.LeavesType.GOLDEN_FRUIT));
            gen = new AppleTreeGenerator(6, 4, log, leavesNormal, leavesFlowering, leavesFruiting, leavesFruitingGolden);
        } else {
            Natura.log.warn("BlockAppleSapling Warning: Invalid sapling meta/foliage, " + state.func_177229_b(FOLIAGE) + ". Please report!");
        }
        worldIn.func_175698_g(pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (SaplingType type : SaplingType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= SaplingType.values().length) {
            meta = 0;
        }
        SaplingType sapling = SaplingType.values()[meta];
        return this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)sapling));
    }

    public int func_176201_c(IBlockState state) {
        return ((SaplingType)((Object)state.func_177229_b(FOLIAGE))).ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FOLIAGE, field_176479_b, field_176480_a});
    }

    public static enum SaplingType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        APPLE;

        public final int meta = this.ordinal();

        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

