/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.overworld;

import com.progwml6.natura.common.ClientProxy;
import com.progwml6.natura.common.ModelRegisterUtil;
import com.progwml6.natura.common.block.BlockEnumBerryBush;
import com.progwml6.natura.common.block.BlockEnumLog;
import com.progwml6.natura.common.block.BlockGrassStairs;
import com.progwml6.natura.common.client.GrassColorizer;
import com.progwml6.natura.common.client.LeavesColorizer;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.overworld.block.crops.BlockNaturaBarley;
import com.progwml6.natura.overworld.block.crops.BlockNaturaCotton;
import com.progwml6.natura.overworld.block.grass.BlockColoredGrass;
import com.progwml6.natura.overworld.block.leaves.BlockAppleLeaves;
import com.progwml6.natura.overworld.block.leaves.BlockRedwoodLeaves;
import com.progwml6.natura.overworld.block.logs.BlockAppleLog;
import com.progwml6.natura.overworld.block.logs.BlockOverworldLog;
import com.progwml6.natura.overworld.block.logs.BlockOverworldLog2;
import com.progwml6.natura.overworld.block.saguaro.BlockSaguaroBaby;
import com.progwml6.natura.overworld.block.saplings.BlockAppleSapling;
import com.progwml6.natura.overworld.block.saplings.BlockOverworldSapling;
import com.progwml6.natura.overworld.block.saplings.BlockOverworldSapling2;
import com.progwml6.natura.overworld.block.saplings.BlockRedwoodSapling;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ModelLoader;

public class OverworldClientProxy
extends ClientProxy {
    public static final GrassColorizer GRASS_COLORIZER = new GrassColorizer();
    public static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    @Override
    public void preInit() {
        ((IReloadableResourceManager)MINECRAFT.func_110442_L()).func_110542_a((IResourceManagerReloadListener)GRASS_COLORIZER);
        super.preInit();
    }

    @Override
    public void init() {
        BlockColors blockColors = MINECRAFT.func_184125_al();
        blockColors.func_186722_a((state, access, pos, tintIndex) -> {
            if (state.func_177230_c().getClass() == BlockGrassStairs.class) {
                BlockGrassStairs grassStairs = (BlockGrassStairs)state.func_177230_c();
                BlockColoredGrass.GrassType type = (BlockColoredGrass.GrassType)((Object)((Object)grassStairs.customModelState.func_177229_b(BlockColoredGrass.TYPE)));
                if (pos == null) {
                    return GrassColorizer.getGrassColorStatic(type);
                }
                return GrassColorizer.getGrassColorForPos(access, pos, type);
            }
            BlockColoredGrass.GrassType type = (BlockColoredGrass.GrassType)((Object)((Object)state.func_177229_b(BlockColoredGrass.TYPE)));
            if (pos == null) {
                return GrassColorizer.getGrassColorStatic(type);
            }
            return GrassColorizer.getGrassColorForPos(access, pos, type);
        }, new Block[]{NaturaOverworld.coloredGrass, NaturaOverworld.coloredGrassSlab, NaturaOverworld.coloredGrassStairsTopiary, NaturaOverworld.coloredGrassStairsBlueGrass, NaturaOverworld.coloredGrassStairsAutumnal});
        blockColors.func_186722_a((state, access, pos, tintIndex) -> {
            BlockOverworldLog.LogType type = (BlockOverworldLog.LogType)((Object)((Object)state.func_177229_b(BlockOverworldLog.TYPE)));
            if (pos == null) {
                return LeavesColorizer.getOverworldLeavesColorStatic(type);
            }
            return LeavesColorizer.getOverworldLeavesColorForPos(access, pos, type);
        }, new Block[]{NaturaOverworld.overworldLeaves});
        blockColors.func_186722_a((state, access, pos, tintIndex) -> {
            BlockOverworldLog2.LogType type = (BlockOverworldLog2.LogType)((Object)((Object)state.func_177229_b(BlockOverworldLog2.TYPE)));
            if (pos == null) {
                return LeavesColorizer.getSecondOverworldLeavesColorStatic(type);
            }
            return LeavesColorizer.getSecondOverworldLeavesColorForPos(access, pos, type);
        }, new Block[]{NaturaOverworld.overworldLeaves2});
        blockColors.func_186722_a((state, access, pos, tintIndex) -> {
            BlockRedwoodLeaves.RedwoodType type = (BlockRedwoodLeaves.RedwoodType)((Object)((Object)state.func_177229_b(BlockRedwoodLeaves.TYPE)));
            if (pos == null) {
                return LeavesColorizer.getRedwoodLeavesColorStatic(type);
            }
            return LeavesColorizer.getRedwoodLeavesColorForPos(access, pos, type);
        }, new Block[]{NaturaOverworld.redwoodLeaves});
        MINECRAFT.getItemColors().func_186731_a((stack, tintIndex) -> {
            IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(iblockstate, null, null, tintIndex);
        }, new Block[]{NaturaOverworld.overworldLeaves, NaturaOverworld.overworldLeaves2, NaturaOverworld.redwoodLeaves, NaturaOverworld.appleLeaves, NaturaOverworld.coloredGrass, NaturaOverworld.coloredGrassSlab, NaturaOverworld.coloredGrassStairsTopiary, NaturaOverworld.coloredGrassStairsBlueGrass, NaturaOverworld.coloredGrassStairsAutumnal});
        super.init();
    }

    @Override
    protected void registerModels() {
        String variant;
        String variant2;
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.overworldLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.overworldLeaves2, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.redwoodLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.appleLeaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.overworldSapling, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockOverworldSapling.field_176479_b, BlockSapling.field_176480_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.overworldSapling2, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockOverworldSapling2.field_176479_b, BlockSapling.field_176480_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.redwoodSapling, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRedwoodSapling.field_176479_b, BlockSapling.field_176480_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.appleSapling, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockAppleSapling.field_176479_b, BlockSapling.field_176480_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.eucalyptusDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.hopseedDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.sakuraDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.redwoodDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.redwoodBarkDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.tigerDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.mapleDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.silverbellDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.amaranthDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.willowDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)NaturaOverworld.appleDoor, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelRegisterUtil.registerItemBlockMeta((Block)NaturaOverworld.redwoodLog);
        ModelRegisterUtil.registerItemBlockMeta((Block)NaturaOverworld.overworldPlanks);
        ModelRegisterUtil.registerItemBlockMeta((Block)NaturaOverworld.coloredGrass);
        ModelRegisterUtil.registerItemBlockMeta((Block)NaturaOverworld.coloredGrassSlab);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.coloredGrassStairsTopiary);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.coloredGrassStairsBlueGrass);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.coloredGrassStairsAutumnal);
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.bluebellsFlower), 1, 0);
        this.registerItemModelNatura(stack, "bluebells_flower");
        ModelRegisterUtil.registerItemBlockMeta((Block)NaturaOverworld.overworldSlab);
        ModelRegisterUtil.registerItemBlockMeta((Block)NaturaOverworld.overworldSlab2);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsMaple);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsSilverbell);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsAmaranth);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsTiger);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsWillow);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsEucalyptus);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsHopseed);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsSakura);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsRedwood);
        ModelRegisterUtil.registerItemModel(NaturaOverworld.overworldStairsApple);
        Item overworldLog = Item.func_150898_a((Block)NaturaOverworld.overworldLog);
        for (BlockOverworldLog.LogType type : BlockOverworldLog.LogType.values()) {
            String variant3 = String.format("%s=%s,%s=%s", BlockOverworldLog.LOG_AXIS.func_177701_a(), BlockOverworldLog.LOG_AXIS.func_177702_a((Enum)BlockEnumLog.EnumAxis.Y), BlockOverworldLog.TYPE.func_177701_a(), BlockOverworldLog.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)overworldLog, (int)type.meta, (ModelResourceLocation)new ModelResourceLocation(overworldLog.getRegistryName(), variant3));
        }
        Item overworldLog2 = Item.func_150898_a((Block)NaturaOverworld.overworldLog2);
        for (BlockOverworldLog2.LogType type : BlockOverworldLog2.LogType.values()) {
            String variant4 = String.format("%s=%s,%s=%s", BlockOverworldLog2.LOG_AXIS.func_177701_a(), BlockOverworldLog2.LOG_AXIS.func_177702_a((Enum)BlockEnumLog.EnumAxis.Y), BlockOverworldLog2.TYPE.func_177701_a(), BlockOverworldLog2.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)overworldLog2, (int)type.meta, (ModelResourceLocation)new ModelResourceLocation(overworldLog2.getRegistryName(), variant4));
        }
        Item appleLog = Item.func_150898_a((Block)NaturaOverworld.appleLog);
        for (BlockAppleLog.LogType type : BlockAppleLog.LogType.values()) {
            String variant5 = String.format("%s=%s,%s=%s", BlockAppleLog.LOG_AXIS.func_177701_a(), BlockAppleLog.LOG_AXIS.func_177702_a((Enum)BlockEnumLog.EnumAxis.Y), BlockAppleLog.TYPE.func_177701_a(), BlockAppleLog.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)appleLog, (int)type.meta, (ModelResourceLocation)new ModelResourceLocation(appleLog.getRegistryName(), variant5));
        }
        Item overworldLeaves = Item.func_150898_a((Block)NaturaOverworld.overworldLeaves);
        for (BlockOverworldLog.LogType type : BlockOverworldLog.LogType.values()) {
            String variant6 = String.format("%s=%s", BlockOverworldLog.TYPE.func_177701_a(), BlockOverworldLog.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)overworldLeaves, (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(overworldLeaves.getRegistryName(), variant6));
        }
        Item overworldLeaves2 = Item.func_150898_a((Block)NaturaOverworld.overworldLeaves2);
        for (BlockOverworldLog2.LogType type : BlockOverworldLog2.LogType.values()) {
            String variant7 = String.format("%s=%s", BlockOverworldLog2.TYPE.func_177701_a(), BlockOverworldLog2.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)overworldLeaves2, (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(overworldLeaves2.getRegistryName(), variant7));
        }
        Item redwoodLeaves = Item.func_150898_a((Block)NaturaOverworld.redwoodLeaves);
        for (BlockRedwoodLeaves.RedwoodType type : BlockRedwoodLeaves.RedwoodType.values()) {
            variant2 = String.format("%s=%s", BlockRedwoodLeaves.TYPE.func_177701_a(), BlockRedwoodLeaves.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)redwoodLeaves, (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(redwoodLeaves.getRegistryName(), variant2));
        }
        Item appleLeaves = Item.func_150898_a((Block)NaturaOverworld.appleLeaves);
        for (BlockAppleLeaves.LeavesType type : BlockAppleLeaves.LeavesType.values()) {
            variant = String.format("%s=%s", BlockAppleLeaves.TYPE.func_177701_a(), BlockAppleLeaves.TYPE.func_177702_a((Enum)type));
            ModelLoader.setCustomModelResourceLocation((Item)appleLeaves, (int)type.getMeta(), (ModelResourceLocation)new ModelResourceLocation(appleLeaves.getRegistryName(), variant));
        }
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling), 1, NaturaOverworld.overworldSapling.func_176201_c(NaturaOverworld.overworldSapling.func_176223_P().func_177226_a(BlockOverworldSapling.FOLIAGE, (Comparable)((Object)BlockOverworldSapling.SaplingType.MAPLE))));
        this.registerItemModelNatura(stack, "overworld_sapling_maple");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling), 1, NaturaOverworld.overworldSapling.func_176201_c(NaturaOverworld.overworldSapling.func_176223_P().func_177226_a(BlockOverworldSapling.FOLIAGE, (Comparable)((Object)BlockOverworldSapling.SaplingType.SILVERBELL))));
        this.registerItemModelNatura(stack, "overworld_sapling_silverbell");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling), 1, NaturaOverworld.overworldSapling.func_176201_c(NaturaOverworld.overworldSapling.func_176223_P().func_177226_a(BlockOverworldSapling.FOLIAGE, (Comparable)((Object)BlockOverworldSapling.SaplingType.AMARANTH))));
        this.registerItemModelNatura(stack, "overworld_sapling_amaranth");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling), 1, NaturaOverworld.overworldSapling.func_176201_c(NaturaOverworld.overworldSapling.func_176223_P().func_177226_a(BlockOverworldSapling.FOLIAGE, (Comparable)((Object)BlockOverworldSapling.SaplingType.TIGER))));
        this.registerItemModelNatura(stack, "overworld_sapling_tiger");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling2), 1, NaturaOverworld.overworldSapling2.func_176201_c(NaturaOverworld.overworldSapling2.func_176223_P().func_177226_a(BlockOverworldSapling2.FOLIAGE, (Comparable)((Object)BlockOverworldSapling2.SaplingType.WILLOW))));
        this.registerItemModelNatura(stack, "overworld_sapling_willow");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling2), 1, NaturaOverworld.overworldSapling2.func_176201_c(NaturaOverworld.overworldSapling2.func_176223_P().func_177226_a(BlockOverworldSapling2.FOLIAGE, (Comparable)((Object)BlockOverworldSapling2.SaplingType.EUCALYPTUS))));
        this.registerItemModelNatura(stack, "overworld_sapling_eucalyptus");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling2), 1, NaturaOverworld.overworldSapling2.func_176201_c(NaturaOverworld.overworldSapling2.func_176223_P().func_177226_a(BlockOverworldSapling2.FOLIAGE, (Comparable)((Object)BlockOverworldSapling2.SaplingType.HOPSEED))));
        this.registerItemModelNatura(stack, "overworld_sapling_hopseed");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.overworldSapling2), 1, NaturaOverworld.overworldSapling2.func_176201_c(NaturaOverworld.overworldSapling2.func_176223_P().func_177226_a(BlockOverworldSapling2.FOLIAGE, (Comparable)((Object)BlockOverworldSapling2.SaplingType.SAKURA))));
        this.registerItemModelNatura(stack, "overworld_sapling_sakura");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.redwoodSapling), 1, NaturaOverworld.redwoodSapling.func_176201_c(NaturaOverworld.redwoodSapling.func_176223_P().func_177226_a(BlockRedwoodSapling.FOLIAGE, (Comparable)((Object)BlockRedwoodSapling.SaplingType.REDWOOD))));
        this.registerItemModelNatura(stack, "overworld_sapling_redwood");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.appleSapling), 1, NaturaOverworld.appleSapling.func_176201_c(NaturaOverworld.appleSapling.func_176223_P().func_177226_a(BlockAppleSapling.FOLIAGE, (Comparable)((Object)BlockAppleSapling.SaplingType.APPLE))));
        this.registerItemModelNatura(stack, "overworld_sapling_apple");
        Item raspberryBerrybush = Item.func_150898_a((Block)NaturaOverworld.overworldBerryBushRaspberry);
        for (int meta = 0; meta <= 3; ++meta) {
            String variant8 = String.format("%s=%s", BlockEnumBerryBush.AGE.func_177701_a(), meta);
            ModelLoader.setCustomModelResourceLocation((Item)raspberryBerrybush, (int)meta, (ModelResourceLocation)new ModelResourceLocation(raspberryBerrybush.getRegistryName(), variant8));
        }
        Item blueberryBerrybush = Item.func_150898_a((Block)NaturaOverworld.overworldBerryBushBlueberry);
        for (int meta = 0; meta <= 3; ++meta) {
            variant2 = String.format("%s=%s", BlockEnumBerryBush.AGE.func_177701_a(), meta);
            ModelLoader.setCustomModelResourceLocation((Item)blueberryBerrybush, (int)meta, (ModelResourceLocation)new ModelResourceLocation(blueberryBerrybush.getRegistryName(), variant2));
        }
        Item blackberryBerrybush = Item.func_150898_a((Block)NaturaOverworld.overworldBerryBushBlackberry);
        for (int meta = 0; meta <= 3; ++meta) {
            variant = String.format("%s=%s", BlockEnumBerryBush.AGE.func_177701_a(), meta);
            ModelLoader.setCustomModelResourceLocation((Item)blackberryBerrybush, (int)meta, (ModelResourceLocation)new ModelResourceLocation(blackberryBerrybush.getRegistryName(), variant));
        }
        Item maloberryBerrybush = Item.func_150898_a((Block)NaturaOverworld.overworldBerryBushMaloberry);
        for (int meta = 0; meta <= 3; ++meta) {
            String variant9 = String.format("%s=%s", BlockEnumBerryBush.AGE.func_177701_a(), meta);
            ModelLoader.setCustomModelResourceLocation((Item)maloberryBerrybush, (int)meta, (ModelResourceLocation)new ModelResourceLocation(maloberryBerrybush.getRegistryName(), variant9));
        }
        Item barleyCrop = Item.func_150898_a((Block)NaturaOverworld.barleyCrop);
        for (int meta = 0; meta <= 3; ++meta) {
            String variant10 = String.format("%s=%s", BlockNaturaBarley.AGE.func_177701_a(), meta);
            ModelLoader.setCustomModelResourceLocation((Item)barleyCrop, (int)meta, (ModelResourceLocation)new ModelResourceLocation(barleyCrop.getRegistryName(), variant10));
        }
        Item cottonCrop = Item.func_150898_a((Block)NaturaOverworld.cottonCrop);
        for (int meta = 0; meta <= 4; ++meta) {
            String variant11 = String.format("%s=%s", BlockNaturaCotton.AGE.func_177701_a(), meta);
            ModelLoader.setCustomModelResourceLocation((Item)cottonCrop, (int)meta, (ModelResourceLocation)new ModelResourceLocation(cottonCrop.getRegistryName(), variant11));
        }
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.eucalyptusDoor), 1, NaturaOverworld.eucalyptusDoor.func_176201_c(NaturaOverworld.eucalyptusDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_eucalyptus");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.hopseedDoor), 1, NaturaOverworld.hopseedDoor.func_176201_c(NaturaOverworld.hopseedDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_hopseed");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.sakuraDoor), 1, NaturaOverworld.sakuraDoor.func_176201_c(NaturaOverworld.sakuraDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_sakura");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.redwoodDoor), 1, NaturaOverworld.redwoodDoor.func_176201_c(NaturaOverworld.redwoodDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_redwood");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.redwoodBarkDoor), 1, NaturaOverworld.redwoodBarkDoor.func_176201_c(NaturaOverworld.redwoodBarkDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_redwood_bark");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.tigerDoor), 1, NaturaOverworld.tigerDoor.func_176201_c(NaturaOverworld.tigerDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_tiger");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.mapleDoor), 1, NaturaOverworld.mapleDoor.func_176201_c(NaturaOverworld.mapleDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_maple");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.silverbellDoor), 1, NaturaOverworld.silverbellDoor.func_176201_c(NaturaOverworld.silverbellDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_silverbell");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.amaranthDoor), 1, NaturaOverworld.amaranthDoor.func_176201_c(NaturaOverworld.amaranthDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_amaranth");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.willowDoor), 1, NaturaOverworld.willowDoor.func_176201_c(NaturaOverworld.willowDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_willow");
        stack = new ItemStack(Item.func_150898_a((Block)NaturaOverworld.appleDoor), 1, NaturaOverworld.appleDoor.func_176201_c(NaturaOverworld.appleDoor.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176519_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER)));
        this.registerItemModelNatura(stack, "overworld_door_apple");
        ModelRegisterUtil.registerItemModel(NaturaOverworld.saguaro);
        Item saguaroBaby = Item.func_150898_a((Block)NaturaOverworld.saguaroBaby);
        for (int meta = 0; meta <= 1; ++meta) {
            String variant12 = String.format("%s=%s", BlockSaguaroBaby.AGE.func_177701_a(), meta);
            ModelLoader.setCustomModelResourceLocation((Item)saguaroBaby, (int)meta, (ModelResourceLocation)new ModelResourceLocation(saguaroBaby.getRegistryName(), variant12));
        }
        ModelRegisterUtil.registerItemModel(NaturaOverworld.saguaroFruit);
        ModelRegisterUtil.registerItemModel((Item)NaturaOverworld.saguaroFruitItem);
        NaturaOverworld.overworldSeeds.registerItemModels();
        NaturaOverworld.overworldSeedBags.registerItemModels();
        NaturaOverworld.overworldDoors.registerItemModels();
    }
}

