/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.oredict;

import com.progwml6.natura.common.NaturaPulse;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.decorative.NaturaDecorative;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.glass.BlockNetherGlass;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.shared.NaturaCommons;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="NaturaOredict", description="Everything that has to do with the ore dictionary", forced=true)
public class NaturaOredict
extends NaturaPulse {
    public static final String PulseId = "NaturaOredict";
    static final Logger log = Util.getLogger("NaturaOredict");

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        NaturaOredict.ensureOredict();
        NaturaOredict.registerCommons();
        NaturaOredict.registerOverworld();
        NaturaOredict.registerNether();
        NaturaOredict.registerDecorative();
    }

    private static void ensureOredict() {
        NaturaOredict.oredict((Block)Blocks.field_150486_ae, "chestWood");
        NaturaOredict.oredict(Blocks.field_150447_bR, "chestWood");
    }

    private static void registerCommons() {
        NaturaOredict.oredict(NaturaCommons.barley, "cropBarley");
        NaturaOredict.oredict(NaturaCommons.cotton, "cropCotton");
        NaturaOredict.oredict(NaturaCommons.barleyFlour, "foodFlour");
        NaturaOredict.oredict(NaturaCommons.wheatFlour, "foodFlour");
        NaturaOredict.oredict(NaturaCommons.barley, "listAllgrain");
        NaturaOredict.oredict(NaturaCommons.wheatFlour, "foodEqualswheat");
        NaturaOredict.oredict(NaturaCommons.blueDye, "dyeBlue");
        NaturaOredict.oredict(NaturaCommons.sulfurPowder, "dustSulphur");
        NaturaOredict.oredict(NaturaCommons.sulfurPowder, "dustSulfur");
        NaturaOredict.oredict((Item)NaturaCommons.sticks, "stickWood");
    }

    private static void registerOverworld() {
        if (NaturaOredict.isOverworldLoaded()) {
            if (Config.dropBarley) {
                MinecraftForge.addGrassSeed((ItemStack)NaturaOverworld.barley_seeds, (int)3);
            }
            if (Config.dropCotton) {
                MinecraftForge.addGrassSeed((ItemStack)NaturaOverworld.cotton_seeds, (int)3);
            }
            NaturaOredict.oredict(NaturaCommons.raspberry, "cropRaspberry");
            NaturaOredict.oredict(NaturaCommons.raspberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.raspberry, "listAllfruit");
            NaturaOredict.oredict(NaturaCommons.blueberry, "cropBlueberry");
            NaturaOredict.oredict(NaturaCommons.raspberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.blueberry, "listAllfruit");
            NaturaOredict.oredict(NaturaCommons.blackberry, "cropBlackberry");
            NaturaOredict.oredict(NaturaCommons.raspberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.blackberry, "listAllfruit");
            NaturaOredict.oredict(NaturaCommons.maloberry, "cropMaloberry");
            NaturaOredict.oredict(NaturaCommons.raspberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.maloberry, "listAllfruit");
            NaturaOredict.oredict((Item)NaturaOverworld.saguaroFruitItem, "cropCactusfruit");
            NaturaOredict.oredict((Item)NaturaOverworld.overworldDoors, "doorWood");
            NaturaOredict.oredict((Block)NaturaOverworld.appleDoor, "doorWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldPlanks, "plankWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLog, "logWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLog2, "logWood");
            NaturaOredict.oredict((Block)NaturaOverworld.redwoodLog, "logWood");
            NaturaOredict.oredict((Block)NaturaOverworld.appleLog, "logWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldSlab, "slabWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldSlab2, "slabWood");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldSapling, "treeSapling");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldSapling2, "treeSapling");
            NaturaOredict.oredict((Block)NaturaOverworld.redwoodSapling, "treeSapling");
            NaturaOredict.oredict((Block)NaturaOverworld.appleSapling, "treeSapling");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLeaves, "treeLeaves");
            NaturaOredict.oredict((Block)NaturaOverworld.overworldLeaves2, "treeLeaves");
            NaturaOredict.oredict((Block)NaturaOverworld.redwoodLeaves, "treeLeaves");
            NaturaOredict.oredict((Block)NaturaOverworld.appleLeaves, "treeLeaves");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsAmaranth, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsEucalyptus, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsHopseed, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsMaple, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsRedwood, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsSakura, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsSilverbell, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsTiger, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsWillow, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.overworldStairsApple, "stairWood");
            NaturaOredict.oredict(NaturaOverworld.barley_seeds, "seedBarley");
            NaturaOredict.oredict(NaturaOverworld.cotton_seeds, "seedCotton");
            NaturaOredict.oredict(NaturaOverworld.barley_seeds, "listAllseed");
            NaturaOredict.oredict(NaturaOverworld.cotton_seeds, "listAllseed");
            NaturaOredict.oredict((Block)NaturaDecorative.overworldBookshelves, "bookshelf");
        }
    }

    private static void registerNether() {
        if (NaturaOredict.isNetherLoaded()) {
            NaturaOredict.oredict(NaturaCommons.blightberry, "cropBlightberry");
            NaturaOredict.oredict(NaturaCommons.blightberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.blightberry, "listAllfruit");
            NaturaOredict.oredict(NaturaCommons.duskberry, "cropDuskberry");
            NaturaOredict.oredict(NaturaCommons.blightberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.duskberry, "listAllfruit");
            NaturaOredict.oredict(NaturaCommons.skyberry, "cropSkyberry");
            NaturaOredict.oredict(NaturaCommons.blightberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.skyberry, "listAllfruit");
            NaturaOredict.oredict(NaturaCommons.stingberry, "cropStingberry");
            NaturaOredict.oredict(NaturaCommons.blightberry, "listAllberry");
            NaturaOredict.oredict(NaturaCommons.stingberry, "listAllfruit");
            NaturaOredict.oredict((Block)NaturaNether.netherHeatSand, "sand");
            NaturaOredict.oredict((Block)NaturaNether.netherTaintedSoil, "dirt");
            NaturaOredict.oredict((Block)NaturaNether.netherTaintedSoil, "taintedSoil");
            NaturaOredict.oredict((Item)NaturaNether.netherDoors, "doorWood");
            NaturaOredict.oredict((Block)NaturaNether.netherPlanks, "plankWood");
            NaturaOredict.oredict((Block)NaturaNether.netherLog, "logWood");
            NaturaOredict.oredict((Block)NaturaNether.netherLog2, "logWood");
            NaturaOredict.oredict((Block)NaturaNether.netherSlab, "slabWood");
            NaturaOredict.oredict((Block)NaturaNether.netherSapling, "treeSapling");
            NaturaOredict.oredict((Block)NaturaNether.netherLeaves, "treeLeaves");
            NaturaOredict.oredict((Block)NaturaNether.netherLeaves2, "treeLeaves");
            NaturaOredict.oredict(NaturaNether.netherStairsBloodwood, "stairWood");
            NaturaOredict.oredict(NaturaNether.netherStairsDarkwood, "stairWood");
            NaturaOredict.oredict(NaturaNether.netherStairsGhostwood, "stairWood");
            NaturaOredict.oredict(NaturaNether.netherStairsFusewood, "stairWood");
            NaturaOredict.oredict((Block)NaturaNether.netherGlass, BlockNetherGlass.GlassType.SOUL.getMeta(), "glassSoul");
            NaturaOredict.oredict((Block)NaturaNether.netherGlass, BlockNetherGlass.GlassType.SOUL.getMeta(), "glass");
            NaturaOredict.oredict((Block)NaturaNether.netherGlass, "glass");
            OreDictionary.registerOre((String)"cropVine", (ItemStack)new ItemStack((Block)NaturaNether.netherThornVines));
            NaturaOredict.oredict((Block)NaturaDecorative.netherBookshelves, "bookshelf");
        }
    }

    private static void registerDecorative() {
        if (NaturaOredict.isDecorativeLoaded()) {
            if (NaturaOredict.isOverworldLoaded()) {
                NaturaOredict.oredict((Block)NaturaDecorative.overworldWorkbenches, "crafterWood");
                NaturaOredict.oredict((Block)NaturaDecorative.overworldWorkbenches, "craftingTableWood");
            }
            if (NaturaOredict.isNetherLoaded()) {
                NaturaOredict.oredict((Block)NaturaDecorative.netherWorkbenches, "crafterWood");
                NaturaOredict.oredict((Block)NaturaDecorative.netherWorkbenches, "craftingTableWood");
            }
            for (Block button : NaturaDecorative.buttons) {
                NaturaOredict.oredict(button, "buttonWood");
            }
            for (Block pressurePlate : NaturaDecorative.pressurePlates) {
                NaturaOredict.oredict(pressurePlate, "pressurePlateWood");
            }
            for (Block trapDoor : NaturaDecorative.trapDoors) {
                NaturaOredict.oredict(trapDoor, "trapDoorWood");
            }
            for (Block fence : NaturaDecorative.fences) {
                NaturaOredict.oredict(fence, "fenceWood");
            }
            for (Block fenceGate : NaturaDecorative.fenceGates) {
                NaturaOredict.oredict(fenceGate, "fenceGateWood");
            }
        }
    }

    public static void oredict(Item item, String ... name) {
        NaturaOredict.oredict(item, Short.MAX_VALUE, name);
    }

    public static void oredict(Block block, String ... name) {
        NaturaOredict.oredict(block, Short.MAX_VALUE, name);
    }

    public static void oredict(Item item, int meta, String ... name) {
        NaturaOredict.oredict(new ItemStack(item, 1, meta), name);
    }

    public static void oredict(Block block, int meta, String ... name) {
        NaturaOredict.oredict(new ItemStack(block, 1, meta), name);
    }

    public static void oredict(ItemStack stack, String ... names) {
        if (!stack.func_190926_b() && stack.func_77973_b() != Items.field_190931_a) {
            for (String name : names) {
                OreDictionary.registerOre((String)name, (ItemStack)stack);
            }
        }
    }
}

