/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.nether.block.soil;

import com.google.common.base.Predicate;
import com.progwml6.natura.Natura;
import java.util.Locale;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import slimeknights.mantle.block.EnumBlock;

public class BlockTaintedSoil
extends EnumBlock<SoilType> {
    public static PropertyEnum<SoilType> TYPE = PropertyEnum.func_177709_a((String)"type", SoilType.class);

    public BlockTaintedSoil() {
        super(Material.field_151578_c, TYPE, SoilType.class);
        this.func_149647_a(Natura.TAB);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 0);
    }

    public boolean isFertile(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(TYPE) == SoilType.TAINTED_FARMLAND_HEATED;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        if (plantType == EnumPlantType.Nether) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return target.apply((Object)Blocks.field_150424_aL.func_176223_P());
    }

    public static enum SoilType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        TAINTED_SOIL,
        TAINTED_FARMLAND_DRY,
        TAINTED_FARMLAND_HEATED;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

