/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.nether.block.saplings;

import com.progwml6.natura.Natura;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves;
import com.progwml6.natura.nether.block.leaves.BlockNetherLeaves2;
import com.progwml6.natura.nether.block.logs.BlockNetherLog;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.nether.DarkwoodTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.nether.FusewoodTreeGenerator;
import com.progwml6.natura.world.worldgen.trees.nether.GhostwoodTreeGenerator;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;
import slimeknights.mantle.block.EnumBlock;

public class BlockNetherSapling
extends BlockSapling {
    public static final PropertyEnum<SaplingType> FOLIAGE = PropertyEnum.func_177709_a((String)"foliage", SaplingType.class);

    public BlockNetherSapling() {
        this.func_149647_a(Natura.TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if (block.func_176200_f((IBlockAccess)worldIn, pos)) {
            IBlockState soilBlockState = worldIn.func_180495_p(pos.func_177977_b());
            Block netherSoil = soilBlockState.func_177230_c();
            return this.canGrowOnBlock(netherSoil) || netherSoil.canSustainPlant(soilBlockState, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public boolean func_180671_f(@Nonnull World worldIn, @Nonnull BlockPos pos, IBlockState state) {
        switch ((SaplingType)((Object)state.func_177229_b(FOLIAGE))) {
            case DARKWOOD: 
            case FUSEWOOD: 
            case GHOSTWOOD: {
                IBlockState soilBlockState = worldIn.func_180495_p(pos.func_177977_b());
                Block netherSoil = soilBlockState.func_177230_c();
                return this.canGrowOnBlock(netherSoil) || netherSoil.canSustainPlant(soilBlockState, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
            }
        }
        return true;
    }

    @Nonnull
    public EnumPlantType getPlantType(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return EnumPlantType.Nether;
    }

    public boolean canGrowOnBlock(Block block) {
        return block == Blocks.field_150425_aM || block == Blocks.field_150424_aL || block == NaturaNether.netherTaintedSoil;
    }

    public boolean func_176200_f(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        IBlockState iblockstate = world.func_180495_p(pos);
        int meta = iblockstate.func_177230_c().func_176201_c(iblockstate);
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public void func_176476_e(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        BaseTreeGenerator gen = new BaseTreeGenerator();
        switch ((SaplingType)((Object)state.func_177229_b(FOLIAGE))) {
            case DARKWOOD: {
                IBlockState log = NaturaNether.netherLog.func_176223_P().func_177226_a(BlockNetherLog.TYPE, (Comparable)((Object)BlockNetherLog.LogType.DARKWOOD));
                IBlockState flowering = NaturaNether.netherLeaves2.func_176223_P().func_177226_a(BlockNetherLeaves2.TYPE, (Comparable)((Object)BlockNetherLeaves2.LeavesType.DARKWOOD_FLOWERING));
                IBlockState fruiting = NaturaNether.netherLeaves2.func_176223_P().func_177226_a(BlockNetherLeaves2.TYPE, (Comparable)((Object)BlockNetherLeaves2.LeavesType.DARKWOOD_FRUIT));
                IBlockState leaves = NaturaNether.netherLeaves2.func_176223_P().func_177226_a(BlockNetherLeaves2.TYPE, (Comparable)((Object)BlockNetherLeaves2.LeavesType.DARKWOOD));
                gen = new DarkwoodTreeGenerator(3, log, leaves, flowering, fruiting);
                break;
            }
            case FUSEWOOD: {
                IBlockState log = NaturaNether.netherLog.func_176223_P().func_177226_a(BlockNetherLog.TYPE, (Comparable)((Object)BlockNetherLog.LogType.FUSEWOOD));
                IBlockState leaves = NaturaNether.netherLeaves.func_176223_P().func_177226_a(BlockNetherLeaves.TYPE, (Comparable)((Object)BlockNetherLeaves.LeavesType.FUSEWOOD));
                gen = new FusewoodTreeGenerator(3, log, leaves, false);
                break;
            }
            case GHOSTWOOD: {
                IBlockState log = NaturaNether.netherLog.func_176223_P().func_177226_a(BlockNetherLog.TYPE, (Comparable)((Object)BlockNetherLog.LogType.GHOSTWOOD));
                IBlockState leaves = NaturaNether.netherLeaves.func_176223_P().func_177226_a(BlockNetherLeaves.TYPE, (Comparable)((Object)BlockNetherLeaves.LeavesType.GHOSTWOOD));
                gen = new GhostwoodTreeGenerator(log, leaves, false);
                break;
            }
            default: {
                Natura.log.warn("BlockNetherSapling Warning: Invalid sapling meta/foliage, " + state.func_177229_b(FOLIAGE) + ". Please report!");
            }
        }
        worldIn.func_175698_g(pos);
        gen.generateTree(rand, worldIn, pos);
        if (worldIn.func_175623_d(pos)) {
            worldIn.func_180501_a(pos, state, 4);
        }
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (SaplingType type : SaplingType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)type)))));
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= SaplingType.values().length) {
            meta = 0;
        }
        SaplingType sapling = SaplingType.values()[meta];
        return this.func_176223_P().func_177226_a(FOLIAGE, (Comparable)((Object)sapling));
    }

    public int func_176201_c(IBlockState state) {
        return ((SaplingType)((Object)state.func_177229_b(FOLIAGE))).ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FOLIAGE, field_176479_b, field_176480_a});
    }

    public static enum SaplingType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        GHOSTWOOD,
        FUSEWOOD,
        DARKWOOD;

        public final int meta = this.ordinal();

        @Nonnull
        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

