/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.nether.block.obelisk;

import com.progwml6.natura.Natura;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;

public class BlockRespawnObelisk
extends EnumBlock<ObeliskType> {
    public static PropertyEnum<ObeliskType> TYPE = PropertyEnum.func_177709_a((String)"type", ObeliskType.class);

    public BlockRespawnObelisk() {
        super(Material.field_151575_d, TYPE, ObeliskType.class);
        this.func_149647_a(Natura.TAB);
        this.func_149711_c(2.0f);
        this.func_149752_b(10000.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (ObeliskType type : ObeliskType.values()) {
            if (type == ObeliskType.ACTIVE) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return pos.func_177984_a();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(TYPE) == ObeliskType.INACTIVE && !playerIn.func_70093_af()) {
            Random rand = new Random();
            rand.setSeed(3244L);
            if (playerIn.func_70093_af()) {
                return false;
            }
            playerIn.setSpawnChunk(pos, false, worldIn.field_73011_w.getDimension());
            playerIn.setSpawnDimension(Integer.valueOf(worldIn.field_73011_w.getDimension()));
            if (!worldIn.field_72995_K) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("msg.natura.respawn_obelisk.activate", new Object[0]), true);
            }
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ObeliskType.ACTIVE)), 3);
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_193781_bp, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f, false);
            return true;
        }
        if (state.func_177229_b(TYPE) == ObeliskType.ACTIVE && !playerIn.func_70093_af()) {
            playerIn.setSpawnDimension(null);
            if (!worldIn.field_72995_K) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("msg.natura.respawn_obelisk.deactivate", new Object[0]), true);
            }
            worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)ObeliskType.INACTIVE)), 3);
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_193777_bb, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f, false);
            return true;
        }
        return false;
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        return state.func_177229_b(TYPE) == ObeliskType.ACTIVE;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(TYPE) == ObeliskType.ACTIVE) {
            return 7;
        }
        return super.getLightValue(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (stateIn.func_177229_b(TYPE) == ObeliskType.ACTIVE) {
            for (int i = 0; i < 2; ++i) {
                double x = (float)pos.func_177958_n() + rand.nextFloat() * 3.0f - 1.0f;
                double y = (float)pos.func_177956_o() + rand.nextFloat() * 2.0f;
                double z = (float)pos.func_177952_p() + rand.nextFloat() * 3.0f - 1.0f;
                worldIn.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.SPELL_WITCH, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        player.setSpawnDimension(null);
    }

    public static enum ObeliskType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        INACTIVE,
        ACTIVE;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

