/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.library.datafixes;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemIDFixer
implements IFixableData {
    private static final Map<ResourceLocation, ResourceLocation> ITEM_NAME_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>();

    public ItemIDFixer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_188216_a() {
        return 1;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        if (compound.func_74764_b("id")) {
            String oldItemId = compound.func_74779_i("id");
            ResourceLocation oldItemLocation = new ResourceLocation(oldItemId);
            if (oldItemLocation.equals((Object)new ResourceLocation("natura", "soups"))) {
                Item newSoupItem;
                short damage = compound.func_74765_d("Damage");
                ResourceLocation newSoupLocation = null;
                if (damage >= 0 && damage <= 3) {
                    newSoupLocation = new ResourceLocation("minecraft", "mushroom_stew");
                } else if (damage >= 4 && damage <= 8) {
                    newSoupLocation = new ResourceLocation("natura", "glowshroom_stew");
                } else if (damage == 9) {
                    newSoupLocation = new ResourceLocation("natura", "berry_medley");
                }
                if (newSoupLocation != null && (newSoupItem = (Item)ForgeRegistries.ITEMS.getValue(newSoupLocation)) != null) {
                    compound.func_74778_a("id", newSoupLocation.toString());
                    compound.func_82580_o("Damage");
                    return compound;
                }
            } else {
                Item newItem;
                ResourceLocation newItemLocation = ITEM_NAME_MAPPINGS.get(oldItemLocation);
                if (newItemLocation != null && (newItem = (Item)ForgeRegistries.ITEMS.getValue(newItemLocation)) != null) {
                    compound.func_74778_a("id", newItemLocation.toString());
                    compound.func_82580_o("Damage");
                    return compound;
                }
            }
        }
        return compound;
    }

    @SubscribeEvent
    public void missingItemMapping(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            Optional.ofNullable(ITEM_NAME_MAPPINGS.get(entry.key)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).ifPresent(item -> entry.ignore());
        }
    }

    static {
        ITEM_NAME_MAPPINGS.put(new ResourceLocation("natura", "empty_bowls"), new ResourceLocation("minecraft", "bowl"));
        ITEM_NAME_MAPPINGS.put(new ResourceLocation("natura", "soups"), new ResourceLocation("minecraft", "mushroom_stew"));
    }
}

