/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.entities;

import com.google.common.eventbus.Subscribe;
import com.progwml6.natura.Natura;
import com.progwml6.natura.common.CommonProxy;
import com.progwml6.natura.common.NaturaPulse;
import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.entities.entity.monster.EntityBabyHeatscarSpider;
import com.progwml6.natura.entities.entity.monster.EntityHeatscarSpider;
import com.progwml6.natura.entities.entity.monster.EntityNitroCreeper;
import com.progwml6.natura.entities.entity.passive.EntityImp;
import com.progwml6.natura.library.Util;
import com.progwml6.natura.shared.NaturaCommons;
import java.util.Set;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="NaturaEntities", description="The entities added by Natura")
public class NaturaEntities
extends NaturaPulse {
    public static final String PulseId = "NaturaEntities";
    static final Logger log = Util.getLogger("NaturaEntities");
    @SidedProxy(clientSide="com.progwml6.natura.entities.EntitiesClientProxy", serverSide="com.progwml6.natura.common.CommonProxy")
    public static CommonProxy proxy;
    public static final ResourceLocation BABY_HEATSCAR_SPIDER;
    public static final ResourceLocation HEATSCAR_SPIDER;
    public static final ResourceLocation IMP;
    public static final ResourceLocation NITRO_CREEPER;

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int id = 0;
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("babyheatscarspider"), EntityBabyHeatscarSpider.class, (String)"babyheatscarspider", (int)id++, (Object)Natura.instance, (int)64, (int)1, (boolean)true, (int)15093008, (int)5747133);
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("heatscarspider"), EntityHeatscarSpider.class, (String)"heatscarspider", (int)id++, (Object)Natura.instance, (int)64, (int)1, (boolean)true, (int)15093008, (int)5747133);
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("imp"), EntityImp.class, (String)"imp", (int)id++, (Object)Natura.instance, (int)64, (int)1, (boolean)true, (int)15898421, (int)3022608);
        EntityRegistry.registerModEntity((ResourceLocation)Util.getResource("nitrocreeper"), EntityNitroCreeper.class, (String)"nitrocreeper", (int)id++, (Object)Natura.instance, (int)64, (int)1, (boolean)true, (int)16203372, (int)10178564);
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        this.registerSmelting();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        Set biomeList = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
        Biome[] biomes = biomeList.toArray(new Biome[biomeList.size()]);
        EntityRegistry.addSpawn(EntityImp.class, (int)Config.impWeight, (int)Config.impSpawnMinimum, (int)Config.impSpawnMaximum, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])biomes);
        EntitySpawnPlacementRegistry.setPlacementType(EntityImp.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
        EntityRegistry.addSpawn(EntityHeatscarSpider.class, (int)Config.heatscarSpiderWeight, (int)Config.heatscarSpiderSpawnMinimum, (int)Config.heatscarSpiderSpawnMaximum, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        EntityRegistry.addSpawn(EntityBabyHeatscarSpider.class, (int)Config.babyHeatscarSpiderWeight, (int)Config.babyHeatscarSpiderSpawnMinimum, (int)Config.babyHeatscarSpiderSpawnMaximum, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        EntityRegistry.addSpawn(EntityNitroCreeper.class, (int)Config.nitroCreeperWeight, (int)Config.nitroCreeperSpawnMinimum, (int)Config.nitroCreeperSpawnMaximum, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomes);
        proxy.postInit();
    }

    private void registerSmelting() {
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        if (NaturaEntities.isEntitiesLoaded()) {
            furnaceRecipes.func_151394_a(NaturaCommons.impmeatRaw.func_77946_l(), NaturaCommons.impmeatCooked.func_77946_l(), 0.2f);
        }
    }

    static {
        BABY_HEATSCAR_SPIDER = Util.getResource("entities/baby_heatscar_spider");
        HEATSCAR_SPIDER = Util.getResource("entities/heatscar_spider");
        IMP = Util.getResource("entities/imp");
        NITRO_CREEPER = Util.getResource("entities/nitro_creeper");
    }
}

