/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.common.block;

import com.progwml6.natura.Natura;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;

public class BlockEnumLog<T extends Enum<T> & IStringSerializable>
extends EnumBlock<T> {
    public static final PropertyEnum<EnumAxis> LOG_AXIS = PropertyEnum.func_177709_a((String)"axis", EnumAxis.class);

    public BlockEnumLog(PropertyEnum<T> prop, Class<T> clazz) {
        super(Material.field_151575_d, prop, clazz);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 20);
        this.func_149647_a(Natura.TAB);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("axis")) continue;
            world.func_175656_a(pos, state.func_177231_a(prop));
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175707_a(pos.func_177982_a(-5, -5, -5), pos.func_177982_a(5, 5, 5))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-4, -4, -4), (BlockPos)pos.func_177982_a(4, 4, 4))) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a(LOG_AXIS, (Comparable)((Object)EnumAxis.fromFacingAxis(facing.func_176740_k())));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumAxis)((Object)state.func_177229_b(LOG_AXIS))) {
                    case X: {
                        return state.func_177226_a(LOG_AXIS, (Comparable)((Object)EnumAxis.Z));
                    }
                    case Z: {
                        return state.func_177226_a(LOG_AXIS, (Comparable)((Object)EnumAxis.X));
                    }
                }
                return state;
            }
        }
        return state;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public static enum EnumAxis implements IStringSerializable
    {
        X("x"),
        Y("y"),
        Z("z"),
        NONE("none");

        private final String name;

        private EnumAxis(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis fromFacingAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Y: {
                    return Y;
                }
                case Z: {
                    return Z;
                }
            }
            return NONE;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

