/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.storage.WorldSavedData;

public class HeightMapData
extends WorldSavedData {
    public static final HeightMapData INVALID = new HeightMapData(-1, false){

        @Override
        public boolean isValid() {
            return false;
        }
    };
    public static final HeightMapData EMPTY = new HeightMapData(-1, false){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isValid() {
            return false;
        }
    };
    public LayerData[] layers = new LayerData[0];
    public int dimension;
    public int centerX;
    public int centerZ;
    public byte scale;
    private final boolean isStub;

    public HeightMapData(String name, boolean stub) {
        super(name);
        this.isStub = stub;
    }

    public HeightMapData(int mapId, boolean stub) {
        this(HeightMapData.getMapName(mapId), stub);
    }

    public HeightMapData(String name) {
        this(name, false);
    }

    public static String getMapName(int mapId) {
        return "height_map_" + mapId;
    }

    public boolean isValid() {
        return !this.isStub;
    }

    public boolean isEmpty() {
        return false;
    }

    public void func_76184_a(NBTTagCompound tag) {
        this.dimension = tag.func_74762_e("Dimension");
        this.centerX = tag.func_74762_e("CenterX");
        this.centerZ = tag.func_74762_e("CenterZ");
        this.scale = tag.func_74771_c("Scale");
        NBTTagList layersData = tag.func_150295_c("Layers", 10);
        int length = layersData.func_74745_c();
        this.layers = new LayerData[length];
        for (int i = 0; i < length; ++i) {
            NBTTagCompound layerData = layersData.func_150305_b(i);
            LayerData layer = new LayerData();
            layer.readFromNBT(layerData);
            this.layers[i] = layer;
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        tag.func_74768_a("Dimension", this.dimension);
        tag.func_74768_a("CenterX", this.centerX);
        tag.func_74768_a("CenterZ", this.centerZ);
        tag.func_74774_a("Scale", this.scale);
        NBTTagList result = new NBTTagList();
        for (LayerData data : this.layers) {
            NBTTagCompound layerData = new NBTTagCompound();
            data.writeToNBT(layerData);
            result.func_74742_a((NBTBase)layerData);
        }
        tag.func_74782_a("Layers", (NBTBase)result);
        return tag;
    }

    public void readFromStream(PacketBuffer input) {
        this.dimension = input.readInt();
        this.centerX = input.readInt();
        this.centerZ = input.readInt();
        this.scale = input.readByte();
        int length = input.func_150792_a();
        this.layers = new LayerData[length];
        for (int i = 0; i < length; ++i) {
            LayerData layer = new LayerData();
            layer.readFromStream(input);
            this.layers[i] = layer;
        }
    }

    public void writeToStream(PacketBuffer output) {
        output.writeInt(this.dimension);
        output.writeInt(this.centerX);
        output.writeInt(this.centerZ);
        output.writeByte((int)this.scale);
        output.func_150787_b(this.layers.length);
        for (LayerData data : this.layers) {
            data.writeToStream(output);
        }
    }

    public static class LayerData {
        public byte alpha;
        public byte[] heightMap = new byte[4096];
        public byte[] colorMap = new byte[4096];

        public void readFromNBT(NBTTagCompound tag) {
            this.alpha = tag.func_74771_c("Alpha");
            this.heightMap = tag.func_74770_j("Height");
            this.colorMap = tag.func_74770_j("Color");
        }

        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74774_a("Alpha", this.alpha);
            tag.func_74773_a("Height", this.heightMap);
            tag.func_74773_a("Color", this.colorMap);
        }

        public void readFromStream(PacketBuffer input) {
            this.alpha = input.readByte();
            input.readBytes(this.heightMap);
            input.readBytes(this.colorMap);
        }

        public void writeToStream(PacketBuffer output) {
            output.writeByte((int)this.alpha);
            output.writeBytes(this.heightMap);
            output.writeBytes(this.colorMap);
        }
    }
}

