/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import net.minecraft.client.Minecraft;
import net.minecraft.util.SoundCategory;
import openmods.Log;

public class BeepGenerator {
    private static final int SAMPLE_RATE = 44100;
    private static final int SAMPLES_PER_BUFFER = 5512;
    private static final int BYTES_PER_SAMPLE = 2;
    private static final int BYTES_PER_BUFFER = 11024;
    private static final double BUFFER_DURATION = 0.12498866213151927;
    private static final double FREQUENCY_MAX_CHANGE_PER_BUFFER_DURATION = 50.0;
    private final byte[] scratchBuffer = new byte[11024];
    private static final byte[] ZERO_BUFFER = new byte[11024];
    private short volume = (short)2560;
    private double wavePhase;
    private int beepPhase;
    private double toneFrequency;
    private double targetToneFrequency;
    private double beepFrequency;
    private int samplesPerBeep;
    private WriterThread writerThread;

    public synchronized void start() {
        block3: {
            this.wavePhase = 0.0;
            this.beepPhase = 0;
            if (!this.isRunning()) {
                AudioFormat af = new AudioFormat(44100.0f, 16, 1, true, true);
                try {
                    SourceDataLine line = AudioSystem.getSourceDataLine(af);
                    line.open(af, 44100);
                    this.writerThread = new WriterThread(line);
                    this.writerThread.start();
                }
                catch (LineUnavailableException e) {
                    Log.warn((Throwable)e, (String)"Failed to initialize beeper", (Object[])new Object[0]);
                    if (this.writerThread == null) break block3;
                    this.writerThread.shutdown();
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.writerThread != null) {
            this.writerThread.shutdown();
        }
        this.setTargetToneFrequency(0.0);
        this.setBeepFrequency(0.0);
    }

    public synchronized boolean isRunning() {
        return this.writerThread != null && this.writerThread.isAlive() && !this.writerThread.isShuttingDown();
    }

    private void writeSample(SourceDataLine line) {
        double lastToneFrequency;
        if (this.toneFrequency == 0.0 || this.targetToneFrequency == 0.0) {
            lastToneFrequency = this.targetToneFrequency;
            this.toneFrequency = this.targetToneFrequency;
        } else {
            lastToneFrequency = this.toneFrequency;
            double delta = this.targetToneFrequency - this.toneFrequency;
            this.toneFrequency += BeepGenerator.limit(delta, 50.0);
        }
        byte[] buffer = this.generateSamplesWithSweep(lastToneFrequency, this.toneFrequency);
        line.write(buffer, 0, buffer.length);
    }

    private static double limit(double value, double limit) {
        if (value < 0.0) {
            return Math.max(value, -limit);
        }
        return Math.min(value, limit);
    }

    private byte[] generateSamplesWithSweep(double f0, double f1) {
        if (f0 == 0.0 && f1 == 0.0) {
            return ZERO_BUFFER;
        }
        float masterSoundLevel = Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER);
        if (masterSoundLevel == 0.0f) {
            return ZERO_BUFFER;
        }
        float amplitude = Math.max((float)this.volume * masterSoundLevel, 2.0f);
        double sweepDuration = 0.12498866213151927;
        double k = (f1 - f0) / 0.12498866213151927;
        int sampleCount = 0;
        if (this.samplesPerBeep == 0) {
            int i = 0;
            while (i < 11024) {
                short v = (short)BeepGenerator.calculateSample(amplitude, this.wavePhase, f0, k, BeepGenerator.sampleToRealTime(sampleCount));
                BeepGenerator.writeShortSample(this.scratchBuffer, i, v);
                i += 2;
                ++sampleCount;
            }
        } else {
            int beepSample = this.beepPhase;
            int i = 0;
            while (i < 11024) {
                if (beepSample < this.samplesPerBeep) {
                    short v = (short)BeepGenerator.calculateSample(amplitude, this.wavePhase, f0, k, BeepGenerator.sampleToRealTime(sampleCount));
                    BeepGenerator.writeShortSample(this.scratchBuffer, i, v);
                } else {
                    this.scratchBuffer[i] = 0;
                    this.scratchBuffer[i + 1] = 0;
                }
                if (beepSample++ >= 2 * this.samplesPerBeep) {
                    beepSample = 0;
                }
                i += 2;
                ++sampleCount;
            }
            this.beepPhase = beepSample;
        }
        this.wavePhase = BeepGenerator.phase(this.wavePhase, f0, k, BeepGenerator.sampleToRealTime(sampleCount)) % (Math.PI * 2);
        return this.scratchBuffer;
    }

    private static void writeShortSample(byte[] buf, int i, short v) {
        buf[i] = (byte)(v >> 8);
        buf[i + 1] = (byte)v;
    }

    private static double sampleToRealTime(int sampleCount) {
        return (double)sampleCount / 44100.0;
    }

    private static double calculateSample(float amplitude, double phase0, double f0, double k, double t) {
        return (short)((double)amplitude * Math.sin(BeepGenerator.phase(phase0, f0, k, t)));
    }

    private static double phase(double phase0, double f0, double k, double t) {
        return phase0 + Math.PI * 2 * (f0 + k / 2.0 * t) * t;
    }

    public short getVolume() {
        return this.volume;
    }

    public void setVolume(short volume) {
        this.volume = volume;
    }

    public double getToneFrequency() {
        return this.toneFrequency;
    }

    public double getTargetToneFrequency() {
        return this.targetToneFrequency;
    }

    public void setTargetToneFrequency(double frequency) {
        this.targetToneFrequency = frequency;
    }

    public double getBeepFrequency() {
        return this.beepFrequency;
    }

    public void setBeepFrequency(double beepFrequency) {
        this.beepFrequency = beepFrequency;
        this.samplesPerBeep = beepFrequency == 0.0 ? 0 : (int)(44100.0 / beepFrequency);
    }

    private class WriterThread
    extends Thread {
        private final SourceDataLine line;
        private boolean running = true;

        public WriterThread(SourceDataLine line) {
            this.line = line;
            this.setDaemon(true);
            this.setName("Beeper thread");
        }

        @Override
        public void run() {
            block8: {
                this.line.start();
                block5: while (true) {
                    while (this.running) {
                        int available = this.line.available();
                        if (available >= 5512) {
                            BeepGenerator.this.writeSample(this.line);
                        }
                        try {
                            Thread.sleep(100L);
                            continue block5;
                        }
                        catch (InterruptedException e) {
                            this.running = false;
                        }
                    }
                    break block8;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    this.running = false;
                    this.line.close();
                }
            }
        }

        public boolean isShuttingDown() {
            return !this.running;
        }

        public void shutdown() {
            this.running = false;
        }
    }
}

