/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.model.ModelTextureMap;
import openmods.model.ModelUpdater;
import openmods.utils.CollectionUtils;
import openmods.utils.render.RenderUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PathModel
implements IModel {
    private static final int DEFAULT_MAX_BLOCK_COUNT = 10;
    private static final long NOT_MAGIC_NUMBER = 0L;
    public static final PathModel INSTANCE = new PathModel(new ModelTextureMap(), 10, 0L, Optional.empty());
    private final ModelTextureMap textures;
    private final int maxBlockCount;
    private final long inventorySeed;
    private final Optional<ResourceLocation> inventoryTransformProvider;
    private static final Predicate<EnumFacing> ALL_SIDES = Predicates.alwaysTrue();
    private static final Predicate<EnumFacing> GENERAL = input -> input != EnumFacing.DOWN;
    private static final Predicate<EnumFacing> ONLY_BOTTOM = input -> input == EnumFacing.DOWN;

    public PathModel(ModelTextureMap textures, int maxBlockCount, long inventorySeed, Optional<ResourceLocation> inventoryTransformProvider) {
        this.textures = textures;
        this.maxBlockCount = maxBlockCount;
        this.inventorySeed = inventorySeed;
        this.inventoryTransformProvider = inventoryTransformProvider;
    }

    public Collection<ResourceLocation> getDependencies() {
        return CollectionUtils.asSet(this.inventoryTransformProvider);
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures.getTextures();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Map<ItemCameraTransforms.TransformType, Matrix4f> transforms = this.extractInventoryTransforms(state, format, bakedTextureGetter);
        ArrayList textures = Lists.newArrayList();
        Optional<Object> maybeParticle = Optional.empty();
        for (Map.Entry e : this.textures.bakeWithKeys(bakedTextureGetter).entrySet()) {
            if (((String)e.getKey()).equals("particle")) {
                maybeParticle = Optional.of(e.getValue());
                continue;
            }
            textures.add(e.getValue());
        }
        TextureAtlasSprite missing = bakedTextureGetter.apply(TextureMap.field_174945_f);
        TextureAtlasSprite particle = maybeParticle.orElse(missing);
        if (textures.isEmpty()) {
            textures.add(missing);
        }
        return new Baked(particle, textures, format, transforms);
    }

    private Map<ItemCameraTransforms.TransformType, Matrix4f> extractInventoryTransforms(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.inventoryTransformProvider.isPresent()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)this.inventoryTransformProvider.get(), (String)("Couldn't load MultiLayerModel dependency: " + this.inventoryTransformProvider.get()));
            IBakedModel bakedModel = model.bake(model.getDefaultState(), format, bakedTextureGetter);
            return PathModel.extractInventoryTransformsFromModel(bakedModel);
        }
        return PathModel.extractInventoryTransformsFromState(state);
    }

    private static Map<ItemCameraTransforms.TransformType, Matrix4f> extractInventoryTransformsFromModel(IBakedModel model) {
        HashMap output = Maps.newHashMap();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            Pair transform = model.handlePerspective(type);
            output.put(type, transform.getRight());
        }
        return output;
    }

    private static Map<ItemCameraTransforms.TransformType, Matrix4f> extractInventoryTransformsFromState(IModelState state) {
        HashMap output = Maps.newHashMap();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            TRSRTransformation transform;
            Matrix4f mat = null;
            Optional maybeTransform = state.apply(Optional.of(type));
            if (maybeTransform.isPresent() && !(transform = (TRSRTransformation)maybeTransform.get()).equals((Object)TRSRTransformation.identity())) {
                mat = TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform).getMatrix();
            }
            output.put(type, mat);
        }
        return output;
    }

    public IModel retexture(ImmutableMap<String, String> updates) {
        Optional newTextures = this.textures.update(updates);
        return newTextures.isPresent() ? new PathModel((ModelTextureMap)newTextures.get(), this.maxBlockCount, this.inventorySeed, this.inventoryTransformProvider) : this;
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater(customData);
        int maxBlockCount = (Integer)updater.get("maxBlockCount", ModelUpdater.TO_INT, (Object)this.maxBlockCount);
        long inventorySeed = (Long)updater.get("inventorySeed", ModelUpdater.TO_LONG, (Object)this.inventorySeed);
        Optional inventoryTransformProvider = updater.get("inventoryTransform", ModelUpdater.MODEL_LOCATION, this.inventoryTransformProvider);
        return updater.hasChanged() ? new PathModel(this.textures, maxBlockCount, inventorySeed, inventoryTransformProvider) : this;
    }

    private class Baked
    implements IBakedModel {
        private final TextureAtlasSprite particle;
        private final List<TextureAtlasSprite> textures;
        private final VertexFormat format;
        private final Map<ItemCameraTransforms.TransformType, Matrix4f> transforms;
        private final List<BakedQuad> itemQuads;
        private final Random rand = new Random();

        public Baked(TextureAtlasSprite particle, List<TextureAtlasSprite> textures, VertexFormat format, Map<ItemCameraTransforms.TransformType, Matrix4f> transforms) {
            this.particle = particle;
            this.textures = ImmutableList.copyOf(textures);
            this.format = format;
            this.transforms = transforms;
            this.itemQuads = ImmutableList.copyOf(this.createQuads(PathModel.this.inventorySeed, (Predicate<EnumFacing>)ALL_SIDES));
        }

        private List<BakedQuad> createQuads(long seed, Predicate<EnumFacing> shouldInclude) {
            this.rand.setSeed(seed);
            ArrayList boundingBoxes = Lists.newArrayList();
            block0: for (int i = 0; i < PathModel.this.maxBlockCount; ++i) {
                double width = this.rand.nextDouble() * 0.3 + 0.1;
                double length = this.rand.nextDouble() * 0.3 + 0.1;
                double pX = this.rand.nextDouble() * (1.0 - width);
                double pZ = this.rand.nextDouble() * (1.0 - length);
                AxisAlignedBB bb = new AxisAlignedBB(pX, 0.0, pZ, pX + width, 0.0625, pZ + length);
                for (AxisAlignedBB box : boundingBoxes) {
                    if (!box.func_72326_a(bb)) continue;
                    break block0;
                }
                boundingBoxes.add(bb);
            }
            ArrayList result = Lists.newArrayListWithCapacity((int)(boundingBoxes.size() * 6));
            for (AxisAlignedBB aabb : boundingBoxes) {
                TextureAtlasSprite tex = (TextureAtlasSprite)CollectionUtils.getRandom(this.textures, (Random)this.rand);
                this.addBox(result, aabb, tex, shouldInclude);
            }
            return result;
        }

        private void addBox(final List<BakedQuad> output, AxisAlignedBB aabb, final TextureAtlasSprite texture, final Predicate<EnumFacing> shouldInclude) {
            RenderUtils.renderCube((RenderUtils.IQuadSink)new RenderUtils.IQuadSink(){
                private UnpackedBakedQuad.Builder currentQuad = null;

                public void addVertex(EnumFacing side, int vertex, double x, double y, double z) {
                    if (!shouldInclude.apply((Object)side)) {
                        return;
                    }
                    if (this.currentQuad == null) {
                        this.currentQuad = new UnpackedBakedQuad.Builder(Baked.this.format);
                        this.currentQuad.setApplyDiffuseLighting(true);
                        this.currentQuad.setQuadTint(0);
                        this.currentQuad.setQuadOrientation(side);
                        this.currentQuad.setTexture(texture);
                    }
                    block6: for (int i = 0; i < Baked.this.format.func_177345_h(); ++i) {
                        VertexFormatElement e = Baked.this.format.func_177348_c(i);
                        switch (e.func_177375_c()) {
                            case POSITION: {
                                this.currentQuad.put(i, new float[]{(float)x, (float)y, (float)z});
                                continue block6;
                            }
                            case COLOR: {
                                this.currentQuad.put(i, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                                continue block6;
                            }
                            case NORMAL: {
                                this.currentQuad.put(i, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e()});
                                continue block6;
                            }
                            case UV: {
                                if (e.func_177369_e() == 0) {
                                    this.currentQuad.put(i, new float[]{texture.func_94214_a(16.0 * this.selectU(side, x, y, z)), texture.func_94207_b(16.0 * this.selectV(side, x, y, z))});
                                    continue block6;
                                }
                                this.currentQuad.put(i, new float[]{0.0f, 0.0f});
                                continue block6;
                            }
                            default: {
                                this.currentQuad.put(i, new float[0]);
                            }
                        }
                    }
                    if (vertex == 3) {
                        output.add(this.currentQuad.build());
                        this.currentQuad = null;
                    }
                }

                private double selectV(EnumFacing side, double x, double y, double z) {
                    switch (side) {
                        case UP: 
                        case DOWN: {
                            return z;
                        }
                        case NORTH: {
                            return 1.0 - x;
                        }
                        case SOUTH: {
                            return x;
                        }
                        case EAST: {
                            return 1.0 - z;
                        }
                        case WEST: {
                            return z;
                        }
                    }
                    throw new AssertionError(side);
                }

                private double selectU(EnumFacing side, double x, double y, double z) {
                    switch (side) {
                        case NORTH: 
                        case SOUTH: 
                        case EAST: 
                        case WEST: {
                            return y;
                        }
                        case UP: 
                        case DOWN: {
                            return x;
                        }
                    }
                    throw new AssertionError(side);
                }
            }, (AxisAlignedBB)aabb);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (state == null && rand == 0L) {
                return this.itemQuads;
            }
            if (side == null) {
                return this.createQuads(rand, (Predicate<EnumFacing>)GENERAL);
            }
            if (side == EnumFacing.DOWN) {
                return this.createQuads(rand, (Predicate<EnumFacing>)ONLY_BOTTOM);
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Matrix4f transform = this.transforms.get(cameraTransformType);
            return Pair.of((Object)this, (Object)transform);
        }
    }
}

