/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import net.minecraft.client.gui.FontRenderer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentBook;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.page.TitledPage;
import openmods.gui.listener.IMouseDownListener;
import openmods.utils.TranslationUtils;

public class TocPage
extends TitledPage {
    private static final int TOC_LINE_LEFT_MARGIN = 20;
    private static final int TOC_TOTAL_LINE_WIDTH = 140;
    private static final int TOC_START_HEIGHT = 70;
    private static final int TOC_LINE_HEIGHT = 15;
    private final GuiComponentBook book;
    private final FontRenderer fontRenderer;
    private int nextTocEntry;

    public TocPage(GuiComponentBook book, FontRenderer fontRenderer) {
        super("openblocks.gui.welcome.title", "openblocks.gui.welcome.content");
        this.book = book;
        this.fontRenderer = fontRenderer;
    }

    private static int tocLine(int index) {
        return 70 + index * 15;
    }

    public void addTocEntry(String untranslatedLabel, int pageIndex, int displayedPage) {
        int lineWidthBudget = 140;
        String translatedLabel = TranslationUtils.translateToLocal((String)untranslatedLabel);
        String pageNumber = Integer.toString(displayedPage);
        int labelWidth = this.fontRenderer.func_78256_a(translatedLabel);
        lineWidthBudget -= labelWidth;
        int pageNumberWidth = this.fontRenderer.func_78256_a(pageNumber);
        lineWidthBudget -= pageNumberWidth;
        int spaceWidth = this.fontRenderer.func_78263_a(' ');
        lineWidthBudget -= 2 * spaceWidth;
        int dotWidth = this.fontRenderer.func_78263_a('.');
        StringBuilder paddedPageNumberBuilder = new StringBuilder();
        while (lineWidthBudget - dotWidth > 0) {
            paddedPageNumberBuilder.append('.');
            lineWidthBudget -= dotWidth;
        }
        paddedPageNumberBuilder.append(' ');
        paddedPageNumberBuilder.append(pageNumber);
        String paddedPageNumber = paddedPageNumberBuilder.toString();
        IMouseDownListener pageJumpListener = this.book.createBookmarkListener(pageIndex);
        GuiComponentLabel label = new GuiComponentLabel(20, TocPage.tocLine(this.nextTocEntry), translatedLabel);
        label.setListener(pageJumpListener);
        this.addComponent((BaseComponent)label);
        int pos = 20 + labelWidth + lineWidthBudget;
        GuiComponentLabel label2 = new GuiComponentLabel(pos, TocPage.tocLine(this.nextTocEntry), paddedPageNumber);
        label2.setListener(pageJumpListener);
        this.addComponent((BaseComponent)label2);
        ++this.nextTocEntry;
    }
}

