/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.badmobs.handler;

import java.io.File;
import net.darkhax.badmobs.BadMobs;
import net.darkhax.badmobs.handler.SpawnEventHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean removeAggressively;
    public static boolean addIDToTooltip;
    public static boolean removeNamedMobs;

    public ConfigurationHandler(File file) {
        config = new Configuration(file);
        this.syncConfigData();
    }

    private void syncConfigData() {
        String[] entries;
        removeAggressively = config.getBoolean("removeAggressively", "general", false, "When enabled this mod will target mobs that have already spawned. This option must also be enabled to prevent mob spawners from spawning as well.");
        addIDToTooltip = config.getBoolean("addTooltipInfo", "general", true, "When enabled, the ID of a mob will be shown on it's corrosponding spawn egg. This is used to help you blacklist mobs.");
        removeNamedMobs = config.getBoolean("removeNamedMobs", "general", false, "While false, this mod will not remove custom named mobs from the game.");
        for (String entry : entries = config.getStringList("bannedMobs", "general", new String[]{"example1", "example2", "example3"}, "A list of all banned mobs. If a mobs entity name is added to this list, it will not be allowed to spawn in any world. To get the name of an entity, interact with it using the data checker and it's name will be given.")) {
            String[] parts = entry.split("#");
            if (parts.length == 2 && NumberUtils.isDigits((String)parts[1])) {
                int dimId = Integer.parseInt(parts[1]);
                BadMobs.blacklist(dimId, parts[0]);
                continue;
            }
            BadMobs.blacklist(entry);
        }
        if (removeAggressively) {
            MinecraftForge.EVENT_BUS.register((Object)new SpawnEventHandler());
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        removeAggressively = false;
        addIDToTooltip = true;
        removeNamedMobs = false;
    }
}

