/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile.base;

import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerSupplier;
import me.desht.pneumaticcraft.api.tileentity.IPneumaticMachine;
import modulardiversity.components.requirements.RequirementMysticalMechanics;
import modulardiversity.util.ICraftingResourceHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;

public abstract class TileEntityPneumaticBase
extends TileColorableMachineComponent
implements MachineComponentTile,
ICraftingResourceHolder<RequirementMysticalMechanics.ResourceToken>,
IPneumaticMachine,
ITickable {
    private MachineComponent.IOType ioType;
    public IAirHandler airHandler;
    public int tier;
    public int volume;

    public TileEntityPneumaticBase(MachineComponent.IOType ioType, int tier, int volume) {
        this.ioType = ioType;
        this.tier = tier;
        this.volume = volume;
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.airHandler = this.createAirHandler();
    }

    private IAirHandler createAirHandler() {
        IAirHandlerSupplier supplier = PneumaticRegistry.getInstance().getAirHandlerSupplier();
        switch (this.tier) {
            case 1: {
                return supplier.createTierOneAirHandler(this.volume);
            }
            case 2: {
                return supplier.createTierTwoAirHandler(this.volume);
            }
        }
        return null;
    }

    public IAirHandler getAirHandler(EnumFacing enumFacing) {
        return this.airHandler;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.airHandler.validate((TileEntity)this);
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        this.airHandler.writeToNBT(compound);
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.airHandler.readFromNBT(compound);
    }

    @Override
    public boolean consume(RequirementMysticalMechanics.ResourceToken token, boolean doConsume) {
        return false;
    }

    @Override
    public boolean generate(RequirementMysticalMechanics.ResourceToken token, boolean doGenerate) {
        return false;
    }

    public void onNeighborChange() {
        this.airHandler.onNeighborChange();
    }

    public void func_73660_a() {
        this.airHandler.update();
    }

    @Override
    public String getInputProblem(RequirementMysticalMechanics.ResourceToken token) {
        return "meklaser.input";
    }

    @Override
    public String getOutputProblem(RequirementMysticalMechanics.ResourceToken token) {
        return "meklaser.input";
    }
}

