/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentReservoir;
import modulardiversity.jei.ingredients.Reservoir;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class RequirementReservoir
extends RequirementEnvironmental<Reservoir, ResourceToken> {
    public String name;
    public int fluidMin;
    public int fluidMax;
    public int residualMin;
    public int residualMax;
    public int amount;

    public RequirementReservoir(MachineComponent.IOType actionType, String name, int fluidMin, int fluidMax, int residualMin, int residualMax, int amount) {
        super(ComponentType.Registry.getComponent((String)"reservoir"), actionType);
        this.name = name;
        this.fluidMin = fluidMin;
        this.fluidMax = fluidMax;
        this.residualMin = residualMin;
        this.residualMax = residualMax;
        this.amount = amount;
    }

    public PumpjackHandler.ReservoirType getType() {
        for (PumpjackHandler.ReservoirType type : PumpjackHandler.reservoirList.keySet()) {
            if (!type.name.equals(this.name)) continue;
            return type;
        }
        return null;
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        return "craftcheck.reservoir";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.name, this.fluidMin, this.fluidMax, this.residualMin, this.residualMax, this.amount);
    }

    private PumpjackHandler.OilWorldInfo getReservoir(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        return PumpjackHandler.getOilWorldInfo((World)world, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            PumpjackHandler.OilWorldInfo reservoir = this.getReservoir(tile.func_145831_w(), tile.func_174877_v());
            if (token.matches(tile.func_145831_w(), tile.func_174877_v(), reservoir)) {
                int current = reservoir.current;
                if (doConsume) {
                    reservoir.current = Math.max(0, current + token.getAmount());
                    IPSaveData.setDirty((int)tile.func_145831_w().field_73011_w.getDimension());
                }
                token.setAmount(token.getAmount() - current);
            }
        }
        return true;
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            PumpjackHandler.OilWorldInfo reservoir = this.getReservoir(tile.func_145831_w(), tile.func_174877_v());
            if (token.matches(tile.func_145831_w(), tile.func_174877_v(), reservoir)) {
                if (doGenerate) {
                    int current = reservoir.current;
                    reservoir.current = Math.max(0, current + token.getAmount());
                    IPSaveData.setDirty((int)tile.func_145831_w().field_73011_w.getDimension());
                }
                token.setAmount(0);
            }
        }
        return true;
    }

    public ComponentRequirement<Reservoir> deepCopy() {
        return new RequirementReservoir(this.getActionType(), this.name, this.fluidMin, this.fluidMax, this.residualMin, this.residualMax, this.amount);
    }

    public ComponentRequirement<Reservoir> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementReservoir(this.getActionType(), this.name, Misc.applyModifiers(modifiers, "reservoir_min", this.getActionType(), this.fluidMin, false), Misc.applyModifiers(modifiers, "reservoir_max", this.getActionType(), this.fluidMax, false), Misc.applyModifiers(modifiers, "reservoir_residual_min", this.getActionType(), this.fluidMin, false), Misc.applyModifiers(modifiers, "reservoir_residual_max", this.getActionType(), this.fluidMax, false), Misc.applyModifiers(modifiers, "reservoir", this.getActionType(), this.amount, false));
    }

    public ComponentRequirement.JEIComponent<Reservoir> provideJEIComponent() {
        return new JEIComponentReservoir(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private String name;
        private int fluidMin;
        private int fluidMax;
        private int residualMin;
        private int residualMax;
        private int amount;

        public ResourceToken(String name, int fluidMin, int fluidMax, int residualMin, int residualMax, int amount) {
            this.name = name;
            this.fluidMin = fluidMin;
            this.fluidMax = fluidMax;
            this.residualMin = residualMin;
            this.residualMax = residualMax;
            this.amount = amount;
        }

        public boolean matches(World world, BlockPos pos, PumpjackHandler.OilWorldInfo reservoir) {
            if (reservoir == null) {
                return false;
            }
            ChunkPos chunkPos = new ChunkPos(pos);
            int current = reservoir.current;
            int residual = PumpjackHandler.getResidualFluid((World)world, (int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b);
            return reservoir.getType().name.equals(this.name) && current >= this.fluidMin && current <= this.fluidMax && residual >= this.residualMin && residual <= this.residualMax;
        }

        public int getFluidMin() {
            return this.fluidMin;
        }

        public int getFluidMax() {
            return this.fluidMax;
        }

        public int getResidualMin() {
            return this.residualMin;
        }

        public int getResidualMax() {
            return this.residualMax;
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.fluidMin = Misc.applyModifiers(modifiers, "reservoir_min", ioType, this.fluidMin, false);
            this.fluidMax = Misc.applyModifiers(modifiers, "reservoir_max", ioType, this.fluidMax, false);
            this.residualMin = Misc.applyModifiers(modifiers, "reservoir_residual_min", ioType, this.fluidMin, false);
            this.residualMax = Misc.applyModifiers(modifiers, "reservoir_residual_max", ioType, this.fluidMax, false);
            this.amount = Misc.applyModifiers(modifiers, "reservoir", ioType, this.amount, false);
        }

        @Override
        public boolean isEmpty() {
            return this.amount <= 0;
        }
    }
}

