/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentHotAir;
import modulardiversity.jei.ingredients.HotAir;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;

public class RequirementHotAir
extends RequirementConsumePerTick<HotAir, ResourceToken> {
    public final int requiredTempMin;
    public final int requiredTempMax;
    public final int temp;

    public RequirementHotAir(MachineComponent.IOType ioType, int requiredTempMin, int requiredTempMax, int temp) {
        super(ComponentType.Registry.getComponent((String)"hotair"), ioType);
        this.requiredTempMin = requiredTempMin;
        this.requiredTempMax = requiredTempMax;
        this.temp = temp;
    }

    public ComponentRequirement deepCopy() {
        return new RequirementHotAir(this.getActionType(), this.requiredTempMin, this.requiredTempMax, this.temp);
    }

    public ComponentRequirement<HotAir> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementHotAir(this.getActionType(), Misc.applyModifiers(modifiers, "hotair_min", this.getActionType(), this.requiredTempMin, false), Misc.applyModifiers(modifiers, "hotair_max", this.getActionType(), this.requiredTempMin, false), Misc.applyModifiers(modifiers, "hotair", this.getActionType(), this.temp, false));
    }

    public ComponentRequirement.JEIComponent<HotAir> provideJEIComponent() {
        return new JEIComponentHotAir(this);
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredTempMin, this.requiredTempMax, this.temp);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("hotair") && component instanceof MachineComponents.HotAirHatch && component.getIOType() == this.getActionType();
    }

    public static class ResourceToken
    implements IResourceToken {
        private int tempRequiredMin;
        private int tempRequiredMax;
        private int temp;
        private boolean requiredTempMet;

        public ResourceToken(int tempRequiredMin, int tempRequiredMax, int temp) {
            this.tempRequiredMin = tempRequiredMin;
            this.tempRequiredMax = tempRequiredMax;
            this.temp = temp;
        }

        public int getRequiredMinTemp() {
            return this.tempRequiredMin;
        }

        public int getRequiredMaxTemp() {
            return this.tempRequiredMax;
        }

        public int getTemp() {
            return this.temp;
        }

        public void setRequiredTempMet() {
            this.requiredTempMet = true;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.tempRequiredMin = Misc.applyModifiers(modifiers, "hotair_min", ioType, this.tempRequiredMin, false);
            this.tempRequiredMax = Misc.applyModifiers(modifiers, "hotair_max", ioType, this.tempRequiredMax, false);
            this.temp = Misc.applyModifiers(modifiers, "hotair", ioType, this.temp, false);
        }

        @Override
        public boolean isEmpty() {
            return this.requiredTempMet;
        }
    }
}

