/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumeOnce;
import modulardiversity.jei.JEIComponentEmber;
import modulardiversity.jei.ingredients.Embers;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;

public class RequirementEmber
extends RequirementConsumeOnce<Embers, ResourceToken> {
    public double requiredEmber;

    public RequirementEmber(MachineComponent.IOType actionType, double requiredEmber) {
        super(ComponentType.Registry.getComponent((String)"ember"), actionType);
        this.requiredEmber = requiredEmber;
    }

    public ComponentRequirement deepCopy() {
        return new RequirementEmber(this.getActionType(), this.requiredEmber);
    }

    public ComponentRequirement<Embers> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementEmber(this.getActionType(), Misc.applyModifiers(modifiers, "ember", this.getActionType(), this.requiredEmber, false));
    }

    public ComponentRequirement.JEIComponent<Embers> provideJEIComponent() {
        return new JEIComponentEmber(this);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("ember") && component instanceof MachineComponents.EmberHatch && component.getIOType() == this.getActionType();
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.requiredEmber);
    }

    public static class ResourceToken
    implements IResourceToken {
        private double ember;

        public ResourceToken(double ember) {
            this.ember = ember;
        }

        public double getEmber() {
            return this.ember;
        }

        public void setEmber(double ember) {
            this.ember = ember;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
            this.ember = Misc.applyModifiers(modifiers, "ember", ioType, this.ember, false);
        }

        @Override
        public boolean isEmpty() {
            return this.ember <= 0.0;
        }
    }
}

