/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentDaylight;
import modulardiversity.jei.ingredients.Daylight;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RequirementDaylight
extends RequirementEnvironmental<Daylight, ResourceToken> {
    public long timeMin;
    public long timeMax;
    public long timeModulo;
    public boolean timeLocal;

    private boolean isTimeValid(long time) {
        if ((time %= this.timeModulo) > Math.min(this.timeMin, this.timeMax) && time <= Math.max(this.timeMin, this.timeMax)) {
            return this.timeMin < this.timeMax;
        }
        return this.timeMin >= this.timeMax;
    }

    public RequirementDaylight(MachineComponent.IOType actionType, long min, long max, long modulo, boolean local) {
        super(ComponentType.Registry.getComponent((String)"daylight"), actionType);
        this.timeMin = min;
        this.timeMax = max;
        this.timeModulo = modulo;
        this.timeLocal = local;
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null) {
            World world = tile.func_145831_w();
            long time = world.func_82737_E();
            if (this.timeLocal) {
                time -= time % 24000L;
                time += world.func_72820_D();
            }
            if (this.isTimeValid(time)) {
                token.setRequirementMet();
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        return false;
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        return "craftcheck.time";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken();
    }

    public ComponentRequirement deepCopy() {
        return new RequirementDaylight(this.getActionType(), this.timeMin, this.timeMax, this.timeModulo, this.timeLocal);
    }

    public ComponentRequirement<Daylight> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementDaylight(this.getActionType(), this.timeMin, this.timeMax, this.timeModulo, this.timeLocal);
    }

    public ComponentRequirement.JEIComponent<Daylight> provideJEIComponent() {
        return new JEIComponentDaylight(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private boolean requirementMet;

        public void setRequirementMet() {
            this.requirementMet = true;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
        }

        @Override
        public boolean isEmpty() {
            return this.requirementMet;
        }
    }
}

