/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.MachineComponents;
import modulardiversity.components.requirements.RequirementConsumePerTick;
import modulardiversity.jei.JEIComponentAir;
import modulardiversity.jei.ingredients.Air;
import modulardiversity.util.IResourceToken;

public class RequirementAir
extends RequirementConsumePerTick<Air, ResourceToken> {
    public final int volumeConsumed;
    public final float pressureRequired;

    public RequirementAir(MachineComponent.IOType actionType, int volumeConsumed, float pressureRequired) {
        super(ComponentType.Registry.getComponent((String)"pneumatic_air"), actionType);
        this.volumeConsumed = volumeConsumed;
        this.pressureRequired = pressureRequired;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken(this.volumeConsumed, this.pressureRequired);
    }

    @Override
    protected boolean isCorrectHatch(MachineComponent component) {
        return component.getComponentType().getRegistryName().equals("pneumatic_air") && component instanceof MachineComponents.AirHatch && component.getIOType() == this.getActionType();
    }

    public ComponentRequirement deepCopy() {
        return new RequirementAir(this.getActionType(), this.volumeConsumed, this.pressureRequired);
    }

    public ComponentRequirement<Air> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementAir(this.getActionType(), this.volumeConsumed, this.pressureRequired);
    }

    public ComponentRequirement.JEIComponent<Air> provideJEIComponent() {
        return new JEIComponentAir(this);
    }

    public static class ResourceToken
    implements IResourceToken {
        private int volumeConsumed;
        private float pressureRequired;

        public ResourceToken(int volumeConsumed, float pressureRequired) {
            this.volumeConsumed = volumeConsumed;
            this.pressureRequired = pressureRequired;
        }

        public int getVolumeConsumed() {
            return this.volumeConsumed;
        }

        public void setVolumeConsumed(int volumeConsumed) {
            this.volumeConsumed = volumeConsumed;
        }

        public float getPressureRequired() {
            return this.pressureRequired;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
        }

        @Override
        public boolean isEmpty() {
            return this.volumeConsumed <= 0;
        }
    }
}

