/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.WanionLib;
import wanion.lib.common.IResourceShapedContainer;

public class DefineShapeMessage
implements IMessage {
    private int windowId;
    private ResourceLocation resourceLocation;

    public DefineShapeMessage(int windowId, ResourceLocation resourceLocation) {
        this.windowId = windowId;
        this.resourceLocation = resourceLocation;
    }

    public DefineShapeMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.resourceLocation = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.windowId, (int)5);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.resourceLocation.toString());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(@Nonnull Container container, @Nonnull ResourceLocation resourceLocation) {
        WanionLib.networkWrapper.sendToServer((IMessage)new DefineShapeMessage(container.field_75152_c, resourceLocation));
    }

    public static class Handler
    implements IMessageHandler<DefineShapeMessage, IMessage> {
        public IMessage onMessage(DefineShapeMessage message, MessageContext ctx) {
            WanionLib.proxy.getThreadListener().func_152344_a(() -> {
                EntityPlayer entityPlayer = WanionLib.proxy.getEntityPlayerFromContext(ctx);
                if (entityPlayer != null && entityPlayer.field_71070_bA instanceof IResourceShapedContainer && entityPlayer.field_71070_bA.field_75152_c == message.windowId) {
                    ((IResourceShapedContainer)entityPlayer.field_71070_bA).defineShape(message.resourceLocation);
                }
            });
            return null;
        }
    }
}

