/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.utils;

import java.awt.Color;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public final class EmtRender {
    private static final Tessellator TESSELLATOR = Tessellator.func_178181_a();
    private static final BufferBuilder BUFFER_BUILDER = TESSELLATOR.func_178180_c();
    private static final FontRenderer FONT_RENDERER = Minecraft.func_71410_x().field_71466_p;
    private static boolean glVersionParsed = false;
    private static int majorGlVersion = -1;
    private static int minorGlVersion = -1;
    private static String rawGlVersion = "";
    private static boolean isActiveRenderInfoGettersInit = false;
    private static Supplier<FloatBuffer> modelViewMatrixGetter;
    private static Supplier<FloatBuffer> projectionMatrixGetter;
    private static boolean isPartialTickGetterInit;
    private static Supplier<Double> partialTickGetter;

    public static void renderRect(float x, float y, float width, float height, Color color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        BUFFER_BUILDER.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        BUFFER_BUILDER.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)(x + width), (double)y, 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)x, (double)(y + height), 0.0).func_181675_d();
        TESSELLATOR.func_78381_a();
        GlStateManager.func_179121_F();
    }

    public static void renderText(String text, float x, float y, int color) {
        EmtRender.renderText(text, x, y, 1.0f, color, false);
    }

    public static void renderText(String text, float x, float y, float scale, int color, boolean shadow) {
        GlStateManager.func_179129_p();
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179097_i();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)0.0f);
        FONT_RENDERER.func_175065_a(text, 0.0f, 0.0f, color, shadow);
        GlStateManager.func_179121_F();
    }

    public static void renderRoundedRect(float x, float y, float width, float height, float radius, Color color) {
        int segments = Math.max(3, (int)(radius / 2.0f));
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        BUFFER_BUILDER.func_181668_a(6, DefaultVertexFormats.field_181705_e);
        EmtRender.addArcVertices(x + width - radius, y + radius, radius, 0.0f, 90.0f, segments);
        BUFFER_BUILDER.func_181662_b((double)(x + width), (double)(y + radius), 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)(x + width), (double)(y + height - radius), 0.0).func_181675_d();
        EmtRender.addArcVertices(x + width - radius, y + height - radius, radius, 90.0f, 180.0f, segments);
        BUFFER_BUILDER.func_181662_b((double)(x + width - radius), (double)(y + height), 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)(x + radius), (double)(y + height), 0.0).func_181675_d();
        EmtRender.addArcVertices(x + radius, y + height - radius, radius, 180.0f, 270.0f, segments);
        BUFFER_BUILDER.func_181662_b((double)x, (double)(y + height - radius), 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)x, (double)(y + radius), 0.0).func_181675_d();
        EmtRender.addArcVertices(x + radius, y + radius, radius, 270.0f, 360.0f, segments);
        BUFFER_BUILDER.func_181662_b((double)(x + radius), (double)y, 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)(x + width - radius), (double)y, 0.0).func_181675_d();
        TESSELLATOR.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private static void addArcVertices(float cx, float cy, float radius, float startAngle, float endAngle, int segments) {
        endAngle -= 90.0f;
        float x = (float)((double)cx + Math.cos(Math.toRadians(startAngle -= 90.0f)) * (double)radius);
        float y = (float)((double)cy + Math.sin(Math.toRadians(startAngle)) * (double)radius);
        for (int i = 1; i <= segments; ++i) {
            float angle = (float)Math.toRadians(startAngle + (endAngle - startAngle) * (float)i / (float)segments);
            float dx = (float)((double)cx + Math.cos(angle) * (double)radius);
            float dy = (float)((double)cy + Math.sin(angle) * (double)radius);
            BUFFER_BUILDER.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
            BUFFER_BUILDER.func_181662_b((double)dx, (double)dy, 0.0).func_181675_d();
            x = dx;
            y = dy;
        }
    }

    public static void prepareStencilToWrite(int stencilValue) {
        if (!Minecraft.func_71410_x().func_147110_a().isStencilEnabled()) {
            Minecraft.func_71410_x().func_147110_a().enableStencil();
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179129_p();
        GL11.glEnable((int)2960);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glStencilFunc((int)519, (int)stencilValue, (int)255);
        GL11.glStencilOp((int)7681, (int)7681, (int)7681);
        GL11.glStencilMask((int)255);
    }

    public static void prepareStencilToRender(int stencilValue) {
        GL11.glStencilMask((int)0);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glStencilFunc((int)514, (int)stencilValue, (int)255);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
    }

    public static void endStencil() {
        GL11.glDisable((int)2960);
    }

    public static void drawRectStencilArea(float x, float y, float width, float height) {
        BUFFER_BUILDER.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        BUFFER_BUILDER.func_181662_b((double)x, (double)y, 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)(x + width), (double)y, 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181675_d();
        BUFFER_BUILDER.func_181662_b((double)x, (double)(y + height), 0.0).func_181675_d();
        TESSELLATOR.func_78381_a();
    }

    public static int getMajorGlVersion() {
        if (!glVersionParsed) {
            EmtRender.parseGlVersion();
        }
        return majorGlVersion;
    }

    public static int getMinorGlVersion() {
        if (!glVersionParsed) {
            EmtRender.parseGlVersion();
        }
        return minorGlVersion;
    }

    public static String getRawGlVersion() {
        if (!glVersionParsed) {
            EmtRender.parseGlVersion();
        }
        return rawGlVersion;
    }

    private static void parseGlVersion() {
        glVersionParsed = true;
        rawGlVersion = GL11.glGetString((int)7938);
        if (rawGlVersion != null) {
            String[] parts = rawGlVersion.split("\\s+")[0].split("\\.");
            if (parts.length >= 2) {
                try {
                    majorGlVersion = Integer.parseInt(parts[0]);
                    minorGlVersion = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            rawGlVersion = "";
        }
        if (rawGlVersion.isEmpty() || majorGlVersion == -1 || minorGlVersion == -1) {
            throw new RuntimeException("EmtRender.parseGlVersion() failed to parse GL version.");
        }
    }

    public static FloatBuffer getModelViewMatrix() {
        if (!isActiveRenderInfoGettersInit) {
            EmtRender.initActiveRenderInfoGetters();
        }
        return modelViewMatrixGetter.get();
    }

    public static FloatBuffer getProjectionMatrix() {
        if (!isActiveRenderInfoGettersInit) {
            EmtRender.initActiveRenderInfoGetters();
        }
        return projectionMatrixGetter.get();
    }

    private static void initActiveRenderInfoGetters() {
        MethodHandle handle;
        isActiveRenderInfoGettersInit = true;
        Field modelViewMatrixField = null;
        try {
            modelViewMatrixField = ActiveRenderInfo.class.getDeclaredField("MODELVIEW");
        }
        catch (Exception ignored) {
            try {
                modelViewMatrixField = ActiveRenderInfo.class.getDeclaredField("field_178812_b");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (modelViewMatrixField == null) {
            throw new RuntimeException("EmtRender.initActiveRenderInfoGetters() failed to find the getter of MODELVIEW.");
        }
        Field projectionMatrixField = null;
        try {
            projectionMatrixField = ActiveRenderInfo.class.getDeclaredField("PROJECTION");
        }
        catch (Exception ignored) {
            try {
                projectionMatrixField = ActiveRenderInfo.class.getDeclaredField("field_178813_c");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (projectionMatrixField == null) {
            throw new RuntimeException("EmtRender.initActiveRenderInfoGetters() failed to find the getter of PROJECTION.");
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            modelViewMatrixField.setAccessible(true);
            handle = lookup.unreflectGetter(modelViewMatrixField);
            modelViewMatrixGetter = () -> {
                try {
                    return handle.invoke();
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        try {
            projectionMatrixField.setAccessible(true);
            handle = lookup.unreflectGetter(projectionMatrixField);
            projectionMatrixGetter = () -> {
                try {
                    return handle.invoke();
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static double getPartialTick() {
        Minecraft minecraft;
        if (!isPartialTickGetterInit) {
            EmtRender.initPartialTickGetter();
        }
        return (minecraft = Minecraft.func_71410_x()).func_147113_T() ? partialTickGetter.get() : (double)minecraft.func_184121_ak();
    }

    private static void initPartialTickGetter() {
        isPartialTickGetterInit = true;
        Field partialTickField = null;
        try {
            partialTickField = Minecraft.class.getDeclaredField("renderPartialTicksPaused");
        }
        catch (Exception ignored) {
            try {
                partialTickField = Minecraft.class.getDeclaredField("field_193996_ah");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (partialTickField == null) {
            throw new RuntimeException("EmtRender.initPartialTickGetter() failed to find the getter of renderPartialTicksPaused.");
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            partialTickField.setAccessible(true);
            MethodHandle handle = lookup.unreflectGetter(partialTickField);
            partialTickGetter = () -> {
                try {
                    return handle.invoke(Minecraft.func_71410_x());
                }
                catch (Throwable e) {
                    return null;
                }
            };
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Vector3f getWorldOffset() {
        double partialTick = EmtRender.getPartialTick();
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        double camX = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTick;
        double camY = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTick;
        double camZ = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTick;
        return new Vector3f((float)camX, (float)camY, (float)camZ);
    }

    public static Vector3f getCameraPos() {
        double partialTick = EmtRender.getPartialTick();
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return new Vector3f(0.0f, 0.0f, 0.0f);
        }
        double camX = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTick;
        double camY = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTick + (double)viewEntity.func_70047_e();
        double camZ = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTick;
        return new Vector3f((float)camX, (float)camY, (float)camZ);
    }

    public static Vector2f getCameraRotationInDegree() {
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return new Vector2f(0.0f, 0.0f);
        }
        return new Vector2f(viewEntity.field_70177_z, viewEntity.field_70125_A);
    }

    public static Vector2f getCameraRotationInRadian() {
        Entity viewEntity = Minecraft.func_71410_x().func_175606_aa();
        if (viewEntity == null) {
            return new Vector2f(0.0f, 0.0f);
        }
        return new Vector2f((float)Math.toRadians(viewEntity.field_70177_z), (float)Math.toRadians(viewEntity.field_70125_A));
    }

    static {
        isPartialTickGetterInit = false;
    }
}

