/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.config.CfgModpack;
import io.enderdev.endermodpacktweaks.utils.EmtSide;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public final class EmtModpackInfo {
    private String modpackName;
    private String modpackVersion;
    private String modpackAuthor;
    private boolean sourcedFromManifest;
    private boolean readFromManifest;

    public EmtModpackInfo(boolean readFromManifest) {
        this.modpackName = CfgModpack.MODPACK.modpackName;
        this.modpackVersion = CfgModpack.MODPACK.modpackVersion;
        this.modpackAuthor = CfgModpack.MODPACK.modpackAuthor;
        this.sourcedFromManifest = false;
        this.readFromManifest = true;
        if (!readFromManifest || !EmtSide.isClient()) {
            this.readFromManifest = false;
            return;
        }
        File f = new File("manifest.json");
        if (!f.exists()) {
            EnderModpackTweaks.LOGGER.warn("manifest.json file not found, trying minecraftinstance.json");
            f = new File("minecraftinstance.json");
        }
        if (f.exists()) {
            try (FileReader reader = new FileReader(f);){
                Gson gson = new GsonBuilder().create();
                ManifestInfo manifestInfo = (ManifestInfo)gson.fromJson((Reader)reader, ManifestInfo.class);
                if (manifestInfo != null) {
                    this.modpackName = manifestInfo.name;
                    this.modpackVersion = manifestInfo.version;
                    this.modpackAuthor = manifestInfo.author;
                    this.sourcedFromManifest = true;
                }
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                EnderModpackTweaks.LOGGER.error("Failed to read manifest file", e);
            }
        } else {
            EnderModpackTweaks.LOGGER.warn("Manifest file not found");
        }
    }

    public boolean error() {
        return !this.sourcedFromManifest && this.readFromManifest;
    }

    public String getName() {
        return this.modpackName;
    }

    public String getVersion() {
        return this.modpackVersion;
    }

    public String getAuthor() {
        return this.modpackAuthor;
    }

    private static class ManifestInfo {
        String name = null;
        String version = null;
        String author = null;

        private ManifestInfo() {
        }
    }
}

