/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.utils;

import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public final class EmtConfigParser {

    public static class ConfigItemWithBoolean
    extends ConfigItem {
        private final boolean value;

        public ConfigItemWithBoolean(String configString) {
            String[] parts = configString.split(";");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid config string format: " + configString);
            }
            this.parseConfigString(parts[0]);
            this.value = Boolean.parseBoolean(parts[1]);
            this.validateConfigItem();
        }

        public boolean value() {
            return this.value;
        }
    }

    public static class ConfigItemWithInt
    extends ConfigItem {
        private final int value;

        public ConfigItemWithInt(String configString) {
            String[] parts = configString.split(";");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid config string format: " + configString);
            }
            this.parseConfigString(parts[0]);
            this.value = Integer.parseInt(parts[1]);
            this.validateConfigItem();
        }

        public int value() {
            return this.value;
        }
    }

    public static class ConfigItemWithFloat
    extends ConfigItem {
        private final float value;

        public ConfigItemWithFloat(String configString) {
            String[] parts = configString.split(";");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid config string format: " + configString);
            }
            this.parseConfigString(parts[0]);
            this.value = Float.parseFloat(parts[1]);
            this.validateConfigItem();
        }

        public float value() {
            return this.value;
        }
    }

    public static class ConfigItem {
        private String modid;
        private String item;
        private int meta;

        ConfigItem() {
        }

        public ConfigItem(String configString) {
            this.parseConfigString(configString);
            this.validateConfigItem();
        }

        public boolean compare(Object obj) {
            if (obj instanceof ItemStack) {
                return this.meta == -1 ? ((ItemStack)obj).func_77973_b() == this.toItemStack().func_77973_b() : ((ItemStack)obj).func_77969_a(this.toItemStack());
            }
            if (obj instanceof ConfigItem) {
                ConfigItem other = (ConfigItem)obj;
                return this.modid.equals(other.modid) && this.item.equals(other.item) && this.meta == other.meta;
            }
            return super.equals(obj);
        }

        public ItemStack toItemStack() {
            return new ItemStack(Objects.requireNonNull(Item.func_111206_d((String)new ResourceLocation(this.modid, this.item).toString())), 1, this.meta);
        }

        void parseConfigString(String configString) {
            String[] parts = configString.split(":");
            if (parts.length == 3) {
                this.modid = parts[0];
                this.item = parts[1];
                this.meta = Integer.parseInt(parts[2]);
            } else if (parts.length == 2) {
                this.modid = parts[0];
                this.item = parts[1];
                this.meta = -1;
            } else {
                throw new IllegalArgumentException("Invalid config string format: " + configString);
            }
        }

        void validateConfigItem() {
            if (this.modid == null || this.item == null) {
                throw new IllegalArgumentException("Mod ID and item name cannot be null");
            }
            if (!Loader.isModLoaded((String)this.modid)) {
                throw new IllegalArgumentException("Mod ID is not loaded: " + this.modid);
            }
            if (this.meta < 0 && this.meta != -1) {
                throw new IllegalArgumentException("Meta value cannot be negative");
            }
        }
    }
}

