/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.utils;

import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.utils.EmtConfigParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public final class EmtConfigHandler<T extends EmtConfigParser.ConfigItem> {
    private final List<T> configItems = new ArrayList<T>();
    private final String[] configData;
    private final Function<String, T> parser;
    private boolean initialized = false;

    public EmtConfigHandler(String[] configData, Function<String, T> parser) {
        this.configData = configData;
        this.parser = parser;
    }

    public EmtConfigHandler<T> init() {
        for (String line : this.configData) {
            try {
                EmtConfigParser.ConfigItem entry = (EmtConfigParser.ConfigItem)this.parser.apply(line);
                this.configItems.add(entry);
            }
            catch (Exception e) {
                EnderModpackTweaks.LOGGER.error("Error parsing config data: {}", (Object)line, (Object)e);
            }
        }
        this.initialized = true;
        return this;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean contains(ItemStack stack) {
        return this.configItems.stream().anyMatch(item -> item.compare(stack));
    }

    public boolean equipped(EntityPlayer player) {
        for (ItemStack itemStack : player.func_184209_aF()) {
            if (!this.contains(itemStack)) continue;
            return true;
        }
        return false;
    }

    public EmtConfigParser.ConfigItem getEquipped(EntityPlayer player) {
        for (ItemStack itemStack : player.func_184209_aF()) {
            this.get(itemStack);
        }
        return null;
    }

    public EmtConfigParser.ConfigItem get(ItemStack stack) {
        for (EmtConfigParser.ConfigItem item : this.configItems) {
            if (!item.compare(stack)) continue;
            return item;
        }
        return null;
    }
}

