/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.render.shader;

import io.enderdev.endermodpacktweaks.render.CommonBuffers;
import io.enderdev.endermodpacktweaks.render.shader.Shader;
import io.enderdev.endermodpacktweaks.render.shader.uniform.UniformField;
import io.enderdev.endermodpacktweaks.render.shader.uniform.UniformType;
import io.enderdev.endermodpacktweaks.render.shader.uniform.UniformTypeKind;
import io.enderdev.endermodpacktweaks.render.shader.uniform.Variant;
import io.enderdev.endermodpacktweaks.utils.EmtType;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.time.StopWatch;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL40;

public class ShaderProgram
implements Comparable<ShaderProgram> {
    private boolean setup;
    private double cpuTimeMs;
    private double gpuTimeMs;
    private int prevProgramID;
    private int programID;
    private final Map<UniformField, Integer> uniformFields = new ConcurrentHashMap<UniformField, Integer>();
    private final List<Integer> shaderIDs = new ArrayList<Integer>();
    private final List<Shader> shaders = new ArrayList<Shader>();

    public boolean getSetup() {
        return this.setup;
    }

    public int getProgramID() {
        return this.programID;
    }

    public String getSetupDebugReport() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n===Shader Program Setup Report===\n").append("Shaders:\n");
        for (Shader shader : this.shaders) {
            builder.append(String.format("  - [%s] %s", shader.getShaderType().toString(), shader.getFileName())).append("\n").append("    - Validity: ").append(shader.getValidity() ? "valid" : "invalid").append("\n");
            if (shader.getValidity()) continue;
            builder.append("    - Error Log: ").append(shader.getErrorLog()).append("\n");
        }
        builder.append("\nActive Shaders:\n");
        Iterator<Object> iterator = this.shaderIDs.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Shader shader = this.getShaderByID(n);
            if (shader == null) continue;
            builder.append(String.format("  - [%s] %s", shader.getShaderType().toString(), shader.getFileName())).append("\n").append("    - Shader GL ID: ").append(shader.getShaderID()).append("\n").append("    - Uniform Fields:").append(shader.getUniformFields().isEmpty() ? " (Empty)" : "").append("\n");
            for (UniformField field : shader.getUniformFields()) {
                builder.append(String.format("      - [%s] %s", field.getType(), field.getFieldName())).append("\n");
            }
        }
        builder.append("\nShader Program:\n").append("  - Program GL ID: ").append(this.programID).append("\n").append("  - Program Uniform Fields:").append(this.uniformFields.isEmpty() ? " (Empty)" : "").append("\n");
        for (Map.Entry entry : this.uniformFields.entrySet()) {
            builder.append(String.format("    - [%s] %s, GL Loc: %d", ((UniformField)entry.getKey()).getType(), ((UniformField)entry.getKey()).getFieldName(), entry.getValue())).append("\n");
        }
        builder.append("\nCPU Time Taken: ").append(this.cpuTimeMs).append(" ms").append("\n");
        builder.append("GPU Time Taken: ").append(this.gpuTimeMs).append(" ms").append("\n");
        builder.append("\n===End of the Setup Report===");
        return builder.toString();
    }

    @Nullable
    private Shader getShaderByID(int shaderID) {
        for (Shader shader : this.shaders) {
            if (shaderID != shader.getShaderID()) continue;
            return shader;
        }
        return null;
    }

    public ShaderProgram(Shader ... shaders) {
        this.shaders.addAll(Arrays.asList(shaders));
        this.setup = false;
    }

    public void setup() {
        if (this.setup) {
            return;
        }
        int gpuTimeQueryID = GL15.glGenQueries();
        GL15.glBeginQuery((int)35007, (int)gpuTimeQueryID);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        for (Shader shader : this.shaders) {
            shader.compile();
            if (!shader.getValidity()) continue;
            this.shaderIDs.add(shader.getShaderID());
        }
        Iterator<Object> iterator = this.shaderIDs.iterator();
        while (iterator.hasNext()) {
            int shaderID = (Integer)iterator.next();
            Shader shader = this.getShaderByID(shaderID);
            if (shader == null) continue;
            ArrayList<String> nameCache = new ArrayList<String>();
            for (UniformField field : shader.getUniformFields()) {
                if (nameCache.contains(field.getFieldName())) continue;
                nameCache.add(field.getFieldName());
                this.uniformFields.put(field, -1);
            }
        }
        this.programID = GL20.glCreateProgram();
        iterator = this.shaderIDs.iterator();
        while (iterator.hasNext()) {
            int shaderID = (Integer)iterator.next();
            GL20.glAttachShader((int)this.programID, (int)shaderID);
        }
        GL20.glLinkProgram((int)this.programID);
        Iterator<Map.Entry<UniformField, Integer>> iterator2 = this.uniformFields.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<UniformField, Integer> entry = iterator2.next();
            int uniformLocation = GL20.glGetUniformLocation((int)this.programID, (CharSequence)entry.getKey().getFieldName());
            if (uniformLocation != -1) {
                entry.setValue(uniformLocation);
                continue;
            }
            iterator2.remove();
        }
        stopWatch.stop();
        this.cpuTimeMs = stopWatch.getTime();
        GL15.glEndQuery((int)35007);
        GL15.glGetQueryObject((int)gpuTimeQueryID, (int)34918, (IntBuffer)CommonBuffers.intBuffer);
        this.gpuTimeMs = (double)CommonBuffers.intBuffer.get(0) / 1000000.0;
        this.setup = true;
    }

    public int getUniformLocation(UniformField field) {
        Integer loc = this.uniformFields.get(field);
        if (loc == null) {
            return -1;
        }
        return loc;
    }

    public int getUniformLocation(String fieldName) {
        for (Map.Entry<UniformField, Integer> entry : this.uniformFields.entrySet()) {
            if (!entry.getKey().getFieldName().equals(fieldName)) continue;
            return entry.getValue();
        }
        return GL20.glGetUniformLocation((int)this.programID, (CharSequence)fieldName);
    }

    @Nullable
    public UniformField getUniform(String fieldName) {
        for (Map.Entry<UniformField, Integer> entry : this.uniformFields.entrySet()) {
            if (!entry.getKey().getFieldName().equals(fieldName)) continue;
            return entry.getKey();
        }
        return null;
    }

    private static float getFloat(Class<?> clazz, Object value) {
        float v = 0.0f;
        if (EmtType.isFloatOrWrappedFloat(clazz)) {
            v = ((Float)value).floatValue();
        } else if (EmtType.isIntOrWrappedInt(clazz)) {
            v = ((Integer)value).intValue();
        } else if (EmtType.isDoubleOrWrappedDouble(clazz)) {
            v = (float)((Double)value).doubleValue();
        }
        return v;
    }

    private static double getDouble(Class<?> clazz, Object value) {
        double v = 0.0;
        if (EmtType.isDoubleOrWrappedDouble(clazz)) {
            v = (Double)value;
        } else if (EmtType.isIntOrWrappedInt(clazz)) {
            v = ((Integer)value).intValue();
        } else if (EmtType.isFloatOrWrappedFloat(clazz)) {
            v = ((Float)value).floatValue();
        }
        return v;
    }

    private static int getInt(Class<?> clazz, Object value) {
        int v = 0;
        if (EmtType.isIntOrWrappedInt(clazz)) {
            v = (Integer)value;
        }
        return v;
    }

    private static int getUint(Class<?> clazz, Object value) {
        int v = 0;
        if (EmtType.isIntOrWrappedInt(clazz)) {
            v = (Integer)value;
        } else if (EmtType.isLongOrWrappedLong(clazz)) {
            v = (int)((Long)value & 0xFFFFFFFFL);
        }
        return v;
    }

    private static int getBool(Class<?> clazz, Object value) {
        int v = 0;
        if (EmtType.isBooleanOrWrappedBoolean(clazz)) {
            v = (Boolean)value != false ? 1 : 0;
        } else if (EmtType.isIntOrWrappedInt(clazz)) {
            v = (Integer)value > 0 ? 1 : 0;
        }
        return v;
    }

    public void setUniform(String fieldName, Object ... values) {
        Object value;
        UniformField field = null;
        int loc = 0;
        for (Map.Entry<UniformField, Integer> entry : this.uniformFields.entrySet()) {
            if (!entry.getKey().getFieldName().equals(fieldName)) continue;
            field = entry.getKey();
            loc = entry.getValue();
        }
        if (field == null) {
            return;
        }
        UniformType type = field.getType();
        if (type.getKind() == UniformTypeKind.SCALAR) {
            value = values[0];
            Class<?> clazz = value.getClass();
            if (type.getSymbol().equals("float")) {
                GL20.glUniform1f((int)loc, (float)ShaderProgram.getFloat(clazz, value));
            } else if (type.getSymbol().equals("double")) {
                GL40.glUniform1d((int)loc, (double)ShaderProgram.getDouble(clazz, value));
            } else if (type.getSymbol().equals("int")) {
                GL20.glUniform1i((int)loc, (int)ShaderProgram.getInt(clazz, value));
            } else if (type.getSymbol().equals("unit")) {
                GL30.glUniform1ui((int)loc, (int)ShaderProgram.getUint(clazz, value));
            } else if (type.getSymbol().equals("bool")) {
                GL20.glUniform1i((int)loc, (int)ShaderProgram.getBool(clazz, value));
            }
        } else if (type.getKind() == UniformTypeKind.VECTOR) {
            Object value0;
            if (type.getSymbol().equals("vec2")) {
                value0 = values[0];
                Class<?> clazz0 = value0.getClass();
                Object value1 = values[1];
                Class<?> clazz1 = value1.getClass();
                if (type.getVariant() == Variant.DEFAULT) {
                    GL20.glUniform2f((int)loc, (float)ShaderProgram.getFloat(clazz0, value0), (float)ShaderProgram.getFloat(clazz1, value1));
                } else if (type.getVariant() == Variant.I) {
                    GL20.glUniform2i((int)loc, (int)ShaderProgram.getInt(clazz0, value0), (int)ShaderProgram.getInt(clazz1, value1));
                } else if (type.getVariant() == Variant.U) {
                    GL30.glUniform2ui((int)loc, (int)ShaderProgram.getUint(clazz0, value0), (int)ShaderProgram.getUint(clazz1, value1));
                }
            } else if (type.getSymbol().equals("vec3")) {
                value0 = values[0];
                Class<?> clazz0 = value0.getClass();
                Object value1 = values[1];
                Class<?> clazz1 = value1.getClass();
                Object value2 = values[2];
                Class<?> clazz2 = value2.getClass();
                if (type.getVariant() == Variant.DEFAULT) {
                    GL20.glUniform3f((int)loc, (float)ShaderProgram.getFloat(clazz0, value0), (float)ShaderProgram.getFloat(clazz1, value1), (float)ShaderProgram.getFloat(clazz2, value2));
                } else if (type.getVariant() == Variant.I) {
                    GL20.glUniform3i((int)loc, (int)ShaderProgram.getInt(clazz0, value0), (int)ShaderProgram.getInt(clazz1, value1), (int)ShaderProgram.getInt(clazz2, value2));
                } else if (type.getVariant() == Variant.U) {
                    GL30.glUniform3ui((int)loc, (int)ShaderProgram.getUint(clazz0, value0), (int)ShaderProgram.getUint(clazz1, value1), (int)ShaderProgram.getUint(clazz2, value2));
                }
            } else if (type.getSymbol().equals("vec4")) {
                value0 = values[0];
                Class<?> clazz0 = value0.getClass();
                Object value1 = values[1];
                Class<?> clazz1 = value1.getClass();
                Object value2 = values[2];
                Class<?> clazz2 = value2.getClass();
                Object value3 = values[3];
                Class<?> clazz3 = value3.getClass();
                if (type.getVariant() == Variant.DEFAULT) {
                    GL20.glUniform4f((int)loc, (float)ShaderProgram.getFloat(clazz0, value0), (float)ShaderProgram.getFloat(clazz1, value1), (float)ShaderProgram.getFloat(clazz2, value2), (float)ShaderProgram.getFloat(clazz3, value3));
                } else if (type.getVariant() == Variant.I) {
                    GL20.glUniform4i((int)loc, (int)ShaderProgram.getInt(clazz0, value0), (int)ShaderProgram.getInt(clazz1, value1), (int)ShaderProgram.getInt(clazz2, value2), (int)ShaderProgram.getInt(clazz3, value3));
                } else if (type.getVariant() == Variant.U) {
                    GL30.glUniform4ui((int)loc, (int)ShaderProgram.getUint(clazz0, value0), (int)ShaderProgram.getUint(clazz1, value1), (int)ShaderProgram.getUint(clazz2, value2), (int)ShaderProgram.getUint(clazz3, value3));
                }
            }
        } else if (type.getKind() == UniformTypeKind.MATRIX) {
            value = values[0];
            if (value instanceof FloatBuffer) {
                FloatBuffer buffer = (FloatBuffer)value;
                if (type.getSymbol().equals("mat2")) {
                    GL20.glUniformMatrix2((int)loc, (boolean)false, (FloatBuffer)buffer);
                } else if (type.getSymbol().equals("mat3")) {
                    GL20.glUniformMatrix3((int)loc, (boolean)false, (FloatBuffer)buffer);
                } else if (type.getSymbol().equals("mat4")) {
                    GL20.glUniformMatrix4((int)loc, (boolean)false, (FloatBuffer)buffer);
                }
            }
        } else if (type.getKind() == UniformTypeKind.SAMPLER) {
            value = values[0];
            Class<?> clazz = value.getClass();
            GL20.glUniform1i((int)loc, (int)ShaderProgram.getInt(clazz, value));
        }
    }

    public void use() {
        this.prevProgramID = GL11.glGetInteger((int)35725);
        GL20.glUseProgram((int)this.programID);
    }

    public void unuse() {
        GL20.glUseProgram((int)this.prevProgramID);
    }

    public void dispose() {
        for (int shaderID : this.shaderIDs) {
            GL20.glDetachShader((int)this.programID, (int)shaderID);
            GL20.glDeleteShader((int)shaderID);
        }
        GL20.glDeleteProgram((int)this.programID);
    }

    @Override
    public int compareTo(@NotNull ShaderProgram o) {
        return Integer.compare(this.programID, o.programID);
    }
}

