/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.render;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL33;

public class Mesh {
    private float[] vertices;
    private int[] indices;
    private float[] instanceData;
    private ByteBuffer vertexBuffer;
    private ByteBuffer indexBuffer;
    private ByteBuffer instanceDataBuffer;
    private boolean setup;
    private int eboIndexOffset;
    private final int verticesLength;
    private final int indicesLength;
    private int instanceDataLength;
    private int vao;
    private int vbo;
    private int ebo;
    private boolean instancing;
    private int instancingVbo;
    private int instanceDataUnitSize;
    private int instancePrimCount;
    private IManageInstancingLayout customInstancingLayout = null;

    public void setCustomInstancingLayout(IManageInstancingLayout customInstancingLayout) {
        if (this.setup) {
            throw new IllegalStateException("Only call this method before setup");
        }
        this.customInstancingLayout = customInstancingLayout;
    }

    public void enableInstancing() {
        if (this.setup) {
            throw new IllegalStateException("Only call this method before setup");
        }
        this.instancing = true;
    }

    public void setInstanceData(float[] instanceData) {
        if (this.setup) {
            throw new IllegalStateException("Only call this method before setup");
        }
        this.instanceData = instanceData;
        this.instanceDataLength = instanceData.length;
    }

    public void setInstanceDataUnitSize(int size) {
        if (this.setup) {
            throw new IllegalStateException("Only call this method before setup");
        }
        this.instanceDataUnitSize = size;
    }

    public void setInstancePrimCount(int count) {
        this.instancePrimCount = count;
    }

    public int getInstancingVbo() {
        return this.instancingVbo;
    }

    public int getVerticesLength() {
        return this.verticesLength;
    }

    public int getIndicesLength() {
        return this.indicesLength;
    }

    public int getVao() {
        return this.vao;
    }

    public int getVbo() {
        return this.vbo;
    }

    public int getEbo() {
        return this.ebo;
    }

    public boolean getSetup() {
        return this.setup;
    }

    protected int getEboIndexOffset() {
        return this.eboIndexOffset;
    }

    protected void setEboIndexOffset(int offset) {
        this.eboIndexOffset = offset;
    }

    public Mesh(float[] vertices, int[] indices) {
        this.vertices = vertices;
        this.indices = indices;
        this.verticesLength = vertices.length;
        this.indicesLength = indices.length;
        this.setup = false;
        this.eboIndexOffset = 0;
    }

    public void setup() {
        if (this.setup) {
            return;
        }
        int prevVao = GL11.glGetInteger((int)34229);
        int prevVbo = GL11.glGetInteger((int)34964);
        int prevEbo = GL11.glGetInteger((int)34965);
        this.vao = GL30.glGenVertexArrays();
        GL30.glBindVertexArray((int)this.vao);
        this.vertexBuffer = ByteBuffer.allocateDirect(this.vertices.length * 4).order(ByteOrder.nativeOrder());
        this.vertexBuffer.asFloatBuffer().put(this.vertices).flip();
        this.indexBuffer = ByteBuffer.allocateDirect(this.indices.length * 4).order(ByteOrder.nativeOrder());
        this.indexBuffer.asIntBuffer().put(this.indices).flip();
        this.vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)this.vbo);
        GL15.glBufferData((int)34962, (ByteBuffer)this.vertexBuffer, (int)35044);
        this.ebo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        GL15.glBufferData((int)34963, (ByteBuffer)this.indexBuffer, (int)35044);
        GL20.glVertexAttribPointer((int)0, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
        GL20.glEnableVertexAttribArray((int)0);
        GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)32, (long)12L);
        GL20.glEnableVertexAttribArray((int)1);
        GL20.glVertexAttribPointer((int)2, (int)3, (int)5126, (boolean)false, (int)32, (long)20L);
        GL20.glEnableVertexAttribArray((int)2);
        if (this.instancing) {
            this.instanceDataBuffer = ByteBuffer.allocateDirect(this.instanceData.length * 4).order(ByteOrder.nativeOrder());
            this.instanceDataBuffer.asFloatBuffer().put(this.instanceData).flip();
            this.instancingVbo = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)this.instancingVbo);
            GL15.glBufferData((int)34962, (ByteBuffer)this.instanceDataBuffer, (int)35048);
            if (this.customInstancingLayout == null) {
                GL20.glVertexAttribPointer((int)3, (int)this.instanceDataUnitSize, (int)5126, (boolean)false, (int)(this.instanceDataUnitSize * 4), (long)0L);
                GL20.glEnableVertexAttribArray((int)3);
                GL33.glVertexAttribDivisor((int)3, (int)1);
            } else {
                this.customInstancingLayout.manage();
            }
            this.instanceData = null;
        }
        GL30.glBindVertexArray((int)prevVao);
        GL15.glBindBuffer((int)34962, (int)prevVbo);
        GL15.glBindBuffer((int)34963, (int)prevEbo);
        this.vertices = null;
        this.indices = null;
        this.setup = true;
    }

    public void updateInstanceDataByBufferSubData(int offset, float[] newInstanceData) {
        if (!this.instancing) {
            throw new IllegalArgumentException("This mesh doesn't support instancing.");
        }
        if (!this.setup) {
            throw new IllegalArgumentException("This mesh isn't set up so you can't update.");
        }
        if (offset + newInstanceData.length * 4 > this.instanceDataLength * 4) {
            throw new IllegalArgumentException("Allocated instancing VBO size must be greater than or equal to newInstanceData size after offset.");
        }
        this.instanceDataBuffer.position(0);
        this.instanceDataBuffer.clear();
        FloatBuffer floatView = this.instanceDataBuffer.asFloatBuffer();
        floatView.clear();
        floatView.put(newInstanceData);
        floatView.flip();
        int prevVbo = GL11.glGetInteger((int)34964);
        GL15.glBindBuffer((int)34962, (int)this.instancingVbo);
        GL15.glBufferSubData((int)34962, (long)offset, (ByteBuffer)this.instanceDataBuffer);
        GL15.glBindBuffer((int)34962, (int)prevVbo);
    }

    public void render() {
        if (!this.setup) {
            return;
        }
        int prevVao = GL11.glGetInteger((int)34229);
        int prevEbo = GL11.glGetInteger((int)34965);
        GL30.glBindVertexArray((int)this.vao);
        GL15.glBindBuffer((int)34963, (int)this.ebo);
        if (this.instancing) {
            GL31.glDrawElementsInstanced((int)4, (int)this.indicesLength, (int)5125, (long)((long)this.eboIndexOffset * 4L), (int)this.instancePrimCount);
        } else {
            GL11.glDrawElements((int)4, (int)this.indicesLength, (int)5125, (long)((long)this.eboIndexOffset * 4L));
        }
        GL15.glBindBuffer((int)34963, (int)prevEbo);
        GL30.glBindVertexArray((int)prevVao);
    }

    public void dispose() {
        GL30.glDeleteVertexArrays((int)this.vao);
        GL15.glDeleteBuffers((int)this.vbo);
        GL15.glDeleteBuffers((int)this.ebo);
        if (this.instancing) {
            GL15.glDeleteBuffers((int)this.instancingVbo);
        }
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.instanceDataBuffer = null;
        this.setup = false;
    }

    public static interface IManageInstancingLayout {
        public void manage();
    }
}

