/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.proxy;

import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import io.enderdev.endermodpacktweaks.config.CfgMinecraft;
import io.enderdev.endermodpacktweaks.config.CfgModpack;
import io.enderdev.endermodpacktweaks.config.CfgTweaks;
import io.enderdev.endermodpacktweaks.events.PyrotechEvents;
import io.enderdev.endermodpacktweaks.events.ReskillableEvents;
import io.enderdev.endermodpacktweaks.events.SimpleDifficultyEvents;
import io.enderdev.endermodpacktweaks.features.compatscreen.CompatModsHandler;
import io.enderdev.endermodpacktweaks.features.crashinfo.InfoBuilder;
import io.enderdev.endermodpacktweaks.features.dodgethirst.DodgeHandler;
import io.enderdev.endermodpacktweaks.features.instantbonemeal.BoneMealHandler;
import io.enderdev.endermodpacktweaks.features.materialtweaker.MaterialTweaker;
import io.enderdev.endermodpacktweaks.features.netherportal.PortalHandler;
import io.enderdev.endermodpacktweaks.features.playerpotions.ElenaiDodgeHandler;
import io.enderdev.endermodpacktweaks.features.playerpotions.SimpleDifficultyHandler;
import io.enderdev.endermodpacktweaks.features.playerpotions.VanillaHandler;
import io.enderdev.endermodpacktweaks.features.servermsg.ServerHandler;
import io.enderdev.endermodpacktweaks.features.timesync.TimeEventHandler;
import io.enderdev.endermodpacktweaks.features.worldoptions.GameruleHandler;
import io.enderdev.endermodpacktweaks.features.worldoptions.WorldOptionsHandler;
import io.enderdev.endermodpacktweaks.proxy.IProxy;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

public class CommonProxy
implements IProxy {
    private static final InfoBuilder INFO_BUILDER = new InfoBuilder("Modpack Information");
    private VanillaHandler vanillaHandler;
    private SimpleDifficultyHandler simpleDifficultyHandler;
    private ElenaiDodgeHandler elenaiDodgeHandler;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        EnderModpackTweaks.network = NetworkRegistry.INSTANCE.newSimpleChannel("endermodpacktweaks");
        if (CfgFeatures.PLAYER_EFFECTS.enable) {
            this.vanillaHandler = new VanillaHandler();
            MinecraftForge.EVENT_BUS.register((Object)this.vanillaHandler);
            if (Loader.isModLoaded((String)"simpledifficulty")) {
                this.simpleDifficultyHandler = new SimpleDifficultyHandler();
                MinecraftForge.EVENT_BUS.register((Object)this.simpleDifficultyHandler);
            }
            if (Loader.isModLoaded((String)"elenaidodge2")) {
                this.elenaiDodgeHandler = new ElenaiDodgeHandler();
                MinecraftForge.EVENT_BUS.register((Object)this.elenaiDodgeHandler);
            }
        }
        if (CfgMinecraft.NETHER_PORTAL.enable) {
            MinecraftForge.EVENT_BUS.register((Object)new PortalHandler());
        }
        if (CfgFeatures.INSTANT_BONE_MEAL.enable) {
            MinecraftForge.EVENT_BUS.register((Object)new BoneMealHandler());
        }
        if (CfgFeatures.SYNC_TIME.enable) {
            MinecraftForge.EVENT_BUS.register((Object)new TimeEventHandler());
        }
        if (CfgMinecraft.WORLD.enable) {
            MinecraftForge.EVENT_BUS.register((Object)new WorldOptionsHandler());
        }
        if (CfgMinecraft.DEFAULT_GAMERULE.enable) {
            MinecraftForge.EVENT_BUS.register((Object)new GameruleHandler());
        }
        if (CfgTweaks.ELENAI_DODGE.enable && Loader.isModLoaded((String)"elenaidodge2") && Loader.isModLoaded((String)"simpledifficulty") && CfgTweaks.ELENAI_DODGE.enableSimpleDifficulty) {
            MinecraftForge.EVENT_BUS.register((Object)new DodgeHandler());
        }
        if (CfgTweaks.RESKILLABLE.enable && Loader.isModLoaded((String)"reskillable")) {
            MinecraftForge.EVENT_BUS.register((Object)new ReskillableEvents());
        }
        if (CfgTweaks.PYROTECH.enable && Loader.isModLoaded((String)"pyrotech")) {
            MinecraftForge.EVENT_BUS.register((Object)new PyrotechEvents());
        }
        if (CfgTweaks.SIMPLE_DIFFICULTY.enable && Loader.isModLoaded((String)"simpledifficulty")) {
            MinecraftForge.EVENT_BUS.register((Object)new SimpleDifficultyEvents());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (CfgFeatures.BOSS_PROOF_BLOCKS.enable) {
            Arrays.stream(CfgFeatures.BOSS_PROOF_BLOCKS.defaultWither).forEach(entry -> {
                Block block = Block.func_149684_b((String)entry);
                if (block != null && !new ItemStack(block).func_190926_b()) {
                    OreDictionary.registerOre((String)"proofWither", (Block)block);
                } else {
                    EnderModpackTweaks.LOGGER.error("Unable to parse witherproof block: {}", entry);
                }
            });
            Arrays.stream(CfgFeatures.BOSS_PROOF_BLOCKS.defaultEnderDragon).forEach(entry -> {
                Block block = Block.func_149684_b((String)entry);
                if (block != null && !new ItemStack(block).func_190926_b()) {
                    OreDictionary.registerOre((String)"proofEnderDragon", (Block)block);
                } else {
                    EnderModpackTweaks.LOGGER.error("Unable to parse enderdragonproof block: {}", entry);
                }
            });
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (CfgFeatures.MATERIAL_TWEAKER.enable) {
            MaterialTweaker.INSTANCE.load();
        }
        if (CfgFeatures.PLAYER_EFFECTS.enable) {
            this.vanillaHandler.healthPotionHandler.init();
            this.vanillaHandler.hungerPotionHandler.init();
            if (Loader.isModLoaded((String)"simpledifficulty")) {
                this.simpleDifficultyHandler.temperaturePotionHandler.init();
                this.simpleDifficultyHandler.thirstPotionHandler.init();
            }
            if (Loader.isModLoaded((String)"elenaidodge2")) {
                this.elenaiDodgeHandler.staminaPotionHandler.init();
            }
        }
    }

    @Override
    public void construct(FMLConstructionEvent event) throws Exception {
        if (CfgModpack.CRASH_INFO.enable) {
            FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)INFO_BUILDER);
        }
    }

    @Override
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        if (CompatModsHandler.hasObsoleteModsMessage()) {
            CompatModsHandler.obsoleteModsMessage().stream().filter(s -> !Objects.equals(s, "")).forEach(arg_0 -> ((Logger)EnderModpackTweaks.LOGGER).warn(arg_0));
        }
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
        if (CfgModpack.SERVER_MESSAGE.enable) {
            ServerHandler.serverStarted();
        }
    }
}

