/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.worldgen;

import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import org.jetbrains.annotations.NotNull;

public abstract class WorldGen {
    PlacementSettings placementsettings = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(true).func_186218_a((ChunkPos)null).func_186225_a((Block)null).func_186226_b(false);

    public abstract boolean generate(@NotNull World var1, @NotNull Random var2, @NotNull BlockPos var3);

    boolean generateStructure(@NotNull World worldIn, @NotNull BlockPos position, @NotNull ResourceLocation structure, boolean centerY, int offsetY) {
        Template template = this.getTemplate(worldIn, structure);
        if (template == null) {
            EnderModpackTweaks.LOGGER.error("Structure {} not found!", (Object)structure);
            return false;
        }
        BlockPos templateCenter = this.getCenter(template);
        BlockPos location = position.func_177982_a(-templateCenter.func_177958_n(), (centerY ? -templateCenter.func_177956_o() : 0) + offsetY, -templateCenter.func_177952_p());
        template.func_186260_a(worldIn, location, this.placementsettings);
        return true;
    }

    boolean generateStructure(@NotNull World worldIn, @NotNull BlockPos position, @NotNull ResourceLocation structure) {
        return this.generateStructure(worldIn, position, structure, true, 0);
    }

    private BlockPos getCenter(@NotNull Template template) {
        int centerY = Math.floorDiv(template.func_186259_a().func_177956_o(), 2);
        int centerX = Math.floorDiv(template.func_186259_a().func_177958_n(), 2);
        int centerZ = Math.floorDiv(template.func_186259_a().func_177952_p(), 2);
        return new BlockPos(centerX, centerY, centerZ);
    }

    private Template getTemplate(@NotNull World worldIn, @NotNull ResourceLocation structure) {
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        WorldServer worldserver = (WorldServer)worldIn;
        TemplateManager templatemanager = worldserver.func_184163_y();
        return templatemanager.func_189942_b(minecraftserver, structure);
    }
}

