/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.playerpotions;

import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import io.enderdev.endermodpacktweaks.features.playerpotions.PotionData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;

public class PotionHandler {
    private final List<PotionData> listPotions = new ArrayList<PotionData>();
    private final String[] potionData;
    private final int lowerBound;
    private final int upperBound;

    public PotionHandler(String[] potionData, int lowerBound, int upperBound) {
        this.potionData = potionData;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public void init() {
        Arrays.stream(this.potionData).map(line -> line.split(";")).forEach(data -> {
            if (((String[])data).length == 4 && Integer.parseInt(data[0]) <= Integer.parseInt(data[1]) && Integer.parseInt(data[0]) <= this.upperBound && Integer.parseInt(data[0]) >= this.lowerBound && Integer.parseInt(data[1]) <= this.upperBound && Integer.parseInt(data[1]) >= this.lowerBound) {
                try {
                    this.listPotions.add(new PotionData(data[2], Integer.parseInt(data[0]), Integer.parseInt(data[1]), Integer.parseInt(data[3])));
                }
                catch (NumberFormatException e) {
                    EnderModpackTweaks.LOGGER.error((Object)e);
                    EnderModpackTweaks.LOGGER.error("Error parsing potion data: {}", (Object)Arrays.toString(data));
                }
            }
        });
        this.listPotions.removeIf(Objects::isNull);
    }

    public void apply(EntityPlayer player, int value) {
        if (this.listPotions.isEmpty() || player.field_70173_aa % CfgFeatures.PLAYER_EFFECTS.effectRefreshRate != 0) {
            return;
        }
        this.listPotions.forEach(potion -> this.updatePotionStatus(player, (PotionData)potion, value));
    }

    private void updatePotionStatus(EntityPlayer player, PotionData potionData, int value) {
        boolean valueInBound;
        if (potionData == null || potionData.getPotion() == null) {
            return;
        }
        PotionEffect currentEffect = player.func_70660_b(potionData.getPotion());
        boolean bl = valueInBound = value >= potionData.getLowerBound() && value <= potionData.getUpperBound();
        if (!valueInBound && currentEffect != null && currentEffect.func_76459_b() <= CfgFeatures.PLAYER_EFFECTS.effectDuration) {
            player.func_184589_d(potionData.getPotion());
        }
        if (valueInBound && (currentEffect == null || currentEffect.func_76459_b() <= CfgFeatures.PLAYER_EFFECTS.effectDuration)) {
            player.func_70690_d(new PotionEffect(potionData.getPotion(), CfgFeatures.PLAYER_EFFECTS.effectDuration, potionData.getAmplifier(), true, false));
        }
    }
}

