/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.packupdater;

import com.google.gson.Gson;
import io.enderdev.endermodpacktweaks.config.CfgModpack;
import io.enderdev.endermodpacktweaks.utils.EmtWeb;
import java.io.IOException;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class Updater {
    private boolean needsUpdate = false;
    private String newVersion = "UNKNOWN";
    public static Updater INSTANCE = new Updater();

    private Updater() {
    }

    public void checkForUpdate() throws IOException, NumberFormatException {
        String json = EmtWeb.readUrl(CfgModpack.PACK_UPDATER.jsonUrl);
        Gson gson = new Gson();
        PackVersion versionFromJSON = (PackVersion)gson.fromJson(json, PackVersion.class);
        DefaultArtifactVersion newVersion = new DefaultArtifactVersion(versionFromJSON.version);
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(CfgModpack.MODPACK.modpackVersion);
        if (!newVersion.equals((Object)currentVersion)) {
            this.needsUpdate = true;
        }
        this.newVersion = versionFromJSON.version;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public boolean doesNeedUpdate() {
        return this.needsUpdate;
    }

    private static class PackVersion {
        String version;

        private PackVersion() {
        }
    }
}

