/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.materialtweaker;

import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MaterialTweaker {
    private static final int ARMOR_PROTECTION_INDEX = 5;
    private static final int ARMOR_TOUGHNESS_INDEX = 6;
    private static final int TOOL_EFFICIENCY_INDEX = 1;
    private static final int TOOL_DAMAGE_INDEX = 2;
    private static final int TOOL_ATTACK_SPEED_INDEX = 3;
    private static final int HOE_ATTACK_SPEED_INDEX = 0;
    private static final int SWORD_DAMAGE_INDEX = 0;
    private static final int MATERIAL_HARVEST_LEVEL_INDEX = 5;
    private static final int MATERIAL_ENCHANTABILITY_INDEX = 9;
    private static final int ARMOR_MATERIAL_ENCHANTABILITY_INDEX = 8;
    public static final MaterialTweaker INSTANCE = new MaterialTweaker();

    private MaterialTweaker() {
    }

    public void load() {
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.stacksize).forEach(this::setStacksize);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.durability).forEach(this::setDurability);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.harvestLevel).forEach(this::setHarvestLevel);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.enchantability).forEach(this::setEnchantability);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.efficiency).forEach(this::setEfficiency);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.attackDamage).forEach(this::setAttackDamage);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.attackSpeed).forEach(this::setAttackSpeed);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.armorProtection).forEach(this::setArmorProtection);
        Arrays.stream(CfgFeatures.MATERIAL_TWEAKER.armorToughness).forEach(this::setArmorToughness);
    }

    private void setStacksize(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing stacksize: {}", (Object)input);
            return;
        }
        entry.item().func_77625_d(entry.i());
    }

    private void setDurability(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing durability: {}", (Object)input);
            return;
        }
        entry.item().func_77656_e(entry.i());
    }

    private void setHarvestLevel(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing harvest level: {}", (Object)input);
            return;
        }
        Item.ToolMaterial toolMaterial = entry.getObjectFromClass(ItemTool.class, Item.ToolMaterial.class);
        if (toolMaterial == null) {
            toolMaterial = entry.getObjectFromClass(ItemSword.class, Item.ToolMaterial.class);
        }
        if (toolMaterial != null) {
            ObfuscationReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)toolMaterial, (Object)entry.i(), (int)5);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting harvest level for {}", (Object)entry.item().getRegistryName());
        }
    }

    private void setEnchantability(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing enchantability: {}", (Object)input);
            return;
        }
        Item.ToolMaterial toolMaterial = entry.getObjectFromClass(ItemTool.class, Item.ToolMaterial.class);
        ItemArmor.ArmorMaterial armorMaterial = entry.getObjectFromClass(ItemArmor.class, ItemArmor.ArmorMaterial.class);
        if (toolMaterial == null) {
            toolMaterial = entry.getObjectFromClass(ItemSword.class, Item.ToolMaterial.class);
        }
        if (armorMaterial != null) {
            ObfuscationReflectionHelper.setPrivateValue(ItemArmor.ArmorMaterial.class, (Object)armorMaterial, (Object)entry.i(), (int)8);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting enchantability for {}", (Object)entry.item().getRegistryName());
        }
        if (toolMaterial != null) {
            ObfuscationReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)toolMaterial, (Object)entry.i(), (int)9);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting enchantability for {}", (Object)entry.item().getRegistryName());
        }
    }

    private void setEfficiency(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing efficiency: {}", (Object)input);
            return;
        }
        if (entry.item() instanceof ItemTool) {
            ObfuscationReflectionHelper.setPrivateValue(ItemTool.class, (Object)((ItemTool)entry.item()), (Object)Float.valueOf(entry.f()), (int)1);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting efficiency for {}", (Object)entry.item().getRegistryName());
        }
    }

    private void setAttackDamage(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing attack damage: {}", (Object)input);
            return;
        }
        if (entry.item() instanceof ItemSword) {
            ObfuscationReflectionHelper.setPrivateValue(ItemSword.class, (Object)((ItemSword)entry.item()), (Object)Float.valueOf(entry.f() - 1.0f), (int)0);
        } else if (entry.item() instanceof ItemTool) {
            ObfuscationReflectionHelper.setPrivateValue(ItemTool.class, (Object)((ItemTool)entry.item()), (Object)Float.valueOf(entry.f() - 1.0f), (int)2);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting attack damage for {}", (Object)entry.item().getRegistryName());
        }
    }

    private void setAttackSpeed(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing attack speed: {}", (Object)input);
            return;
        }
        if (entry.item() instanceof ItemSword) {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting attack speed for swords");
        } else if (entry.item() instanceof ItemTool) {
            ObfuscationReflectionHelper.setPrivateValue(ItemTool.class, (Object)((ItemTool)entry.item()), (Object)Float.valueOf(entry.f() - 4.0f), (int)3);
        } else if (entry.item() instanceof ItemHoe) {
            ObfuscationReflectionHelper.setPrivateValue(ItemHoe.class, (Object)((ItemHoe)entry.item()), (Object)Float.valueOf(entry.f()), (int)0);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting attack speed for {}", (Object)entry.item().getRegistryName());
        }
    }

    private void setArmorProtection(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing armor protection: {}", (Object)input);
            return;
        }
        if (entry.item() instanceof ItemArmor) {
            ObfuscationReflectionHelper.setPrivateValue(ItemArmor.class, (Object)((ItemArmor)entry.item()), (Object)entry.i(), (int)5);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting armor protection for {}", (Object)entry.item().getRegistryName());
        }
    }

    private void setArmorToughness(String input) {
        Entry entry = new Entry(input);
        if (entry.invalid()) {
            EnderModpackTweaks.LOGGER.error("Invalid input, when editing armor toughness: {}", (Object)input);
            return;
        }
        if (entry.item() instanceof ItemArmor) {
            ObfuscationReflectionHelper.setPrivateValue(ItemArmor.class, (Object)((ItemArmor)entry.item()), (Object)Float.valueOf(entry.f()), (int)6);
        } else {
            EnderModpackTweaks.LOGGER.info("Currently not supported: Setting armor toughness for {}", (Object)entry.item().getRegistryName());
        }
    }

    private static class Entry {
        private final ItemStack input;
        private final float value;

        public Entry(String input) {
            this.input = this.getItemStack(input);
            this.value = this.getValue(input);
        }

        public ItemStack stack() {
            return this.input;
        }

        public Item item() {
            return this.input.func_77973_b();
        }

        public int i() {
            return (int)this.value;
        }

        public float f() {
            return this.value;
        }

        public boolean invalid() {
            return this.input.func_190926_b() || this.value <= 0.0f;
        }

        public <T> T getObjectFromClass(Class fromClazz, Class<T> clazz) {
            if (!fromClazz.isInstance(this.item())) {
                return null;
            }
            try {
                for (Field field : fromClazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object object = field.get(this.item());
                    if (!clazz.isInstance(object)) continue;
                    return (T)object;
                }
            }
            catch (Exception e) {
                EnderModpackTweaks.LOGGER.error("Error getting object from class: {}", (Object)e.toString());
            }
            return null;
        }

        private ItemStack getItemStack(String input) {
            Item item;
            String[] splits = input.trim().split(";");
            if (splits.length != 2) {
                return ItemStack.field_190927_a;
            }
            int meta = 0;
            String[] itemSplits = splits[0].split(":");
            if (itemSplits.length == 3) {
                meta = Integer.parseInt(itemSplits[2]);
            }
            if ((item = Item.func_111206_d((String)new ResourceLocation(itemSplits[0], itemSplits[1]).toString())) == null) {
                return ItemStack.field_190927_a;
            }
            return new ItemStack(item, 1, meta);
        }

        private float getValue(String input) {
            try {
                return Float.parseFloat(input.split(";")[1]);
            }
            catch (NumberFormatException e) {
                return -1.0f;
            }
        }
    }
}

