/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.healthbar.render;

import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.render.Mesh;
import io.enderdev.endermodpacktweaks.render.renderer.MeshRenderer;
import io.enderdev.endermodpacktweaks.render.shader.Shader;
import io.enderdev.endermodpacktweaks.render.shader.ShaderLoadingUtils;
import io.enderdev.endermodpacktweaks.render.shader.ShaderProgram;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL33;
import org.lwjgl.util.vector.Matrix4f;

public final class RectInstancingRenderer
extends MeshRenderer {
    public static final float SIDE_LENGTH = 1.0f;
    public static final int INSTANCE_DATA_UNIT_SIZE = 8;
    private static ShaderProgram sharedShaderProgram = null;
    private final int maxInstance;
    private boolean init = false;

    public int getMaxInstance() {
        return this.maxInstance;
    }

    public int getInstanceDataLength() {
        return this.maxInstance * 8;
    }

    protected RectInstancingRenderer(int maxInstance) {
        super(null, null);
        this.maxInstance = maxInstance;
    }

    public RectInstancingRenderer init() {
        if (this.init) {
            return this;
        }
        if (sharedShaderProgram == null) {
            Shader frag = ShaderLoadingUtils.load("endermodpacktweaks:shaders/mesh2d_frag.glsl", Shader.ShaderType.FRAGMENT);
            Shader vertex = ShaderLoadingUtils.load("endermodpacktweaks:shaders/mesh2d_instancing_vertex.glsl", Shader.ShaderType.VERTEX);
            ShaderProgram program = new ShaderProgram(frag, vertex);
            program.setup();
            Matrix4f matrix4f = new Matrix4f();
            matrix4f.setIdentity();
            FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
            matrix4f.store(buffer);
            buffer.flip();
            program.use();
            program.setUniform("transformation", buffer);
            program.setUniform("targetWorldPos", 0, 0, 0);
            program.unuse();
            EnderModpackTweaks.LOGGER.info("Loading shaders for rect instancing.");
            EnderModpackTweaks.LOGGER.info(program.getSetupDebugReport());
            sharedShaderProgram = program;
        }
        this.shaderProgram = sharedShaderProgram;
        float x = -0.5f;
        float y = -0.5f;
        float width = 1.0f;
        float height = 1.0f;
        float[] vertices = new float[]{x, y, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, x + width, y, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, x + width, y + height, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, x, y + height, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        int[] indices = new int[]{0, 2, 1, 0, 3, 2};
        this.mesh = new Mesh(vertices, indices);
        this.mesh.enableInstancing();
        this.mesh.setInstanceData(new float[this.getInstanceDataLength()]);
        this.mesh.setInstanceDataUnitSize(8);
        this.mesh.setInstancePrimCount(0);
        this.mesh.setCustomInstancingLayout(new Mesh.IManageInstancingLayout(){

            @Override
            public void manage() {
                GL20.glVertexAttribPointer((int)3, (int)3, (int)5126, (boolean)false, (int)32, (long)0L);
                GL20.glEnableVertexAttribArray((int)3);
                GL33.glVertexAttribDivisor((int)3, (int)1);
                GL20.glVertexAttribPointer((int)4, (int)2, (int)5126, (boolean)false, (int)32, (long)12L);
                GL20.glEnableVertexAttribArray((int)4);
                GL33.glVertexAttribDivisor((int)4, (int)1);
                GL20.glVertexAttribPointer((int)5, (int)2, (int)5126, (boolean)false, (int)32, (long)20L);
                GL20.glEnableVertexAttribArray((int)5);
                GL33.glVertexAttribDivisor((int)5, (int)1);
                GL20.glVertexAttribPointer((int)6, (int)1, (int)5126, (boolean)false, (int)32, (long)28L);
                GL20.glEnableVertexAttribArray((int)6);
                GL33.glVertexAttribDivisor((int)6, (int)1);
            }
        });
        this.mesh.setup();
        this.init = true;
        return this;
    }
}

