/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.healthbar.render;

import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import io.enderdev.endermodpacktweaks.features.healthbar.HealthBarData;
import io.enderdev.endermodpacktweaks.features.healthbar.render.HealthBarDirectRenderHelper;
import io.enderdev.endermodpacktweaks.features.healthbar.render.RectInstancingRenderer;
import io.enderdev.endermodpacktweaks.render.shader.ShaderProgram;
import io.enderdev.endermodpacktweaks.utils.EmtColor;
import io.enderdev.endermodpacktweaks.utils.EmtRender;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public final class HealthBarInstancingHelper {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static final FloatBuffer FLOAT_BUFFER_16 = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private static RectInstancingRenderer rectBackgroundRenderer = null;
    private static RectInstancingRenderer rectGraySpaceRenderer = null;
    private static RectInstancingRenderer rectHealthBarRenderer = null;
    private static final ItemStack IRON_CHESTPLATE = new ItemStack((Item)Items.field_151030_Z);
    private static final ItemStack DIAMOND_CHESTPLATE = new ItemStack((Item)Items.field_151163_ad);
    private static final ItemStack SPIDER_EYE = new ItemStack(Items.field_151070_bp);
    private static final ItemStack ROTTEN_FLESH = new ItemStack(Items.field_151078_bh);
    private static final ItemStack TOTEM_OF_UNDYING = new ItemStack(Items.field_190929_cY);
    private static final ItemStack SKULL = new ItemStack(Items.field_151144_bL, 1, 4);
    private static final ItemStack BOSS_SKULL = new ItemStack(Items.field_151144_bL);

    public static void renderRectHealthBars(Map<EntityLivingBase, HealthBarData> entities, float partialTicks, float deltaTime, Vector3f worldOffset, Vector2f cameraRot) {
        int i;
        if (rectBackgroundRenderer == null) {
            rectBackgroundRenderer = new RectInstancingRenderer(CfgFeatures.MOB_HEALTH_BAR.maxInstancingCount).init();
        }
        if (rectGraySpaceRenderer == null) {
            rectGraySpaceRenderer = new RectInstancingRenderer(CfgFeatures.MOB_HEALTH_BAR.maxInstancingCount).init();
        }
        if (rectHealthBarRenderer == null) {
            rectHealthBarRenderer = new RectInstancingRenderer(CfgFeatures.MOB_HEALTH_BAR.maxInstancingCount).init();
        }
        int entityListLength = Math.min(rectHealthBarRenderer.getMaxInstance(), Math.min(rectGraySpaceRenderer.getMaxInstance(), Math.min(rectBackgroundRenderer.getMaxInstance(), entities.size())));
        float[] backgroundInstanceData = new float[entityListLength * 8];
        float[] graySpaceInstanceData = new float[entityListLength * 8];
        float[] healthBarInstanceData = new float[entityListLength * 8];
        float padding = CfgFeatures.MOB_HEALTH_BAR.backgroundPadding;
        int bgHeight = CfgFeatures.MOB_HEALTH_BAR.backgroundHeight;
        int barHeight = CfgFeatures.MOB_HEALTH_BAR.barHeight;
        Iterator<Map.Entry<EntityLivingBase, HealthBarData>> iterator = entities.entrySet().iterator();
        for (i = 0; iterator.hasNext() && i < entityListLength; ++i) {
            boolean useHue;
            Map.Entry<EntityLivingBase, HealthBarData> entry = iterator.next();
            EntityLivingBase entity = entry.getKey();
            HealthBarData healthBarData = entry.getValue();
            boolean boss = !entity.func_184222_aU();
            float size = boss ? (float)CfgFeatures.MOB_HEALTH_BAR.plateSizeBoss : (float)CfgFeatures.MOB_HEALTH_BAR.plateSize;
            float s = 0.5f;
            float namel = (float)HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78256_a(healthBarData.name) * s;
            if (namel + 20.0f > size * 2.0f) {
                size = namel / 2.0f + 10.0f;
            }
            float x = (float)(entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks);
            float y = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
            float z = (float)(entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks);
            y += entity.field_70131_O + (float)CfgFeatures.MOB_HEALTH_BAR.heightAbove;
            float ratio = 0.026666673f;
            backgroundInstanceData[i * 8] = x;
            backgroundInstanceData[i * 8 + 1] = y -= (float)healthBarData.ridingStackPos * ((float)(bgHeight + barHeight) + padding);
            backgroundInstanceData[i * 8 + 2] = z;
            backgroundInstanceData[i * 8 + 3] = (size * 2.0f + padding * 2.0f) * ratio;
            backgroundInstanceData[i * 8 + 4] = ((float)(bgHeight * 2) + padding) * ratio;
            backgroundInstanceData[i * 8 + 5] = 0.0f;
            backgroundInstanceData[i * 8 + 6] = -0.026666673f;
            graySpaceInstanceData[i * 8] = x;
            graySpaceInstanceData[i * 8 + 1] = y;
            graySpaceInstanceData[i * 8 + 2] = z;
            graySpaceInstanceData[i * 8 + 3] = size * 2.0f * ratio;
            graySpaceInstanceData[i * 8 + 4] = (float)barHeight * ratio;
            graySpaceInstanceData[i * 8 + 5] = 0.0f;
            graySpaceInstanceData[i * 8 + 6] = -0.053333346f;
            float maxHealth = entity.func_110138_aP();
            float health = CfgFeatures.MOB_HEALTH_BAR.enableSmoothAnimation && healthBarData.healthSmoothDamp != null ? Math.min(maxHealth, healthBarData.healthSmoothDamp.evaluate(deltaTime)) : Math.min(maxHealth, entity.func_110143_aJ());
            float healthSize = size * (health / maxHealth);
            healthBarInstanceData[i * 8] = x;
            healthBarInstanceData[i * 8 + 1] = y;
            healthBarInstanceData[i * 8 + 2] = z;
            healthBarInstanceData[i * 8 + 3] = healthSize * 2.0f * ratio;
            healthBarInstanceData[i * 8 + 4] = (float)barHeight * ratio;
            healthBarInstanceData[i * 8 + 5] = (size - healthSize) * ratio;
            healthBarInstanceData[i * 8 + 6] = -0.053333346f;
            int r = 0;
            int g = 255;
            int b = 0;
            if (entity instanceof IMob) {
                r = 255;
                g = 0;
            }
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            }
            boolean bl = useHue = !CfgFeatures.MOB_HEALTH_BAR.colorByType;
            if (useHue) {
                float hue = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
                Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                r = color.getRed();
                g = color.getGreen();
                b = color.getBlue();
            }
            Color healthColor = new Color(r, g, b, CfgFeatures.MOB_HEALTH_BAR.healthBarAlpha);
            healthBarInstanceData[i * 8 + 7] = Float.intBitsToFloat(healthColor.getRGB());
        }
        rectBackgroundRenderer.getMesh().setInstancePrimCount(entityListLength);
        rectBackgroundRenderer.getMesh().updateInstanceDataByBufferSubData(0, backgroundInstanceData);
        rectGraySpaceRenderer.getMesh().setInstancePrimCount(entityListLength);
        rectGraySpaceRenderer.getMesh().updateInstanceDataByBufferSubData(0, graySpaceInstanceData);
        rectHealthBarRenderer.getMesh().setInstancePrimCount(entityListLength);
        rectHealthBarRenderer.getMesh().updateInstanceDataByBufferSubData(0, healthBarInstanceData);
        ShaderProgram program = rectBackgroundRenderer.getShaderProgram();
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        matrix4f.rotate(-cameraRot.x, new Vector3f(0.0f, 1.0f, 0.0f));
        matrix4f.rotate(cameraRot.y, new Vector3f(1.0f, 0.0f, 0.0f));
        FLOAT_BUFFER_16.clear();
        matrix4f.store(FLOAT_BUFFER_16);
        FLOAT_BUFFER_16.flip();
        Color bgColor = EmtColor.parseColorFromHexString(CfgFeatures.MOB_HEALTH_BAR.backgroundColor);
        program.use();
        program.setUniform("modelView", EmtRender.getModelViewMatrix());
        program.setUniform("projection", EmtRender.getProjectionMatrix());
        program.setUniform("camPos", Float.valueOf(worldOffset.x), Float.valueOf(worldOffset.y), Float.valueOf(worldOffset.z));
        program.setUniform("transformation", FLOAT_BUFFER_16);
        program.setUniform("color", Float.valueOf((float)bgColor.getRed() / 255.0f), Float.valueOf((float)bgColor.getGreen() / 255.0f), Float.valueOf((float)bgColor.getBlue() / 255.0f), Float.valueOf((float)bgColor.getAlpha() / 255.0f));
        program.unuse();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        rectBackgroundRenderer.render();
        Color grayColor = EmtColor.parseColorFromHexString(CfgFeatures.MOB_HEALTH_BAR.graySpaceColor);
        program.use();
        program.setUniform("color", Float.valueOf((float)grayColor.getRed() / 255.0f), Float.valueOf((float)grayColor.getGreen() / 255.0f), Float.valueOf((float)grayColor.getBlue() / 255.0f), Float.valueOf((float)grayColor.getAlpha() / 255.0f));
        program.unuse();
        rectGraySpaceRenderer.render();
        rectHealthBarRenderer.render();
        iterator = entities.entrySet().iterator();
        for (i = 0; iterator.hasNext() && i < entityListLength; ++i) {
            Map.Entry<EntityLivingBase, HealthBarData> entry = iterator.next();
            EntityLivingBase entity = entry.getKey();
            HealthBarData healthBarData = entry.getValue();
            HealthBarInstancingHelper.renderHealthBarInfoSeparately(entity, healthBarData, partialTicks, worldOffset, cameraRot);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderHealthBarInfoSeparately(EntityLivingBase entity, HealthBarData healthBarData, float partialTicks, Vector3f cameraPos, Vector2f cameraRot) {
        String entityID = EntityList.func_75621_b((Entity)entity);
        boolean boss = !entity.func_184222_aU();
        float entityX = (float)(entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks);
        float entityY = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
        float entityZ = (float)(entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks);
        float maxHealth = entity.func_110138_aP();
        float health = Math.min(maxHealth, entity.func_110143_aJ());
        float percent = (int)(health / maxHealth * 100.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(entityX - cameraPos.x), (float)(entityY - cameraPos.y + entity.field_70131_O + (float)CfgFeatures.MOB_HEALTH_BAR.heightAbove), (float)(entityZ - cameraPos.z));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.toDegrees(cameraRot.x))), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(cameraRot.y)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.026666673f, (float)-0.026666673f, (float)0.026666673f);
        GlStateManager.func_179090_x();
        float padding = CfgFeatures.MOB_HEALTH_BAR.backgroundPadding;
        int bgHeight = CfgFeatures.MOB_HEALTH_BAR.backgroundHeight;
        int barHeight = CfgFeatures.MOB_HEALTH_BAR.barHeight;
        float size = CfgFeatures.MOB_HEALTH_BAR.plateSize;
        ItemStack stack = null;
        if (entity instanceof IMob) {
            EnumCreatureAttribute attr = entity.func_70668_bt();
            switch (attr) {
                case ARTHROPOD: {
                    stack = SPIDER_EYE;
                    break;
                }
                case UNDEAD: {
                    stack = ROTTEN_FLESH;
                    break;
                }
                case ILLAGER: {
                    stack = TOTEM_OF_UNDYING;
                    break;
                }
                default: {
                    stack = SKULL;
                }
            }
        }
        if (boss) {
            stack = BOSS_SKULL;
            size = CfgFeatures.MOB_HEALTH_BAR.plateSizeBoss;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)healthBarData.ridingStackPos) * ((float)(bgHeight + barHeight) + padding)), (float)0.0f);
        float s = 0.5f;
        float namel = (float)HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78256_a(healthBarData.name) * s;
        if (namel + 20.0f > size * 2.0f) {
            size = namel / 2.0f + 10.0f;
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-size), (float)-4.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (CfgFeatures.MOB_HEALTH_BAR.showName) {
            HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78276_b(healthBarData.name, 0, 0, 0xFFFFFF);
        }
        GlStateManager.func_179094_E();
        float s1 = 0.75f;
        GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
        int h = CfgFeatures.MOB_HEALTH_BAR.hpTextHeight;
        String maxHpStr = TextFormatting.BOLD + "" + (double)Math.round((double)maxHealth * 100.0) / 100.0;
        String hpStr = "" + (double)Math.round((double)health * 100.0) / 100.0;
        String percStr = (int)percent + "%";
        if (maxHpStr.endsWith(".0")) {
            maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 2);
        }
        if (hpStr.endsWith(".0")) {
            hpStr = hpStr.substring(0, hpStr.length() - 2);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showCurrentHP) {
            HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78276_b(hpStr, 2, h, 0xFFFFFF);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showMaxHP) {
            HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78276_b(maxHpStr, (int)(size / (s * s1) * 2.0f) - 2 - HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78256_a(maxHpStr), h, 0xFFFFFF);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showPercentage) {
            HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78276_b(percStr, (int)(size / (s * s1)) - HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78256_a(percStr) / 2, h, -1);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.enableDebugInfo && HealthBarInstancingHelper.MINECRAFT.field_71474_y.field_74330_P) {
            HealthBarInstancingHelper.MINECRAFT.field_71466_p.func_78276_b("ID: \"" + entityID + "\"", 0, h + 16, -1);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int off = 0;
        s1 = 0.5f;
        GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
        GlStateManager.func_179109_b((float)(size / (s * s1) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
        HealthBarInstancingHelper.MINECRAFT.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (stack != null && CfgFeatures.MOB_HEALTH_BAR.showAttributes) {
            HealthBarDirectRenderHelper.renderIcon(off, 0, stack, 16, 16);
            off -= 16;
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showArmor && entity.func_70658_aO() > 0) {
            int i;
            int armor = entity.func_70658_aO();
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!CfgFeatures.MOB_HEALTH_BAR.groupArmor) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            for (i = 0; i < ironArmor; ++i) {
                HealthBarDirectRenderHelper.renderIcon(off, 0, IRON_CHESTPLATE, 16, 16);
                off -= 4;
            }
            for (i = 0; i < diamondArmor; ++i) {
                HealthBarDirectRenderHelper.renderIcon(off, 0, DIAMOND_CHESTPLATE, 16, 16);
                off -= 4;
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

