/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.healthbar.render;

import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import io.enderdev.endermodpacktweaks.config.EnumShapeType;
import io.enderdev.endermodpacktweaks.features.healthbar.HealthBarData;
import io.enderdev.endermodpacktweaks.utils.EmtColor;
import io.enderdev.endermodpacktweaks.utils.EmtRender;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public final class HealthBarDirectRenderHelper {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private static final ItemStack IRON_CHESTPLATE = new ItemStack((Item)Items.field_151030_Z);
    private static final ItemStack DIAMOND_CHESTPLATE = new ItemStack((Item)Items.field_151163_ad);
    private static final ItemStack SPIDER_EYE = new ItemStack(Items.field_151070_bp);
    private static final ItemStack ROTTEN_FLESH = new ItemStack(Items.field_151078_bh);
    private static final ItemStack TOTEM_OF_UNDYING = new ItemStack(Items.field_190929_cY);
    private static final ItemStack SKULL = new ItemStack(Items.field_151144_bL, 1, 4);
    private static final ItemStack NAMETAG = new ItemStack(Items.field_151057_cb);
    private static final ItemStack BOSS_SKULL = new ItemStack(Items.field_151144_bL);

    public static void renderHealthBar(EntityLivingBase entity, HealthBarData healthBarData, float partialTicks, float deltaTime, Vector3f worldOffset, Vector2f cameraRot) {
        boolean useHue;
        String entityID = EntityList.func_75621_b((Entity)entity);
        boolean boss = !entity.func_184222_aU();
        boolean named = entity.func_145818_k_();
        float entityX = (float)(entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks);
        float entityY = (float)(entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks);
        float entityZ = (float)(entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks);
        float maxHealth = entity.func_110138_aP();
        float health = CfgFeatures.MOB_HEALTH_BAR.enableSmoothAnimation && healthBarData.healthSmoothDamp != null ? Math.min(maxHealth, healthBarData.healthSmoothDamp.evaluate(deltaTime)) : Math.min(maxHealth, entity.func_110143_aJ());
        float percent = (int)(health / maxHealth * 100.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(entityX - worldOffset.x), (float)(entityY - worldOffset.y + entity.field_70131_O + (float)CfgFeatures.MOB_HEALTH_BAR.heightAbove), (float)(entityZ - worldOffset.z));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.toDegrees(cameraRot.x))), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)Math.toDegrees(cameraRot.y)), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.026666673f, (float)-0.026666673f, (float)0.026666673f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        float padding = CfgFeatures.MOB_HEALTH_BAR.backgroundPadding;
        int bgHeight = CfgFeatures.MOB_HEALTH_BAR.backgroundHeight;
        int barHeight = CfgFeatures.MOB_HEALTH_BAR.barHeight;
        float size = CfgFeatures.MOB_HEALTH_BAR.plateSize;
        int r = 0;
        int g = 255;
        int b = 0;
        ItemStack stack = null;
        if (entity instanceof IMob) {
            r = 255;
            g = 0;
            EnumCreatureAttribute attr = entity.func_70668_bt();
            switch (attr) {
                case ARTHROPOD: {
                    stack = SPIDER_EYE;
                    break;
                }
                case UNDEAD: {
                    stack = ROTTEN_FLESH;
                    break;
                }
                case ILLAGER: {
                    stack = TOTEM_OF_UNDYING;
                    break;
                }
                default: {
                    stack = SKULL;
                }
            }
        }
        if (boss) {
            stack = BOSS_SKULL;
            size = CfgFeatures.MOB_HEALTH_BAR.plateSizeBoss;
            r = 128;
            g = 0;
            b = 128;
        }
        boolean bl = useHue = !CfgFeatures.MOB_HEALTH_BAR.colorByType;
        if (useHue) {
            float hue = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
            Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
            r = color.getRed();
            g = color.getGreen();
            b = color.getBlue();
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)healthBarData.ridingStackPos) * ((float)(bgHeight + barHeight) + padding)), (float)0.0f);
        float s = 0.5f;
        float namel = (float)HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78256_a(healthBarData.name) * s;
        if (namel + 20.0f > size * 2.0f) {
            size = namel / 2.0f + 10.0f;
        }
        float healthSize = size * (health / maxHealth);
        if (CfgFeatures.MOB_HEALTH_BAR.drawBackground) {
            Color bgColor = EmtColor.parseColorFromHexString(CfgFeatures.MOB_HEALTH_BAR.backgroundColor);
            if (CfgFeatures.MOB_HEALTH_BAR.shapeBackground == EnumShapeType.STRAIGHT) {
                EmtRender.renderRect(-size - padding, -bgHeight, size * 2.0f + padding * 2.0f, (float)(bgHeight * 2) + padding, bgColor);
            }
            if (CfgFeatures.MOB_HEALTH_BAR.shapeBackground == EnumShapeType.ROUND) {
                EmtRender.renderRoundedRect(-size - padding, -bgHeight, size * 2.0f + padding * 2.0f, (float)(bgHeight * 2) + padding, CfgFeatures.MOB_HEALTH_BAR.backgroundRadius, bgColor);
            }
        }
        if (CfgFeatures.MOB_HEALTH_BAR.drawGraySpace) {
            Color grayColor = EmtColor.parseColorFromHexString(CfgFeatures.MOB_HEALTH_BAR.graySpaceColor);
            if (CfgFeatures.MOB_HEALTH_BAR.shapeBar == EnumShapeType.STRAIGHT) {
                EmtRender.renderRect(-size, 0.0f, size * 2.0f, barHeight, grayColor);
            }
            if (CfgFeatures.MOB_HEALTH_BAR.shapeBar == EnumShapeType.ROUND) {
                EmtRender.renderRoundedRect(-size, 0.0f, size * 2.0f, barHeight, CfgFeatures.MOB_HEALTH_BAR.barRadius, grayColor);
            }
        }
        if (CfgFeatures.MOB_HEALTH_BAR.drawHealthBar) {
            Color healthColor = new Color(r, g, b, CfgFeatures.MOB_HEALTH_BAR.healthBarAlpha);
            if (CfgFeatures.MOB_HEALTH_BAR.shapeBar == EnumShapeType.STRAIGHT) {
                EmtRender.renderRect(-size, 0.0f, healthSize * 2.0f, barHeight, healthColor);
            }
            if (CfgFeatures.MOB_HEALTH_BAR.shapeBar == EnumShapeType.ROUND) {
                EmtRender.renderRoundedRect(-size, 0.0f, healthSize * 2.0f, barHeight, CfgFeatures.MOB_HEALTH_BAR.barRadius, healthColor);
            }
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(-size), (float)-4.5f, (float)0.0f);
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (CfgFeatures.MOB_HEALTH_BAR.showName) {
            HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78276_b(healthBarData.name, 0, 0, 0xFFFFFF);
        }
        GlStateManager.func_179094_E();
        float s1 = 0.75f;
        GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
        int h = CfgFeatures.MOB_HEALTH_BAR.hpTextHeight;
        String maxHpStr = TextFormatting.BOLD + "" + (double)Math.round((double)maxHealth * 100.0) / 100.0;
        String hpStr = "" + (double)Math.round((double)health * 100.0) / 100.0;
        String percStr = (int)percent + "%";
        if (maxHpStr.endsWith(".0")) {
            maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 2);
        }
        if (hpStr.endsWith(".0")) {
            hpStr = hpStr.substring(0, hpStr.length() - 2);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showCurrentHP) {
            HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78276_b(hpStr, 2, h, 0xFFFFFF);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showMaxHP) {
            HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78276_b(maxHpStr, (int)(size / (s * s1) * 2.0f) - 2 - HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78256_a(maxHpStr), h, 0xFFFFFF);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showPercentage) {
            HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78276_b(percStr, (int)(size / (s * s1)) - HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78256_a(percStr) / 2, h, -1);
        }
        if (CfgFeatures.MOB_HEALTH_BAR.enableDebugInfo && HealthBarDirectRenderHelper.MINECRAFT.field_71474_y.field_74330_P) {
            HealthBarDirectRenderHelper.MINECRAFT.field_71466_p.func_78276_b("ID: \"" + entityID + "\"", 0, h + 16, -1);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int off = 0;
        s1 = 0.5f;
        GlStateManager.func_179152_a((float)s1, (float)s1, (float)s1);
        GlStateManager.func_179109_b((float)(size / (s * s1) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
        HealthBarDirectRenderHelper.MINECRAFT.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        if (stack != null && CfgFeatures.MOB_HEALTH_BAR.showAttributes) {
            HealthBarDirectRenderHelper.renderIcon(off, 0, stack, 16, 16);
            off -= 16;
        }
        if (named && CfgFeatures.MOB_HEALTH_BAR.showNameTag) {
            HealthBarDirectRenderHelper.renderIcon(off, 0, NAMETAG, 16, 16);
            off -= 16;
        }
        if (CfgFeatures.MOB_HEALTH_BAR.showArmor && entity.func_70658_aO() > 0) {
            int i;
            int armor = entity.func_70658_aO();
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!CfgFeatures.MOB_HEALTH_BAR.groupArmor) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            for (i = 0; i < ironArmor; ++i) {
                HealthBarDirectRenderHelper.renderIcon(off, 0, IRON_CHESTPLATE, 16, 16);
                off -= 4;
            }
            for (i = 0; i < diamondArmor; ++i) {
                HealthBarDirectRenderHelper.renderIcon(off, 0, DIAMOND_CHESTPLATE, 16, 16);
                off -= 4;
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void renderIcon(int vertexX, int vertexY, ItemStack stack, int intU, int intV) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        IBakedModel iBakedModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        TextureAtlasSprite meow = iBakedModel.func_177554_e();
        if (meow == null) {
            return;
        }
        String iconName = meow.func_94215_i();
        if (iconName == null) {
            return;
        }
        TextureAtlasSprite textureAtlasSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(iconName);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)vertexX, (double)(vertexY + intV), 0.0).func_187315_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b((double)(vertexX + intU), (double)(vertexY + intV), 0.0).func_187315_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94210_h()).func_181675_d();
        buffer.func_181662_b((double)(vertexX + intU), (double)vertexY, 0.0).func_187315_a((double)textureAtlasSprite.func_94212_f(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
        buffer.func_181662_b((double)vertexX, (double)vertexY, 0.0).func_187315_a((double)textureAtlasSprite.func_94209_e(), (double)textureAtlasSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }
}

