/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.healthbar;

import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import io.enderdev.endermodpacktweaks.config.EnumShapeType;
import io.enderdev.endermodpacktweaks.features.healthbar.HealthBarData;
import io.enderdev.endermodpacktweaks.features.healthbar.render.HealthBarDirectRenderHelper;
import io.enderdev.endermodpacktweaks.features.healthbar.render.HealthBarInstancingHelper;
import io.enderdev.endermodpacktweaks.mixin.minecraft.WorldClientAccessor;
import io.enderdev.endermodpacktweaks.utils.EmtConfigHandler;
import io.enderdev.endermodpacktweaks.utils.EmtConfigParser;
import io.enderdev.endermodpacktweaks.utils.EmtRender;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import org.apache.commons.lang3.time.StopWatch;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class HealthBarHandler {
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    public static final float HEALTH_BAR_HUD_SCALE = 0.026666673f;
    public final EmtConfigHandler<EmtConfigParser.ConfigItem> whitelist;
    public final EmtConfigHandler<EmtConfigParser.ConfigItemWithFloat> rangeModifiers;
    private final KeyBinding key;
    private boolean down;
    private boolean shouldRender;
    public boolean instancing;
    private Map<EntityLivingBase, HealthBarData> entities;
    private final StopWatch entityCollectionStopWatch;
    public double entityCollectionInterval;
    private final Frustum frustum;
    private final Map<EntityLivingBase, Long> lingerEntities;
    private Long lastTimeNano;
    private float deltaTimeSecond;

    public HealthBarHandler() {
        this.whitelist = new EmtConfigHandler<EmtConfigParser.ConfigItem>(CfgFeatures.MOB_HEALTH_BAR.onlyRenderWithEquipment, EmtConfigParser.ConfigItem::new);
        this.rangeModifiers = new EmtConfigHandler<EmtConfigParser.ConfigItemWithFloat>(CfgFeatures.MOB_HEALTH_BAR.distanceMultipliers, EmtConfigParser.ConfigItemWithFloat::new);
        this.shouldRender = true;
        this.instancing = false;
        this.entities = new HashMap<EntityLivingBase, HealthBarData>();
        this.entityCollectionStopWatch = new StopWatch();
        this.entityCollectionInterval = 0.025;
        this.frustum = new Frustum();
        this.lingerEntities = new HashMap<EntityLivingBase, Long>();
        this.lastTimeNano = null;
        this.deltaTimeSecond = 0.0f;
        this.key = new KeyBinding("keybind.endermodpacktweaks.toggle", 0, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)this.key);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        boolean wasDown = this.down;
        this.down = this.key.func_151470_d();
        if (HealthBarHandler.MINECRAFT.field_71415_G && this.down && !wasDown) {
            this.shouldRender = !this.shouldRender;
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (HealthBarHandler.MINECRAFT.field_71439_g == null) {
            return;
        }
        if (!CfgFeatures.MOB_HEALTH_BAR.renderInF1 && !Minecraft.func_71382_s() || !this.shouldRender) {
            return;
        }
        if (CfgFeatures.MOB_HEALTH_BAR.onlyRenderWithEquipment.length != 0 && !this.whitelist.equipped((EntityPlayer)HealthBarHandler.MINECRAFT.field_71439_g)) {
            return;
        }
        Entity cameraEntity = MINECRAFT.func_175606_aa();
        if (cameraEntity == null || !cameraEntity.func_70089_S()) {
            return;
        }
        if (this.lastTimeNano == null) {
            this.lastTimeNano = System.nanoTime();
            this.deltaTimeSecond = 0.0f;
        } else {
            long time = System.nanoTime();
            this.deltaTimeSecond = (float)((double)(time - this.lastTimeNano) / 1.0E9);
            this.lastTimeNano = time;
        }
        BlockPos cameraBlockPos = cameraEntity.func_180425_c();
        Vector3f worldOffset = EmtRender.getWorldOffset();
        Vector3f cameraPos = EmtRender.getCameraPos();
        Vector2f cameraRot = EmtRender.getCameraRotationInRadian();
        float partialTicks = (float)EmtRender.getPartialTick();
        if (!this.entityCollectionStopWatch.isStarted()) {
            this.entityCollectionStopWatch.start();
        }
        if ((double)this.entityCollectionStopWatch.getNanoTime() / 1.0E9 >= this.entityCollectionInterval) {
            this.entityCollectionStopWatch.stop();
            this.entityCollectionStopWatch.reset();
            HashMap newEntities = new HashMap();
            if (CfgFeatures.MOB_HEALTH_BAR.showOnlyFocused) {
                long l = Minecraft.func_71386_F();
                Entity focused = this.getEntityLookedAt((Entity)HealthBarHandler.MINECRAFT.field_71439_g);
                if (focused instanceof EntityLivingBase && focused.func_70089_S()) {
                    this.collectHealthBarEntities(newEntities, (EntityLivingBase)focused, cameraEntity);
                    if (CfgFeatures.MOB_HEALTH_BAR.focusedLinger != 0) {
                        this.lingerEntities.put((EntityLivingBase)focused, l + (long)CfgFeatures.MOB_HEALTH_BAR.focusedLinger);
                    }
                }
                this.lingerEntities.entrySet().removeIf(entry -> {
                    if (systemTime >= (Long)entry.getValue()) {
                        return true;
                    }
                    this.collectHealthBarEntities(newEntities, (EntityLivingBase)entry.getKey(), cameraEntity);
                    return false;
                });
            } else {
                this.frustum.func_78547_a((double)cameraPos.x, (double)cameraPos.y, (double)cameraPos.z);
                for (Entity entity : ((WorldClientAccessor)HealthBarHandler.MINECRAFT.field_71441_e).getEntityList()) {
                    if (!(entity instanceof EntityLivingBase) || entity == HealthBarHandler.MINECRAFT.field_71439_g || !entity.func_145770_h((double)cameraBlockPos.func_177958_n(), (double)cameraBlockPos.func_177956_o(), (double)cameraBlockPos.func_177952_p()) || !entity.field_70158_ak && !this.frustum.func_78546_a(entity.func_174813_aQ()) || !entity.func_70089_S() || !entity.func_184182_bu().isEmpty()) continue;
                    this.collectHealthBarEntities(newEntities, (EntityLivingBase)entity, cameraEntity);
                }
            }
            if (CfgFeatures.MOB_HEALTH_BAR.enableSmoothAnimation) {
                for (Map.Entry entry2 : newEntities.entrySet()) {
                    HealthBarData oldData = this.entities.get(entry2.getKey());
                    if (oldData != null) {
                        if (((HealthBarData)entry2.getValue()).healthSmoothDamp == null || oldData.healthSmoothDamp == null) continue;
                        ((HealthBarData)entry2.getValue()).healthSmoothDamp.setFrom(oldData.healthSmoothDamp.getFrom());
                        continue;
                    }
                    if (((HealthBarData)entry2.getValue()).healthSmoothDamp == null) continue;
                    ((HealthBarData)entry2.getValue()).healthSmoothDamp.setFrom(((EntityLivingBase)entry2.getKey()).func_110143_aJ());
                }
            }
            this.entities = newEntities;
            this.entityCollectionStopWatch.start();
        }
        if (CfgFeatures.MOB_HEALTH_BAR.enableSmoothAnimation) {
            for (Map.Entry entry3 : this.entities.entrySet()) {
                if (((HealthBarData)entry3.getValue()).healthSmoothDamp == null) continue;
                ((HealthBarData)entry3.getValue()).healthSmoothDamp.setTo(((EntityLivingBase)entry3.getKey()).func_110143_aJ());
            }
        }
        if (this.instancing && this.entities.size() > 5 && CfgFeatures.MOB_HEALTH_BAR.shapeBackground == EnumShapeType.STRAIGHT) {
            HealthBarInstancingHelper.renderRectHealthBars(this.entities, partialTicks, this.deltaTimeSecond, worldOffset, cameraRot);
        } else {
            int oldProgram = GL11.glGetInteger((int)35725);
            if (oldProgram != 0) {
                GL20.glUseProgram((int)0);
            }
            for (Map.Entry<EntityLivingBase, HealthBarData> entry4 : this.entities.entrySet()) {
                HealthBarDirectRenderHelper.renderHealthBar(entry4.getKey(), entry4.getValue(), partialTicks, this.deltaTimeSecond, worldOffset, cameraRot);
            }
            if (oldProgram != 0) {
                GL20.glUseProgram((int)oldProgram);
            }
        }
    }

    private void collectHealthBarEntities(Map<EntityLivingBase, HealthBarData> entities, EntityLivingBase entity, Entity viewPoint) {
        Stack<EntityLivingBase> ridingStack = new Stack<EntityLivingBase>();
        ridingStack.push(entity);
        while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityLivingBase) {
            entity = (EntityLivingBase)entity.func_184187_bx();
            ridingStack.push(entity);
        }
        Minecraft mc = Minecraft.func_71410_x();
        int index = 0;
        while (!ridingStack.isEmpty()) {
            float distance;
            entity = (EntityLivingBase)ridingStack.pop();
            boolean boss = !entity.func_184222_aU();
            String entityID = EntityList.func_75621_b((Entity)entity);
            if (Arrays.asList(CfgFeatures.MOB_HEALTH_BAR.mobBlacklist).contains(entityID)) continue;
            float maxDistance = CfgFeatures.MOB_HEALTH_BAR.maxDistance;
            if (CfgFeatures.MOB_HEALTH_BAR.distanceMultipliers.length != 0 && this.rangeModifiers.equipped((EntityPlayer)mc.field_71439_g)) {
                EmtConfigParser.ConfigItemWithFloat modifier = (EmtConfigParser.ConfigItemWithFloat)this.rangeModifiers.getEquipped((EntityPlayer)mc.field_71439_g);
                maxDistance *= modifier != null ? modifier.value() : 1.0f;
            }
            if ((distance = entity.func_70032_d(viewPoint)) > maxDistance || !entity.func_70685_l(viewPoint) || entity.func_82150_aj() || !CfgFeatures.MOB_HEALTH_BAR.showOnBosses && boss || !CfgFeatures.MOB_HEALTH_BAR.showOnPlayers && entity instanceof EntityPlayer || entity.func_110138_aP() <= 0.0f) continue;
            String name = I18n.func_135052_a((String)entity.func_145748_c_().func_150254_d(), (Object[])new Object[0]);
            if (entity instanceof EntityLiving && entity.func_145818_k_()) {
                name = TextFormatting.ITALIC + entity.func_95999_t();
            } else if (entity instanceof EntityVillager) {
                name = I18n.func_135052_a((String)"entity.Villager.name", (Object[])new Object[0]);
            }
            HealthBarData data = CfgFeatures.MOB_HEALTH_BAR.enableSmoothAnimation ? new HealthBarData(name, index++, CfgFeatures.MOB_HEALTH_BAR.animationSmoothTime) : new HealthBarData(name, index++);
            entities.put(entity, data);
        }
    }

    private Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = CfgFeatures.MOB_HEALTH_BAR.maxDistance;
        if (CfgFeatures.MOB_HEALTH_BAR.distanceMultipliers.length != 0 && this.rangeModifiers.equipped((EntityPlayer)e)) {
            EmtConfigParser.ConfigItemWithFloat modifier = (EmtConfigParser.ConfigItemWithFloat)this.rangeModifiers.getEquipped((EntityPlayer)e);
            finalDistance *= modifier != null ? (double)modifier.value() : 1.0;
        }
        double distance = finalDistance;
        RayTraceResult pos = HealthBarHandler.rayCast(e, finalDistance);
        Vec3d positionVector = e.func_174791_d();
        if (e instanceof EntityPlayer) {
            positionVector = positionVector.func_72441_c(0.0, (double)e.func_70047_e(), 0.0);
        }
        if (pos != null) {
            distance = pos.field_72307_f.func_72438_d(positionVector);
        }
        Vec3d lookVector = e.func_70040_Z();
        Vec3d reachVector = positionVector.func_72441_c(lookVector.field_72450_a * finalDistance, lookVector.field_72448_b * finalDistance, lookVector.field_72449_c * finalDistance);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.func_130014_f_().func_72839_b(e, e.func_174813_aQ().func_72314_b(lookVector.field_72450_a * finalDistance, lookVector.field_72448_b * finalDistance, lookVector.field_72449_c * finalDistance).func_72321_a(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.func_70067_L()) {
                double distanceToEntity;
                float collisionBorderSize = entity.func_70111_Y();
                AxisAlignedBB hitbox = entity.func_174813_aQ().func_72321_a((double)collisionBorderSize, (double)collisionBorderSize, (double)collisionBorderSize);
                RayTraceResult interceptPosition = hitbox.func_72327_a(positionVector, reachVector);
                if (hitbox.func_72318_a(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition != null && ((distanceToEntity = positionVector.func_72438_d(interceptPosition.field_72307_f)) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static RayTraceResult rayCast(Entity e, double len) {
        Vec3d vec = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        if (e instanceof EntityPlayer) {
            vec = vec.func_178787_e(new Vec3d(0.0, (double)e.func_70047_e(), 0.0));
        }
        Vec3d look = e.func_70040_Z();
        return HealthBarHandler.rayCast(e.func_130014_f_(), vec, look, len);
    }

    private static RayTraceResult rayCast(World world, Vec3d origin, Vec3d ray, double len) {
        Vec3d end = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        return world.func_72933_a(origin, end);
    }
}

