/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.compatscreen;

import com.google.common.collect.ImmutableMap;
import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import io.enderdev.endermodpacktweaks.config.CfgMinecraft;
import io.enderdev.endermodpacktweaks.config.CfgModpack;
import io.enderdev.endermodpacktweaks.config.CfgTweaks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class CompatModsHandler {
    private static final Map<String, BooleanSupplier> obsoleteModMap = ImmutableMap.copyOf((Map)new HashMap<String, BooleanSupplier>(){
        {
            this.put("dragonmurder", () -> CfgMinecraft.DRAGON.enable);
            this.put("packcrashinfo", () -> CfgModpack.CRASH_INFO.enable);
            this.put("materialchanger", () -> CfgFeatures.MATERIAL_TWEAKER.enable);
            this.put("asaafp", () -> CfgTweaks.ASTRAL_SORCERY.enable);
            this.put("chunkomg", () -> CfgMinecraft.CLIENT.enable);
            this.put("hidenametags", () -> CfgMinecraft.CLIENT.enable);
            this.put("hideitemnames", () -> CfgMinecraft.CLIENT.enable);
            this.put("antifovchange", () -> CfgMinecraft.CLIENT.enable);
            this.put("icfluxnetworkenergylimitfix", () -> CfgTweaks.FLUX_NETWORKS.enable);
            this.put("neat", () -> CfgFeatures.MOB_HEALTH_BAR.enable);
            this.put("bonemealmod", () -> CfgFeatures.INSTANT_BONE_MEAL.enable);
            this.put("controlling", () -> CfgFeatures.IMPROVED_KEYBINDS.enable);
            this.put("witherproof", () -> CfgFeatures.BOSS_PROOF_BLOCKS.enable);
            this.put("packupdater", () -> CfgModpack.PACK_UPDATER.enable);
            this.put("itlt", () -> CfgModpack.CUSTOMIZATION.enable || CfgModpack.DEFAULT_SERVER.enable);
            this.put("startuptimer", () -> CfgModpack.STARTUP_TIMER.enable);
            this.put("forcedresourcepacks", () -> CfgFeatures.FORCED_RESOURCEPACK.enable);
        }
    });
    private static List<String> obsoleteModsList;
    private static boolean hasShownObsoleteMods;

    public static boolean hasObsoleteModsMessage() {
        return !CompatModsHandler.hasShownObsoleteMods() && !CompatModsHandler.getObsoleteModsList().isEmpty();
    }

    public static List<String> obsoleteModsMessage() {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(new TextComponentTranslation("msg.endermodpacktweaks.obsoletemods.warning1", new Object[0]).func_150254_d());
        messages.add(new TextComponentTranslation("msg.endermodpacktweaks.obsoletemods.warning2", new Object[0]).func_150254_d());
        messages.add("");
        messages.addAll(CompatModsHandler.getObsoleteModsList());
        messages.add("");
        messages.add(new TextComponentTranslation("msg.endermodpacktweaks.obsoletemods.warning3", new Object[0]).func_150254_d());
        return messages;
    }

    private static List<String> getObsoleteModsList() {
        if (obsoleteModsList == null) {
            obsoleteModsList = CompatModsHandler.generateObsoleteModsList();
        }
        return obsoleteModsList;
    }

    private static List<String> generateObsoleteModsList() {
        ArrayList<String> messages = new ArrayList<String>();
        Map modIdMap = Loader.instance().getIndexedModList();
        for (String modId : obsoleteModMap.keySet()) {
            if (!Loader.isModLoaded((String)modId) || !obsoleteModMap.get(modId).getAsBoolean()) continue;
            messages.add(((ModContainer)modIdMap.get(modId)).getName());
        }
        return messages;
    }

    public static boolean hasShownObsoleteMods() {
        return hasShownObsoleteMods;
    }

    public static void setHasShownObsoleteMods(boolean value) {
        hasShownObsoleteMods = value;
    }

    static {
        hasShownObsoleteMods = false;
    }
}

