/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.features.bossbar;

import com.google.gson.Gson;
import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.features.bossbar.BossRegister;
import io.enderdev.endermodpacktweaks.features.bossbar.BossType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.BossInfo;

public class ImprovedBossBarRenderer
extends Gui {
    private final Minecraft mc;
    private final Map<String, String> unknownBossMobs = new HashMap<String, String>(){
        {
            this.put("INVALID", "INVALID");
        }
    };
    private static final ResourceLocation textureBarBackground = new ResourceLocation("endermodpacktweaks", "textures/gui/bars/background.png");

    public ImprovedBossBarRenderer(Minecraft mc) {
        this.mc = mc;
    }

    public int getOverlayHeight(BossInfo info) {
        String mob = this.getEntityFromBossInfo(info);
        BossType boss = BossRegister.getBossType(mob);
        return boss == null ? 0 : boss.getOverlayHeight();
    }

    public boolean hasOverlay(String text) {
        return !this.unknownBossMobs.containsValue(text);
    }

    public boolean render(int x, int y, BossInfo info) {
        String mob = this.getEntityFromBossInfo(info);
        BossType boss = BossRegister.getBossType(mob);
        if (boss == null) {
            if (!this.unknownBossMobs.containsKey(mob)) {
                this.unknownBossMobs.put(mob, info.func_186744_e().func_150254_d());
                EnderModpackTweaks.LOGGER.warn("Unknown boss mob: {}, named {}", (Object)mob, (Object)info.func_186744_e().func_150254_d());
            }
            return false;
        }
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        GlStateManager.func_179094_E();
        int middleX = scaledresolution.func_78326_a() / 2 - boss.getOverlayWidth() / 2;
        this.renderBar(middleX + boss.getBarOffsetX(), y + boss.getBarOffsetY(), boss.getBarWidth(), info, boss.getBar());
        this.renderOverlay(middleX, y, boss.getOverlay());
        GlStateManager.func_179121_F();
        return true;
    }

    private void renderBar(int x, int y, int barWidth, BossInfo info, ResourceLocation textureBarForeground) {
        this.mc.func_110434_K().func_110577_a(textureBarBackground);
        ImprovedBossBarRenderer.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)352, (int)10, (int)barWidth, (int)5, (float)352.0f, (float)10.0f);
        int i = (int)Math.floor(info.func_186738_f() * (float)barWidth);
        if (i > 0) {
            this.mc.func_110434_K().func_110577_a(textureBarForeground);
            ImprovedBossBarRenderer.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)352, (int)10, (int)i, (int)5, (float)352.0f, (float)10.0f);
        }
    }

    private void renderOverlay(int x, int y, ResourceLocation overlay) {
        this.mc.func_110434_K().func_110577_a(overlay);
        int overlayWidth = GlStateManager.func_187411_c((int)3553, (int)0, (int)4096);
        int overlayHeight = GlStateManager.func_187411_c((int)3553, (int)0, (int)4097);
        ImprovedBossBarRenderer.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)overlayWidth, (int)overlayHeight, (int)overlayWidth, (int)overlayHeight, (float)overlayWidth, (float)overlayHeight);
    }

    private String getEntityFromBossInfo(BossInfo info) {
        ITextComponent name = info.func_186744_e();
        if (name instanceof TextComponentTranslation) {
            TextComponentTranslation translation = (TextComponentTranslation)name;
            if (translation.func_150268_i().equals("entity.EnderDragon.name")) {
                return "minecraft:ender_dragon";
            }
        } else {
            HoverEvent hoverEvent = name.func_150256_b().func_150210_i();
            if (hoverEvent != null) {
                String componentText = name.func_150256_b().func_150210_i().func_150702_b().func_150261_e();
                StringJson jsonObject = (StringJson)new Gson().fromJson(componentText, StringJson.class);
                return jsonObject.type;
            }
        }
        return "INVALID";
    }

    private static class StringJson {
        private String id;
        private String type;
        private String name;

        private StringJson() {
        }
    }
}

