/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.events;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.event.LevelUpEvent;
import codersafterdark.reskillable.client.gui.GuiSkillInfo;
import codersafterdark.reskillable.client.gui.GuiSkills;
import codersafterdark.reskillable.client.gui.button.GuiButtonLevelUp;
import io.enderdev.endermodpacktweaks.config.CfgTweaks;
import java.util.stream.IntStream;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReskillableEvents {
    @SubscribeEvent
    public void beforeLevelUp(LevelUpEvent.Pre event) {
        if (this.playerDataCheck(event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiSkills) {
            for (GuiButton button : event.getButtonList()) {
                if (!(button instanceof GuiButtonLevelUp) || !this.playerDataCheck((EntityPlayer)event.getGui().field_146297_k.field_71439_g)) continue;
                button.field_146124_l = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiRender(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiSkillInfo) {
            for (GuiButton button : event.getGui().field_146292_n) {
                if (!(button instanceof GuiButtonLevelUp) || event.getMouseX() < button.field_146128_h || event.getMouseX() > button.field_146128_h + button.field_146120_f || event.getMouseY() < button.field_146129_i || event.getMouseY() > button.field_146129_i + button.field_146121_g) continue;
                EntityPlayerSP player = event.getGui().field_146297_k.field_71439_g;
                if (this.playerDataCheck((EntityPlayer)player)) {
                    event.getGui().func_146279_a(I18n.func_135052_a((String)"endermodpacktweaks.reskillable.level_max", (Object[])new Object[]{CfgTweaks.RESKILLABLE.maxLevel}), event.getMouseX(), event.getMouseY());
                    continue;
                }
                if (CfgTweaks.RESKILLABLE.maxLevel <= 0) continue;
                event.getGui().func_146279_a(I18n.func_135052_a((String)"endermodpacktweaks.reskillable.level_left", (Object[])new Object[]{CfgTweaks.RESKILLABLE.maxLevel - this.getSum((EntityPlayer)player)}), event.getMouseX(), event.getMouseY());
            }
        }
    }

    private boolean playerDataCheck(EntityPlayer player) {
        int sum = this.getSum(player);
        if (sum == 0) {
            return false;
        }
        return sum >= CfgTweaks.RESKILLABLE.maxLevel && CfgTweaks.RESKILLABLE.maxLevel > 0;
    }

    private int getSum(EntityPlayer player) {
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        if (data == null) {
            return 0;
        }
        return data.getAllSkillInfo().stream().flatMapToInt(playerSkillInfo -> IntStream.of(playerSkillInfo.getLevel())).sum();
    }
}

