/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.core;

import com.google.common.collect.ImmutableMap;
import io.enderdev.endermodpacktweaks.config.CfgFeatures;
import io.enderdev.endermodpacktweaks.config.CfgMinecraft;
import io.enderdev.endermodpacktweaks.config.CfgModpack;
import io.enderdev.endermodpacktweaks.config.CfgTweaks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import zone.rong.mixinbooter.IEarlyMixinLoader;

@IFMLLoadingPlugin.Name(value="EnderModpackTweaksCore")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=-2147483648)
public class EMTLoadingPlugin
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static final boolean isClient = FMLLaunchHandler.side().isClient();
    private static final Map<String, BooleanSupplier> serversideMixinConfigs = ImmutableMap.copyOf((Map)new HashMap<String, BooleanSupplier>(){});
    private static final Map<String, BooleanSupplier> commonMixinConfigs = ImmutableMap.copyOf((Map)new HashMap<String, BooleanSupplier>(){
        {
            this.put("mixins/mixins.emt.minecraft.dragonfightmanager.json", () -> CfgMinecraft.DRAGON.enable);
            this.put("mixins/mixins.emt.minecraft.endgateway.json", () -> CfgMinecraft.END_GATEWAY.enable);
            this.put("mixins/mixins.emt.minecraft.endpodium.json", () -> CfgMinecraft.END_PODIUM.enable);
            this.put("mixins/mixins.emt.minecraft.netherportal.json", () -> CfgMinecraft.NETHER_PORTAL.enable);
            this.put("mixins/mixins.emt.minecraft.obsidianspike.json", () -> CfgMinecraft.OBSIDIAN_SPIKE.enable);
            this.put("mixins/mixins.emt.minecraft.endisland.json", () -> CfgMinecraft.END_ISLAND.enable);
            this.put("mixins/mixins.emt.minecraft.bossproof.json", () -> CfgFeatures.BOSS_PROOF_BLOCKS.enable);
            this.put("mixins/mixins.emt.minecraftforge.json", () -> CfgModpack.STARTUP_TIMER.enable);
            this.put("mixins/mixins.emt.minecraft.window.json", () -> CfgModpack.CUSTOMIZATION.enable);
            this.put("mixins/mixins.emt.minecraft.credits.json", () -> CfgFeatures.CUSTOM_CREDITS.enable || CfgModpack.CUSTOMIZATION.removeJavaEdition);
            this.put("mixins/mixins.emt.minecraft.wither.json", () -> CfgMinecraft.WITHER.enable);
            this.put("mixins/mixins.emt.minecraft.golem.json", () -> CfgMinecraft.GOLEM.enable);
        }
    });
    private static final Map<String, BooleanSupplier> clientsideMixinConfigs = ImmutableMap.copyOf((Map)new HashMap<String, BooleanSupplier>(){
        {
            this.put("mixins/mixins.emt.minecraft.bossbar.json", () -> CfgFeatures.BOSS_BAR.enable);
            this.put("mixins/mixins.emt.minecraft.client.json", () -> true);
            this.put("mixins/mixins.emt.fancymenu.json", () -> CfgTweaks.FANCY_MENU.enable);
        }
    });

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        try {
            Field f_transformerExceptions = LaunchClassLoader.class.getDeclaredField("transformerExceptions");
            f_transformerExceptions.setAccessible(true);
            Set transformerExceptions = (Set)f_transformerExceptions.get(Launch.classLoader);
            transformerExceptions.remove("tyra314.toolprogression");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAccessTransformerClass() {
        return "io.enderdev.endermodpacktweaks.core.EMTTransformer";
    }

    public List<String> getMixinConfigs() {
        ArrayList<String> configs = new ArrayList<String>();
        if (isClient) {
            configs.addAll(clientsideMixinConfigs.keySet());
        } else {
            configs.addAll(serversideMixinConfigs.keySet());
        }
        configs.addAll(commonMixinConfigs.keySet());
        return configs;
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        BooleanSupplier sidedSupplier = isClient ? clientsideMixinConfigs.get(mixinConfig) : null;
        BooleanSupplier commonSupplier = commonMixinConfigs.get(mixinConfig);
        return sidedSupplier != null ? sidedSupplier.getAsBoolean() : commonSupplier == null || commonSupplier.getAsBoolean();
    }
}

