/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.core;

import com.cleanroommc.assetmover.AssetMoverAPI;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import io.enderdev.endermodpacktweaks.EnderModpackTweaks;
import io.enderdev.endermodpacktweaks.config.CfgModpack;
import io.enderdev.endermodpacktweaks.utils.EmtFile;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraftforge.fml.common.Loader;

public final class EMTAssetMover {
    private EMTAssetMover() {
        throw new IllegalStateException("Utility class");
    }

    public static void getInternalAssets() {
        List assets = null;
        try {
            Gson gson = new Gson();
            InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(Loader.class.getResourceAsStream(String.format("/assets/%s/assetmover.json", "endermodpacktweaks"))));
            assets = (List)gson.fromJson((Reader)reader, new TypeToken<List<AssetLocation>>(){}.getType());
        }
        catch (Exception e) {
            EnderModpackTweaks.LOGGER.error("Failed to read assetmover.json", (Throwable)e);
        }
        EMTAssetMover.acquireAssets(assets);
    }

    public static void getExternalAssets() {
        HashMap<String, InputStream> externalAssets = new HashMap<String, InputStream>();
        Arrays.stream(CfgModpack.CUSTOM_ASSETS.assetMoverJsonFiles).forEach(path -> {
            try {
                InputStream inputStream = EmtFile.getInputStream(path);
                externalAssets.put((String)path, inputStream);
            }
            catch (Exception e) {
                EnderModpackTweaks.LOGGER.error("Error loading JSON file from path: {}", path, (Object)e);
            }
        });
        externalAssets.forEach((path, inputStream) -> {
            List assets = null;
            try {
                Gson gson = new Gson();
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
                assets = (List)gson.fromJson((Reader)reader, new TypeToken<List<AssetLocation>>(){}.getType());
            }
            catch (Exception e) {
                EnderModpackTweaks.LOGGER.error("Failed to read asset file: {}", path, (Object)e);
            }
            EMTAssetMover.acquireAssets(assets);
        });
    }

    private static void acquireAssets(List<AssetLocation> assets) {
        if (assets == null || assets.isEmpty()) {
            EnderModpackTweaks.LOGGER.error("No assets found!");
            return;
        }
        EnderModpackTweaks.LOGGER.info("Parsed assets files. Found {} asset sources.", (Object)assets.size());
        assets.forEach(asset -> {
            Object2ObjectOpenHashMap textureMap = new Object2ObjectOpenHashMap();
            asset.getTextures().forEach(arg_0 -> EMTAssetMover.lambda$null$2((Map)textureMap, arg_0));
            if (asset.getSource().equals("minecraft") && asset.getVersion() != null) {
                try {
                    EnderModpackTweaks.LOGGER.info("Using Minecraft version: {}", (Object)asset.getVersion());
                    AssetMoverAPI.fromMinecraft((String)asset.getVersion(), (Map)textureMap);
                }
                catch (Exception e) {
                    EnderModpackTweaks.LOGGER.fatal("Failed to get assets for version {} with {}", (Object)asset.getVersion(), (Object)e);
                }
            } else if (asset.getSource().equals("curseforge") && ((AssetLocation)asset).projectID != 0 && ((AssetLocation)asset).fileID != 0) {
                try {
                    EnderModpackTweaks.LOGGER.info("Using CurseForge project ID: {}, file ID: {}", (Object)asset.getProjectID(), (Object)asset.getFileID());
                    AssetMoverAPI.fromCurseForgeMod((String)asset.getProjectID(), (String)asset.getFileID(), (Map)textureMap);
                }
                catch (Exception e) {
                    EnderModpackTweaks.LOGGER.fatal("Failed to get assets for curseforge project {} from version {} with {}", (Object)asset.getProjectID(), (Object)asset.getFileID(), (Object)e);
                }
            } else if (asset.getSource().equals("url") && asset.getUrl() != null) {
                try {
                    EnderModpackTweaks.LOGGER.info("Using URL: {}", (Object)asset.getUrl());
                    AssetMoverAPI.fromUrlFile((String)asset.getUrl(), (Map)textureMap);
                }
                catch (Exception e) {
                    EnderModpackTweaks.LOGGER.fatal("Failed to get assets from URL {} with {}", (Object)asset.getUrl(), (Object)e);
                }
            } else {
                EnderModpackTweaks.LOGGER.error("Invalid asset source: {}", (Object)asset.getSource());
            }
        });
    }

    private static /* synthetic */ void lambda$null$2(Map textureMap, Texture texture) {
        textureMap.put(texture.getOriginal(), texture.getNewPath());
    }

    private static class Texture {
        private String original;
        @SerializedName(value="new")
        private String newPath;

        private Texture() {
        }

        public String getOriginal() {
            return this.original;
        }

        public String getNewPath() {
            return this.newPath;
        }
    }

    private static class AssetLocation {
        private String source;
        private String version;
        private String url;
        private int projectID;
        private int fileID;
        private List<Texture> textures;

        private AssetLocation() {
        }

        public String getSource() {
            return this.source;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }

        public String getProjectID() {
            return "" + this.projectID;
        }

        public String getFileID() {
            return "" + this.fileID;
        }

        public List<Texture> getTextures() {
            return this.textures;
        }
    }
}

