/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.config;

import com.cleanroommc.configanytime.ConfigAnytime;
import io.enderdev.endermodpacktweaks.config.EnumGuiPosition;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="endermodpacktweaks", name="endermodpacktweaks/modpack", category="")
public class CfgModpack {
    @Config.Name(value="modpack")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.modpack")
    @Config.Comment(value={"Made with <3 by Ender-Development"})
    public static final Modpack MODPACK = new Modpack();
    @Config.Name(value="customization")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.customization")
    @Config.Comment(value={"Customize the game window."})
    public static final Customization CUSTOMIZATION = new Customization();
    @Config.Name(value="crash_info")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.crash_info")
    @Config.Comment(value={"Add additional modpack information to the crash report."})
    public static final CrashInfo CRASH_INFO = new CrashInfo();
    @Config.Name(value="custom_assets")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.custom_assets")
    @Config.Comment(value={"Utilize the AssetMover API to move assets from CurseForge or other Minecraft versions to your modpack."})
    public static final CustomAssets CUSTOM_ASSETS = new CustomAssets();
    @Config.Name(value="default_server")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.default_server")
    @Config.Comment(value={"Add a default server to your modpack."})
    public static final DefaultServer DEFAULT_SERVER = new DefaultServer();
    @Config.Name(value="options_menu_buttons")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.options_menu_buttons")
    @Config.Comment(value={"Link everything related to the modpack in the options and main menu."})
    public static final OptionsMenuButtons OPTIONS_MENU_BUTTONS = new OptionsMenuButtons();
    @Config.Name(value="pack_updater")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.pack_updater")
    @Config.Comment(value={"Check a JSON file from a given URL and compare it with the current modpack version."})
    public static final PackUpdater PACK_UPDATER = new PackUpdater();
    @Config.Name(value="server_message")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.server_message")
    @Config.Comment(value={"Similar to something that Nomifactory came up with."})
    public static final ServerMessage SERVER_MESSAGE = new ServerMessage();
    @Config.Name(value="startup_timer")
    @Config.LangKey(value="cfg.endermodpacktweaks.modpack.startup_timer")
    @Config.Comment(value={"Display how long it takes for your pack to load."})
    public static final StartupTimer STARTUP_TIMER = new StartupTimer();

    static {
        ConfigAnytime.register(CfgModpack.class);
    }

    @Mod.EventBusSubscriber(modid="endermodpacktweaks")
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("endermodpacktweaks")) {
                ConfigManager.sync((String)"endermodpacktweaks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class StartupTimer {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Startup Timer")
        @Config.Comment(value={"Enable the Startup Timer feature and display the pack load time."})
        public boolean enable = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[02] Timer History Size")
        @Config.Comment(value={"How many loading times should be kept in the history?"})
        public int sizeHistory = 10;
        @Config.Name(value="[03] Display Startup Time")
        @Config.Comment(value={"Should the startup time be displayed in the main menu?"})
        public boolean display = true;
        @Config.Name(value="[04] Display X-Offset")
        @Config.Comment(value={"The x offset of the time display."})
        public int xOffset = 0;
        @Config.Name(value="[05] Display Y-Offset")
        @Config.Comment(value={"The y offset of the time display."})
        public int yOffset = 10;
        @Config.Name(value="[06] Display Color")
        @Config.Comment(value={"The color of the time display. Format: #RRGGBAA"})
        public String color = "#FFFFFFFF";
        @Config.Name(value="[06] Default Startup Time")
        @Config.Comment(value={"The default startup time before the measuring took over. In milliseconds, 0 to disable."})
        public int defaultTime = 0;
        @Config.RequiresMcRestart
        @Config.Name(value="[07] Time format")
        @Config.Comment(value={"Customize how the start time is displayed", "[minutes] - will be replaced with the minutes it took for the pack to start", "[seconds] - will be replaced with the seconds it took for the pack to start"})
        public String timeFormat = "[minutes]m [seconds]s";
        @Config.Name(value="[08] Default Display Location")
        @Config.Comment(value={"Where the Startup Time String should anchored to."})
        public EnumGuiPosition anchor = EnumGuiPosition.TOP_CENTER;
    }

    public static class ServerMessage {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Server Message")
        @Config.Comment(value={"Enable the Server Message feature. This adds a message to the server console when the server starts."})
        public boolean enable = false;
        @Config.Name(value="[02] Server Name")
        @Config.Comment(value={"The name of the server. Only used if 'Enable Server Message' is enabled."})
        public String serverName = "Minecraft";
    }

    public static class PackUpdater {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Pack Updater")
        @Config.Comment(value={"Enable the Pack Update Check feature. Check an external json url if there is a newer modpack version available."})
        public boolean enable = false;
        @Config.Name(value="[02] Version JSON Url")
        @Config.Comment(value={"The URL to the JSON file that contains the newest version information."})
        public String jsonUrl = "";
    }

    public static class OptionsMenuButtons {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Options Menu Buttons")
        @Config.Comment(value={"Enable the Options Menu Buttons feature. This adds additional buttons to the options menu."})
        public boolean enable = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[02] Custom Main Menu Integration")
        @Config.Comment(value={"Show the buttons on Custom Main Menu menus."})
        public boolean cmmIntegration = false;
        @Config.Name(value="changelog_button")
        @Config.LangKey(value="cfg.endermodpacktweaks.modpack.options_menu_buttons.changelog")
        public final OptionsMenuButton CHANGELOG_BUTTON = new OptionsMenuButton("Changelog", "");
        @Config.Name(value="donation_button")
        @Config.LangKey(value="cfg.endermodpacktweaks.modpack.options_menu_buttons.donation")
        public final OptionsMenuButton DONATION_BUTTON = new OptionsMenuButton("Donation", "");
        @Config.Name(value="github_button")
        @Config.LangKey(value="cfg.endermodpacktweaks.modpack.options_menu_buttons.github")
        public final OptionsMenuButton GITHUB_BUTTON = new OptionsMenuButton("GitHub", "");
        @Config.Name(value="discord_button")
        @Config.LangKey(value="cfg.endermodpacktweaks.modpack.options_menu_buttons.discord")
        public final OptionsMenuButton DISCORD_BUTTON = new OptionsMenuButton("Discord", "");
        @Config.Name(value="twitch_button")
        @Config.LangKey(value="cfg.endermodpacktweaks.modpack.options_menu_buttons.twitch")
        public final OptionsMenuButton TWITCH_BUTTON = new OptionsMenuButton("Twitch", "");
        @Config.Name(value="youtube_button")
        @Config.LangKey(value="cfg.endermodpacktweaks.modpack.options_menu_buttons.youtube")
        public final OptionsMenuButton YOUTUBE_BUTTON = new OptionsMenuButton("Youtube", "");

        public static class OptionsMenuButton {
            @Config.Name(value="[01] Enable Button")
            public boolean enable = false;
            @Config.Name(value="[02] Button Text")
            public String buttonText;
            @Config.Name(value="[03] Button URL")
            public String url;

            OptionsMenuButton(String name, String url) {
                this.buttonText = name;
                this.url = url;
            }
        }
    }

    public static class DefaultServer {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Default Server")
        @Config.Comment(value={"Allows adding a default server."})
        public boolean enable = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[02] Server Name")
        @Config.Comment(value={"The name of the dedicated server to add."})
        public String serverName = "Localhost";
        @Config.RequiresMcRestart
        @Config.Name(value="[02] Server IP")
        @Config.Comment(value={"The IP of the dedicated server to add."})
        public String serverIp = "127.0.0.1:25555";
    }

    public static class CustomAssets {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Custom Assets")
        @Config.Comment(value={"Enable the Custom Assets feature."})
        public boolean enable = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[02] AssetMover JSON files")
        @Config.Comment(value={"List of paths to JSON files that contain the asset information. All paths are relative to the instance folder."})
        public String[] assetMoverJsonFiles = new String[0];
    }

    public static class CrashInfo {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Crash Info")
        @Config.Comment(value={"Enable the Crash Info feature. This adds additional information to the crash report.", "It tries to read the information from the manifest file of the modpack.", "Alternatively, you can provide the information in the config file."})
        public boolean enable = true;
        @Config.RequiresMcRestart
        @Config.Name(value="[02] Read from Manifest")
        @Config.Comment(value={"Read the information from the manifest file of the modpack.", "This will override the config values."})
        public boolean readFromManifest = true;
    }

    public static class Customization {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Window Customization")
        @Config.Comment(value={"Customize the window of the game."})
        public boolean enable = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[02] Change window title")
        @Config.Comment(value={"Set the window title to the modpack name"})
        public boolean windowTitle = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[03] Window title format")
        @Config.Comment(value={"Customize how the window title is displayed", "Format: <lang_key>;<your_title>", "[name] - will be replaced by the modpack name", "[version] - will be replaced by the modpack version", "[author] - will be replaced by the modpack author"})
        public String[] windowTitleFormat = new String[]{"en_us;[name] ([version]) by [author]"};
        @Config.RequiresMcRestart
        @Config.Name(value="[04] Replace window icon")
        @Config.Comment(value={"Replace the default icon with a custom one."})
        public boolean windowIcon = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[05] Window icon path")
        @Config.Comment(value={"Override the path to the icon."})
        public String windowIconPath = "config/endermodpacktweaks/icon.png";
        @Config.RequiresMcRestart
        @Config.Name(value="[06] Remove 'Java Edition' from Main Menu")
        @Config.Comment(value={"Remove the 'Java Edition' text from the main menu."})
        public boolean removeJavaEdition = false;
    }

    public static class Modpack {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Modpack Name")
        @Config.Comment(value={"The name of the modpack."})
        public String modpackName = "";
        @Config.RequiresMcRestart
        @Config.Name(value="[02] Modpack Version")
        @Config.Comment(value={"The version of the modpack."})
        public String modpackVersion = "";
        @Config.RequiresMcRestart
        @Config.Name(value="[03] Modpack Author")
        @Config.Comment(value={"The author of the modpack."})
        public String modpackAuthor = "";
        @Config.RequiresMcRestart
        @Config.Name(value="[04] Modpack URL")
        @Config.Comment(value={"A URL for the pack download."})
        public String modpackDownload = "";
    }
}

