/*
 * Decompiled with CFR 0.152.
 */
package io.enderdev.endermodpacktweaks.config;

import com.cleanroommc.configanytime.ConfigAnytime;
import io.enderdev.endermodpacktweaks.config.EnumDifficulty;
import io.enderdev.endermodpacktweaks.config.EnumGamemode;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="endermodpacktweaks", name="endermodpacktweaks/minecraft", category="")
public class CfgMinecraft {
    @Config.Name(value="client")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.client")
    @Config.Comment(value={"Disable various Client elements."})
    public static final Client CLIENT = new Client();
    @Config.Name(value="default_gamerule")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.default_gamerule")
    @Config.Comment(value={"Set gamerules for new worlds."})
    public static final DefaultGamerule DEFAULT_GAMERULE = new DefaultGamerule();
    @Config.Name(value="dragon")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.dragon")
    @Config.Comment(value={"Tweaks for the initial Dragon Fight."})
    public static final Dragon DRAGON = new Dragon();
    @Config.Name(value="end_gateway")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.end_gateway")
    @Config.Comment(value={"Tweak the End Gateway to your liking."})
    public static final EndGateway END_GATEWAY = new EndGateway();
    @Config.Name(value="end_island")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.end_island")
    @Config.Comment(value={"Tweak the End Island to your liking."})
    public static final EndIsland END_ISLAND = new EndIsland();
    @Config.Name(value="end_portal")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.end_portal")
    @Config.Comment(value={"Tweak the End Portal to your liking."})
    public static final EndPodium END_PODIUM = new EndPodium();
    @Config.Name(value="golem")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.golem")
    @Config.Comment(value={"Tweaks for the Golem Spawning Mechanic."})
    public static final Golem GOLEM = new Golem();
    @Config.Name(value="inventory_crafting")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.inventory_crafting")
    @Config.Comment(value={"Tweak the Inventory Crafting mechanic."})
    public static final InventoryCrafting INVENTORY_CRAFTING = new InventoryCrafting();
    @Config.Name(value="obsidian_spike")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.obsidian_spike")
    @Config.Comment(value={"Tweak the Obsidian Spikes in the End."})
    public static final ObsidianSpike OBSIDIAN_SPIKE = new ObsidianSpike();
    @Config.Name(value="nether_portal")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.nether_portal")
    @Config.Comment(value={"Tweak the Nether Portal to your liking."})
    public static final NetherPortal NETHER_PORTAL = new NetherPortal();
    @Config.Name(value="wither")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.wither")
    @Config.Comment(value={"Tweaks for the Wither Boss."})
    public static final Wither WITHER = new Wither();
    @Config.Name(value="world")
    @Config.LangKey(value="cfg.endermodpacktweaks.minecraft.world")
    @Config.Comment(value={"Tweaks for world generation and world settings."})
    public static final World WORLD = new World();

    static {
        ConfigAnytime.register(CfgMinecraft.class);
    }

    @Mod.EventBusSubscriber(modid="endermodpacktweaks")
    public static class ConfigEventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("endermodpacktweaks")) {
                ConfigManager.sync((String)"endermodpacktweaks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class World {
        @Config.Name(value="[01] Enable World Tweaks")
        @Config.Comment(value={"Enable world tweaks"})
        public boolean enable = false;
        @Config.Name(value="[02] Force Difficulty")
        @Config.Comment(value={"Force the difficulty to a specific value"})
        public boolean forceDifficulty = false;
        @Config.Name(value="[03] Forced Difficulty")
        @Config.Comment(value={"The difficulty the world should be forced to"})
        public EnumDifficulty difficulty = EnumDifficulty.NORMAL;
        @Config.Name(value="[04] Lock Difficulty")
        @Config.Comment(value={"Prevent players from changing the difficulty"})
        public boolean lock = false;
        @Config.Name(value="[05] Force Gamemode")
        @Config.Comment(value={"Force the gamemode to a specific value"})
        public boolean forceGamemode = false;
        @Config.Name(value="[06] Forced Gamemode")
        @Config.Comment(value={"The gamemode the world should be forced to"})
        public EnumGamemode gamemode = EnumGamemode.SURVIVAL;
        @Config.Name(value="[07] Allow Cheats")
        @Config.Comment(value={"Allow cheats in the world"})
        public boolean cheats = true;
        @Config.Name(value="[08] Hardcore Mode")
        @Config.Comment(value={"Enable hardcore mode"})
        public boolean hardcore = false;
    }

    public static class Wither {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Wither Tweaks")
        @Config.Comment(value={"Enable tweaks for the Wither Boss."})
        public boolean enable = false;
        @Config.Name(value="[02] Disable building the Wither")
        @Config.Comment(value={"Disallow players to build the Wither Boss."})
        public boolean disableBuilding = false;
    }

    public static class NetherPortal {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Nether Portal Tweaks")
        @Config.Comment(value={"Enable Nether Portal Tweaks"})
        public boolean enable = false;
        @Config.Name(value="[02] Nether Portal Creation")
        @Config.Comment(value={"Allow Nether Portal Creation"})
        public boolean canBeCreated = true;
        @Config.Name(value="[03] End Nether Portal")
        @Config.Comment(value={"Allow Nether Portal Creation in the End"})
        public boolean canBeCreatedInEnd = false;
        @Config.Name(value="[04] No Entity Traverse")
        @Config.Comment(value={"Disallow Entities to enter Nether Portals"})
        public boolean disallowTraverse = false;
    }

    public static class ObsidianSpike {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Obsidian Spike Tweaks")
        @Config.Comment(value={"This tweak allows you to customize the Obsidian Spike.", "Obsidian Spikes are the large Pillars of Obsidian that generate in the End.", "You can change the blocks that make up the Obsidian Spike."})
        public boolean enable = false;
        @Config.Name(value="[02] Replace Obsidian")
        @Config.Comment(value={"Replace the obsidian block in the Obsidian Spike."})
        public String obsidian = "minecraft:obsidian";
        @Config.Name(value="[03] Replace Air")
        @Config.Comment(value={"Replace the air block in the Obsidian Spike."})
        public String air = "minecraft:air";
        @Config.Name(value="[04] Replace Iron Bars")
        @Config.Comment(value={"Replace the iron bars block in the Obsidian Spike."})
        public String ironBars = "minecraft:iron_bars";
        @Config.Name(value="[05] Replace Obsidian Spike")
        @Config.Comment(value={"Replace the obsidian spike with a new structure.", "!!! NOT YET IMPLEMENTED !!!"})
        public boolean replaceSpike = false;
        @Config.Name(value="[06] Obsidian Spike Structure")
        @Config.Comment(value={"The structure that replaces the obsidian spike.", "!!! NOT YET IMPLEMENTED !!!"})
        public String spikeStructure = "endermodpacktweaks:obsidian_spike";
        @Config.Name(value="[07] Obsidian Spike Distance from End Portal")
        @Config.Comment(value={"The distance the obsidian spike is placed from the end portal."})
        @Config.RangeDouble(min=42.0, max=128.0)
        public double spikeDistance = 42.0;
        @Config.Name(value="[08] Obsidian Spike Base Height")
        @Config.Comment(value={"The base height of the obsidian spike."})
        @Config.RangeInt(min=10, max=255)
        public int spikeHeight = 76;
        @Config.Name(value="[09] Obsidian Spike Base Radius")
        @Config.Comment(value={"The base radius of the obsidian spike."})
        @Config.RangeInt(min=2, max=10)
        public int spikeRadius = 2;
        @Config.Name(value="[10] Obsidian Spike Count")
        @Config.Comment(value={"The number of obsidian spikes around the end portal."})
        @Config.RangeInt(min=1, max=32)
        public int spikeCount = 10;
        @Config.Name(value="[11] Obsidian Spike Guard")
        @Config.Comment(value={"Should the obsidian spikes be always guarded?"})
        public boolean alwaysGuarded = false;
        @Config.Name(value="[12] Obsidian Spike Guard Chance")
        @Config.Comment(value={"The 1 in x chance that the obsidian spikes are guarded.", "Set to 0 to disable guarded spikes altogether."})
        @Config.RangeInt(min=0, max=100)
        public int guardChance = 5;
    }

    public static class InventoryCrafting {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Inventory Crafting Tweaks")
        @Config.Comment(value={"Enable tweaks for the inventory crafting."})
        public boolean enable = false;
        @Config.Name(value="[02] Disable Crafting Grid")
        @Config.Comment(value={"Disable the crafting grid in the player inventory."})
        public boolean disableCraftingGrid = false;
        @Config.Name(value="[03] Unlock via Game Stage")
        @Config.Comment(value={"Unlock the crafting grid via a game stage."})
        public String unlockGameStage = "unlock_crafting_grid";
    }

    public static class Golem {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Golem Tweaks")
        @Config.Comment(value={"Enable tweaks for the Golem Spawning Mechanic."})
        public boolean enable = false;
        @Config.Name(value="[02] Disable Iron Golem Spawning")
        @Config.Comment(value={"Disable the spawning of Iron Golems."})
        public boolean disableIronGolem = false;
        @Config.Name(value="[03] Disable Snow Golem Spawning")
        @Config.Comment(value={"Disable the spawning of Snow Golems."})
        public boolean disableSnowGolem = false;
    }

    public static class EndPodium {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable End Podium Tweaks")
        @Config.Comment(value={"This tweak allows you to customize the End Portal.", "You can change the blocks that make up the End Portal."})
        public boolean enable = false;
        @Config.Name(value="[02] Replace Bedrock")
        @Config.Comment(value={"Replace the bedrock block in the End Portal.", "Replacing the bedrock makes it impossible to respawn the Ender Dragon."})
        public String bedrock = "minecraft:bedrock";
        @Config.Name(value="[03] Replace End Stone")
        @Config.Comment(value={"Replace the end stone block in the End Portal."})
        public String endStone = "minecraft:end_stone";
        @Config.Name(value="[04] Replace Torch")
        @Config.Comment(value={"Replace the torch block in the End Portal."})
        public String torch = "minecraft:torch";
        @Config.Name(value="[05] Replace Air")
        @Config.Comment(value={"Replace the air block in the End Portal."})
        public String air = "minecraft:air";
        @Config.Name(value="[06] Replace End Portal")
        @Config.Comment(value={"Replace the end portal with a new structure."})
        public boolean replacePortal = false;
        @Config.Name(value="[07] End Portal Structure (Inactive)")
        @Config.Comment(value={"The structure that replaces the inactive end portal."})
        public String portalStructure = "endermodpacktweaks:end_portal";
        @Config.Name(value="[08] End Portal Structure (Active)")
        @Config.Comment(value={"The structure that replaces the active end portal."})
        public String activePortalStructure = "endermodpacktweaks:end_portal_active";
    }

    public static class EndIsland {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable End Island Tweaks")
        @Config.Comment(value={"This tweak allows you to customize the End Island.", "You can change the blocks that make up the End Island."})
        public boolean enable = false;
        @Config.Name(value="[02] Island Size")
        @Config.Comment(value={"Increase the size of the End Island."})
        @Config.RangeInt(min=0, max=32)
        public int islandSize = 4;
        @Config.Name(value="[03] Replace End Stone")
        @Config.Comment(value={"Replace the end stone block in the End Island."})
        public String endStone = "minecraft:end_stone";
    }

    public static class EndGateway {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable End Gateway Tweaks")
        @Config.Comment(value={"This tweak allows you to customize the End Gateway.", "You can change the blocks that make up the End Gateway."})
        public boolean enable = false;
        @Config.Name(value="[02] Replace Air")
        @Config.Comment(value={"Replace the air block in the End Gateway."})
        public String air = "minecraft:air";
        @Config.Name(value="[03] Replace Bedrock")
        @Config.Comment(value={"Replace the bedrock block in the End Gateway."})
        public String bedrock = "minecraft:bedrock";
        @Config.Name(value="[04] Replace End Gateway")
        @Config.Comment(value={"Replace the end gateway with a new structure."})
        public boolean replaceGateway = false;
        @Config.Name(value="[05] End Gateway Structure")
        @Config.Comment(value={"The structure that replaces the end gateway."})
        public String gatewayStructure = "endermodpacktweaks:end_gateway";
        @Config.Name(value="[06] End Gateway Distance from End Portal")
        @Config.Comment(value={"The distance the end gateway is placed from the end portal."})
        @Config.RangeDouble(min=96.0, max=256.0)
        public double gatewayDistance = 96.0;
        @Config.Name(value="[07] End Gateway Height")
        @Config.Comment(value={"The height the end gateway is placed at."})
        @Config.RangeInt(min=0, max=255)
        public int gatewayHeight = 75;
    }

    public static class Dragon {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Dragon Tweaks")
        @Config.Comment(value={"Allow you to customize the Ender Dragon Fight Mechanic."})
        public boolean enable = false;
        @Config.Name(value="[02] Kill Dragon")
        @Config.Comment(value={"This tweak kills the first dragon when the player enters the end for the first time.", "Useful for modpacks that want to make the dragon fight non-free."})
        public boolean killDragon = false;
        @Config.Name(value="[03] Drop Dragon Egg")
        @Config.Comment(value={"Should the auto killed dragon drop the dragon egg?"})
        public boolean dropEgg = false;
        @Config.Name(value="[04] Replace the first Dragon Egg")
        @Config.Comment(value={"Replace the dragon egg block with another block."})
        public String eggBlock = "minecraft:dragon_egg";
        @Config.Name(value="[05] Create End Portal")
        @Config.Comment(value={"Should the auto killed dragon create the end portal back to the overworld?"})
        public boolean createPortal = false;
        @Config.Name(value="[06] Create End Gateway")
        @Config.Comment(value={"Should the auto killed dragon create an end gateway?"})
        public boolean createGateway = false;
        @Config.Name(value="[07] Multiple Dragon Egg")
        @Config.Comment(value={"Should every dragon drop an egg?"})
        public boolean multipleEgg = false;
        @Config.Name(value="[08] Disable End Portal")
        @Config.Comment(value={"Should spawning the end portal when killing the dragon be disabled?"})
        public boolean disablePortal = false;
        @Config.Name(value="[09] Disable End Gateway")
        @Config.Comment(value={"Should spawning the end gateway when killing the dragon be disabled?"})
        public boolean disableGateway = false;
    }

    public static class DefaultGamerule {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Default Gamerules")
        @Config.Comment(value={"Allow you to set default gamerules."})
        public boolean enable = false;
        @Config.RequiresWorldRestart
        @Config.Name(value="[02] Default Gamerules")
        @Config.Comment(value={"Set the default state of gamerules.", "Format: <gamerule_name>;<value>", "Example: 'keepInventory;true'", "Example: 'randomTickSpeed;3"})
        public String[] gamerules = new String[0];
    }

    public static class Client {
        @Config.RequiresMcRestart
        @Config.Name(value="[01] Enable Client Tweaks")
        @Config.Comment(value={"Enable tweaks for the client."})
        public boolean enable = false;
        @Config.RequiresWorldRestart
        @Config.Name(value="[02] Disable Item Names")
        @Config.Comment(value={"This tweak disables the rendering of item names above the hotbar."})
        public boolean disableItemNames = false;
        @Config.RequiresMcRestart
        @Config.Name(value="[03] Max Render Distance")
        @Config.Comment(value={"Set the maximum render distance of the client.", "I'm not responsible for any performance issues this may cause.", "nor if your pc goes up in flames. (The Minecraft default is 16)"})
        @Config.RangeInt(min=2, max=4096)
        public int maxRenderDistance = 32;
        @Config.Name(value="[04] Hide Name Tags")
        @Config.Comment(value={"Hide the name tags of entities."})
        public boolean hideNameTags = false;
        @Config.Name(value="[05] Disable Auto Jump")
        @Config.Comment(value={"Disable the auto jump feature. It never should have been added in the first place."})
        public boolean disableAutoJump = false;
        @Config.Name(value="[06] Additional Master Volume")
        @Config.Comment(value={"Adds an additional master volume slider to the main options menu."})
        public boolean additionalMasterVolume = false;
        @Config.Name(value="[07] Hide Potion Icons")
        @Config.Comment(value={"Hide the potion icons in the top right corner."})
        public boolean hidePotionIcons = false;
        @Config.Name(value="[08] Hide Crosshair")
        @Config.Comment(value={"Hide the crosshair."})
        public boolean hideCrosshair = false;
        @Config.Name(value="[09] Hide Armor Bar")
        @Config.Comment(value={"Hide the armor bar."})
        public boolean hideArmorBar = false;
        @Config.Name(value="[10] Hide Health Bar")
        @Config.Comment(value={"Hide the health bar."})
        public boolean hideHealthBar = false;
        @Config.Name(value="[11] Hide Hunger Bar")
        @Config.Comment(value={"Hide the hunger bar."})
        public boolean hideHungerBar = false;
        @Config.Name(value="[12] Hide Experience Bar")
        @Config.Comment(value={"Hide the experience bar."})
        public boolean hideExperienceBar = false;
        @Config.Name(value="[13] Hide Air Bar")
        @Config.Comment(value={"Hide the air bar."})
        public boolean hideAirBar = false;
        @Config.Name(value="[14] Disable FOV Change")
        @Config.Comment(value={"Disable the FOV change."})
        public boolean disableFovChange = false;
    }
}

