/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiEnchanter;
import cofh.thermalexpansion.gui.container.machine.ContainerEnchanter;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEnchanter
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.ENCHANTER.getMetadata();
    public static int basePower = 20;
    private EnchanterManager.EnchanterRecipe curRecipe;
    private int inputTrackerPrimary;
    private int inputTrackerSecondary;
    private int outputTracker;
    public boolean lockPrimary = true;
    private FluidTankCore tank = new FluidTankCore(10000);
    protected boolean augmentEmpowered;

    public static void initialize() {
        TileEnchanter.SIDE_CONFIGS[TileEnchanter.TYPE] = new SideConfig();
        TileEnchanter.SIDE_CONFIGS[TileEnchanter.TYPE].numConfig = 7;
        TileEnchanter.SIDE_CONFIGS[TileEnchanter.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {0}, {1}, {0, 1, 2}, {0, 1, 2}};
        TileEnchanter.SIDE_CONFIGS[TileEnchanter.TYPE].sideTypes = new int[]{0, 1, 4, 5, 6, 7, 8};
        TileEnchanter.SIDE_CONFIGS[TileEnchanter.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileEnchanter.ALT_SIDE_CONFIGS[TileEnchanter.TYPE] = new SideConfig();
        TileEnchanter.ALT_SIDE_CONFIGS[TileEnchanter.TYPE].numConfig = 2;
        TileEnchanter.ALT_SIDE_CONFIGS[TileEnchanter.TYPE].slotGroups = new int[][]{new int[0], {0, 1}, {2}, {0}, {1}, {0, 1, 2}, {0, 1, 2}};
        TileEnchanter.ALT_SIDE_CONFIGS[TileEnchanter.TYPE].sideTypes = new int[]{0, 7};
        TileEnchanter.ALT_SIDE_CONFIGS[TileEnchanter.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileEnchanter.SLOT_CONFIGS[TileEnchanter.TYPE] = new SlotConfig();
        TileEnchanter.SLOT_CONFIGS[TileEnchanter.TYPE].allowInsertionSlot = new boolean[]{true, true, false, false};
        TileEnchanter.SLOT_CONFIGS[TileEnchanter.TYPE].allowExtractionSlot = new boolean[]{false, false, true, false};
        TileEnchanter.VALID_AUGMENTS[TileEnchanter.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineEnchanterEmpowered");
        TileEnchanter.LIGHT_VALUES[TileEnchanter.TYPE] = 12;
        GameRegistry.registerTileEntity(TileEnchanter.class, (String)"thermalexpansion:machine_enchanter");
        TileEnchanter.config();
    }

    public static void config() {
        String category = "Machine.Enchanter";
        BlockMachine.enable[TileEnchanter.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for an Arcane Ensorcellator. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TileEnchanter.ENERGY_CONFIGS[TileEnchanter.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileEnchanter() {
        this.inventory = new ItemStack[4];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidExperience);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getMaxInputSlot() {
        return 1;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.inventory[1].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.tank.getFluidAmount() < this.curRecipe.getExperience()) {
            return false;
        }
        if (this.curRecipe.getType() == EnchanterManager.Type.EMPOWERED && !this.augmentEmpowered) {
            return false;
        }
        if (EnchanterManager.isRecipeReversed(this.inventory[0], this.inventory[1]) ? this.curRecipe.getPrimaryInput().func_190916_E() > this.inventory[1].func_190916_E() || this.curRecipe.getSecondaryInput().func_190916_E() > this.inventory[0].func_190916_E() : this.curRecipe.getPrimaryInput().func_190916_E() > this.inventory[0].func_190916_E() || this.curRecipe.getSecondaryInput().func_190916_E() > this.inventory[1].func_190916_E()) {
            return false;
        }
        ItemStack output = this.curRecipe.getOutput();
        return this.inventory[2].func_190926_b() || ItemHelper.itemsIdentical((ItemStack)this.inventory[2], (ItemStack)output) && this.inventory[2].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        if (EnchanterManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            return this.curRecipe.getPrimaryInput().func_190916_E() <= this.inventory[1].func_190916_E() && this.curRecipe.getSecondaryInput().func_190916_E() <= this.inventory[0].func_190916_E();
        }
        return this.curRecipe.getPrimaryInput().func_190916_E() <= this.inventory[0].func_190916_E() && this.curRecipe.getSecondaryInput().func_190916_E() <= this.inventory[1].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = EnchanterManager.getRecipe(this.inventory[1], this.inventory[0]);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        this.tank.drain(this.curRecipe.getExperience(), true);
        ItemStack primaryItem = this.curRecipe.getOutput();
        if (this.inventory[2].func_190926_b()) {
            this.inventory[2] = ItemHelper.cloneStack((ItemStack)primaryItem);
        } else {
            this.inventory[2].func_190917_f(primaryItem.func_190916_E());
        }
        if (EnchanterManager.isRecipeReversed(this.inventory[0], this.inventory[1])) {
            this.inventory[1].func_190918_g(this.curRecipe.getPrimaryInput().func_190916_E());
            this.inventory[0].func_190918_g(this.curRecipe.getSecondaryInput().func_190916_E());
        } else {
            this.inventory[0].func_190918_g(this.curRecipe.getPrimaryInput().func_190916_E());
            this.inventory[1].func_190918_g(this.curRecipe.getSecondaryInput().func_190916_E());
        }
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
        if (this.inventory[1].func_190916_E() <= 0) {
            this.inventory[1] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        int side;
        int i;
        if (!this.getTransferIn()) {
            return;
        }
        for (i = this.inputTrackerPrimary + 1; i <= this.inputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerPrimary = side;
            break;
        }
        for (i = this.inputTrackerSecondary + 1; i <= this.inputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!SideConfig.isSecondaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTrackerSecondary = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.inventory[2].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.readPortableTagInternal(player, tag)) {
            return false;
        }
        this.lockPrimary = tag.func_74767_n("SlotLock");
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        if (!super.writePortableTagInternal(player, tag)) {
            return false;
        }
        tag.func_74757_a("SlotLock", this.lockPrimary);
        return true;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiEnchanter(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerEnchanter(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public void setMode(boolean mode) {
        boolean lastMode = this.lockPrimary;
        this.lockPrimary = mode;
        this.sendModePacket();
        this.lockPrimary = lastMode;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTrackerPrimary = nbt.func_74762_e("TrackIn");
        this.inputTrackerSecondary = nbt.func_74762_e("TrackIn2");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.lockPrimary = nbt.func_74767_n("SlotLock");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTrackerPrimary);
        nbt.func_74768_a("TrackIn2", this.inputTrackerSecondary);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74757_a("SlotLock", this.lockPrimary);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getModePacket() {
        PacketBase payload = super.getModePacket();
        payload.addBool(this.lockPrimary);
        return payload;
    }

    protected void handleModePacket(PacketBase payload) {
        super.handleModePacket(payload);
        this.lockPrimary = payload.getBool();
        this.callNeighborTileChange();
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.lockPrimary);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.lockPrimary = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentEmpowered = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentEmpowered && "machineEnchanterEmpowered".equals(id)) {
            this.augmentEmpowered = true;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.lockPrimary) {
            if (slot == 0) {
                return EnchanterManager.isItemArcana(stack);
            }
            if (slot == 1) {
                return !EnchanterManager.isItemArcana(stack) && EnchanterManager.isItemValid(stack);
            }
        }
        return slot > 1 || EnchanterManager.isItemValid(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.MACHINE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.MACHINE_TOP;
            }
            return side != this.facing ? TETextures.MACHINE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((Fluid)TFFluids.fluidExperience) : TETextures.MACHINE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.MACHINE_ACTIVE[TYPE] : TETextures.MACHINE_FACE[TYPE]);
        }
        return TETextures.MACHINE_SIDE;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileEnchanter.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TileEnchanter.this.tank.fill(TFFluids.getXPFluid((FluidStack)resource), doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TileEnchanter.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TileEnchanter)TileEnchanter.this).sideConfig.sideTypes[TileEnchanter.this.sideCache[from.ordinal()]])) {
                        return TileEnchanter.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TileEnchanter.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TileEnchanter)TileEnchanter.this).sideConfig.sideTypes[TileEnchanter.this.sideCache[from.ordinal()]])) {
                        return TileEnchanter.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

